/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class InvoiceCreateInOut
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_C_DocType_ID = 0;
    private int p_C_Invoice_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("C_Invoice_ID=" + this.p_C_Invoice_ID + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_DocType_ID=" + this.p_C_DocType_ID);
        if (this.p_C_Invoice_ID == 0) {
            throw new IllegalArgumentException("@NotFound@ @C_Invoice_ID@");
        }
        if (this.p_M_Warehouse_ID == 0) {
            throw new IllegalArgumentException("@NotFound@ @M_Warehouse_ID@");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("@NotFound@ @C_Invoice_ID@");
        }
        if (!"CO".equals(invoice.getDocStatus())) {
            throw new IllegalArgumentException("@InvoiceCreateDocNotCompleted@");
        }
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.p_C_DocType_ID);
        if (invoice.isSOTrx() != dt.isSOTrx() || invoice.isReturnTrx() != dt.isReturnTrx()) {
            throw new IllegalArgumentException("@C_DocType_ID@ <> @C_Invoice_ID@");
        }
        MInOut ship = new MInOut(invoice, this.p_C_DocType_ID, null, this.p_M_Warehouse_ID);
        if (!ship.save()) {
            throw new IllegalArgumentException("@SaveError@ Receipt");
        }
        MInvoiceLine[] invoiceLines = invoice.getLines(false);
        for (int i2 = 0; i2 < invoiceLines.length; ++i2) {
            MInvoiceLine invoiceLine = invoiceLines[i2];
            MInOutLine sLine = new MInOutLine(ship);
            sLine.setInvoiceLine(invoiceLine, 0, invoice.isSOTrx() ? invoiceLine.getQtyInvoiced() : Env.ZERO);
            sLine.setQtyEntered(invoiceLine.getQtyEntered());
            sLine.setMovementQty(invoiceLine.getQtyInvoiced());
            if (invoice.isCreditMemo()) {
                sLine.setQtyEntered(sLine.getQtyEntered().negate());
                sLine.setMovementQty(sLine.getMovementQty().negate());
            }
            if (!sLine.save()) {
                throw new IllegalArgumentException("@SaveError@ @M_InOutLine_ID@");
            }
            invoiceLine.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
            if (invoiceLine.save()) continue;
            throw new IllegalArgumentException("@SaveError@ @C_InvoiceLine_ID@");
        }
        return ship.getDocumentNo();
    }
}

