/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBankStatementLoader;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class LoadBankStatement
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_C_BankStmtLoader_ID = 0;
    private String fileName = "";
    private Ctx m_ctx;
    private MBankStatementLoader m_controller = null;

    public LoadBankStatement() {
        this.log.info("LoadBankStatement");
    }

    protected void prepare() {
        this.log.info("");
        this.m_ctx = Env.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("C_BankStatementLoader_ID")) {
                this.m_C_BankStmtLoader_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("FileName")) {
                this.fileName = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_AD_Client_ID = this.m_ctx.getAD_Client_ID();
        this.log.info("AD_Client_ID=" + this.m_AD_Client_ID);
        this.m_AD_Org_ID = this.m_ctx.getAD_Org_ID();
        this.log.info("AD_Org_ID=" + this.m_AD_Org_ID);
        this.log.info("C_BankStatementLoader_ID=" + this.m_C_BankStmtLoader_ID);
    }

    protected String doIt() throws Exception {
        this.log.info("LoadBankStatement.doIt");
        String message = "@Error@";
        this.m_controller = new MBankStatementLoader(this.m_ctx, this.m_C_BankStmtLoader_ID, this.fileName, this.get_TrxName());
        this.log.info(this.m_controller.toString());
        if (this.m_controller == null || this.m_controller.get_ID() == 0) {
            this.log.log(Level.SEVERE, "Invalid Loader");
        } else if (!this.m_controller.loadLines()) {
            this.log.log(Level.SEVERE, this.m_controller.getErrorMessage() + " - " + this.m_controller.getErrorDescription());
        } else {
            this.log.info("Imported=" + this.m_controller.getLoadCount());
            this.addLog(0, null, new BigDecimal(this.m_controller.getLoadCount()), "@Loaded@");
            message = "@OK@";
        }
        return message;
    }
}

