/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class OrgOwnership
extends SvrProcess {
    private int p_AD_Org_ID = -1;
    private int p_M_Warehouse_ID = -1;
    private int p_M_Product_Category_ID = -1;
    private int p_M_Product_ID = -1;
    private int p_C_BP_Group_ID = -1;
    private int p_C_BPartner_ID = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("doIt - AD_Org_ID=" + this.p_AD_Org_ID);
        if (this.p_AD_Org_ID < 0) {
            throw new IllegalArgumentException("OrgOwnership - invalid AD_Org_ID=" + this.p_AD_Org_ID);
        }
        this.generalOwnership();
        if (this.p_M_Warehouse_ID > 0) {
            return this.warehouseOwnership();
        }
        if (this.p_M_Product_ID > 0 || this.p_M_Product_Category_ID > 0) {
            return this.productOwnership();
        }
        if (this.p_C_BPartner_ID > 0 || this.p_C_BP_Group_ID > 0) {
            return this.bPartnerOwnership();
        }
        return "* Not supported * **";
    }

    private String warehouseOwnership() {
        this.log.info("warehouseOwnership - M_Warehouse_ID=" + this.p_M_Warehouse_ID);
        if (this.p_AD_Org_ID == 0) {
            throw new IllegalArgumentException("Warehouse - Org cannot be * (0)");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE M_Warehouse SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Warehouse_ID"));
        sql = new StringBuffer();
        sql.append("UPDATE M_Warehouse_Acct SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = new StringBuffer();
        sql.append("UPDATE M_Locator SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(" AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Locator_ID"));
        sql = new StringBuffer();
        sql.append("UPDATE M_Storage s SET AD_Org_ID=").append(this.p_AD_Org_ID).append(" WHERE EXISTS (SELECT * FROM M_Locator l WHERE l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(") AND AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND AD_Org_ID<>").append(this.p_AD_Org_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Storage"));
        return "";
    }

    private String productOwnership() {
        this.log.info("productOwnership - M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", M_Product_ID=" + this.p_M_Product_ID);
        String set = " SET AD_Org_ID=" + this.p_AD_Org_ID;
        set = this.p_M_Product_Category_ID > 0 ? set + " WHERE EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_ID=x.M_Product_ID AND p.M_Product_Category_ID=" + this.p_M_Product_Category_ID + ")" : set + " WHERE M_Product_ID=" + this.p_M_Product_ID;
        set = set + " AND AD_Client_ID=" + this.getAD_Client_ID() + " AND AD_Org_ID<>" + this.p_AD_Org_ID;
        this.log.fine("productOwnership - " + set);
        String sql = "UPDATE M_Product x " + set;
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Product_ID"));
        sql = "UPDATE M_Product_Acct x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = "UPDATE M_Product_BOM x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Product_BOM_ID"));
        sql = "UPDATE M_Product_PO x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"M_Product_PO"));
        sql = "UPDATE M_Product_Trl x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"AD_Language"));
        return "";
    }

    private String bPartnerOwnership() {
        this.log.info("bPartnerOwnership - C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        String set = " SET AD_Org_ID=" + this.p_AD_Org_ID;
        set = this.p_C_BP_Group_ID > 0 ? set + " WHERE EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=x.C_BPartner_ID AND bp.C_BP_Group_ID=" + this.p_C_BP_Group_ID + ")" : set + " WHERE C_BPartner_ID=" + this.p_C_BPartner_ID;
        set = set + " AND AD_Client_ID=" + this.getAD_Client_ID() + " AND AD_Org_ID<>" + this.p_AD_Org_ID;
        this.log.fine("bPartnerOwnership - " + set);
        String sql = "UPDATE C_BPartner x " + set;
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_BPartner_ID"));
        sql = "UPDATE C_BP_Customer_Acct x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = "UPDATE C_BP_Employee_Acct x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = "UPDATE C_BP_Vendor_Acct x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_AcctSchema_ID"));
        sql = "UPDATE C_BPartner_Location x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_BPartner_Location_ID"));
        sql = "UPDATE AD_User x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"AD_User_ID"));
        sql = "UPDATE C_BP_BankAccount x " + set;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), Msg.translate((Ctx)this.getCtx(), (String)"C_BP_BankAccount_ID"));
        return "";
    }

    private void generalOwnership() {
        String set = "SET AD_Org_ID=0 WHERE AD_Client_ID=" + this.getAD_Client_ID() + " AND AD_Org_ID<>0";
        String sql = "UPDATE R_ContactInterest " + set;
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 0) {
            this.log.fine("generalOwnership - R_ContactInterest=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE AD_User_Roles " + set), (String)this.get_TrxName())) != 0) {
            this.log.fine("generalOwnership - AD_User_Roles=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_BPartner_Product " + set), (String)this.get_TrxName())) != 0) {
            this.log.fine("generalOwnership - C_BPartner_Product=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_BP_Withholding x " + set), (String)this.get_TrxName())) != 0) {
            this.log.fine("generalOwnership - C_BP_Withholding=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_Costing " + set), (String)this.get_TrxName())) != 0) {
            this.log.fine("generalOwnership - M_Product_Costing=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Replenish " + set), (String)this.get_TrxName())) != 0) {
            this.log.fine("generalOwnership - M_Replenish=" + no);
        }
    }
}

