/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PaySelectionCreateFrom
extends SvrProcess {
    private boolean p_OnlyDiscount = false;
    private boolean p_OnlyDue = false;
    private boolean p_IncludeInDispute = false;
    private String p_MatchRequirementI = "N";
    private String p_PaymentRule = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_PaySelection_ID = 0;
    private String m_DocumentNo_From = null;
    private String m_DocumentNo_To = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("OnlyDiscount")) {
                this.p_OnlyDiscount = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("OnlyDue")) {
                this.p_OnlyDue = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IncludeInDispute")) {
                this.p_IncludeInDispute = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("MatchRequirementI")) {
                this.p_MatchRequirementI = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("PaymentRule")) {
                this.p_PaymentRule = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("DocumentNo")) {
                this.m_DocumentNo_From = (String)para[i2].getParameter();
                this.m_DocumentNo_To = (String)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_PaySelection_ID = this.getRecord_ID();
        if (this.m_DocumentNo_From != null && this.m_DocumentNo_From.length() == 0) {
            this.m_DocumentNo_From = null;
        }
        if (this.m_DocumentNo_To != null && this.m_DocumentNo_To.length() == 0) {
            this.m_DocumentNo_To = null;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", OnlyDiscount=" + this.p_OnlyDiscount + ", OnlyDue=" + this.p_OnlyDue + ", IncludeInDispute=" + this.p_IncludeInDispute + ", MatchRequirement=" + this.p_MatchRequirementI + ", PaymentRule=" + this.p_PaymentRule + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        MPaySelection psel = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (psel.get_ID() == 0) {
            throw new IllegalArgumentException("Not found C_PaySelection_ID=" + this.p_C_PaySelection_ID);
        }
        if (psel.isProcessed()) {
            throw new IllegalArgumentException("@Processed@");
        }
        String sql = "SELECT C_Invoice_ID, currencyConvert(invoiceOpen(i.C_Invoice_ID, 0),i.C_Currency_ID, ?,?, i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), PaymentRule, IsSOTrx FROM C_Invoice i WHERE IsSOTrx=? AND IsPaid='N' AND DocStatus IN ('CO','CL') AND AD_Client_ID=? AND NOT EXISTS (SELECT * FROM C_PaySelectionLine psl WHERE i.C_Invoice_ID=psl.C_Invoice_ID AND psl.IsActive='Y' AND psl.C_PaySelectionCheck_ID IS NOT NULL)";
        if (!this.p_IncludeInDispute) {
            sql = sql + " AND i.IsInDispute='N'";
        }
        if (this.p_PaymentRule != null) {
            sql = sql + " AND PaymentRule=?";
        }
        if (this.p_OnlyDiscount) {
            sql = this.p_OnlyDue ? sql + " AND (" : sql + " AND ";
            sql = sql + "paymentTermDiscount(invoiceOpen(C_Invoice_ID, 0), C_Currency_ID, C_PaymentTerm_ID, DateInvoiced, ?) > 0";
        }
        if (this.p_OnlyDue) {
            sql = this.p_OnlyDiscount ? sql + " OR " : sql + " AND ";
            sql = sql + "paymentTermDueDays(C_PaymentTerm_ID, DateInvoiced, ?) >= 0";
            if (this.p_OnlyDiscount) {
                sql = sql + ")";
            }
        }
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND C_BPartner_ID=?";
        } else if (this.p_C_BP_Group_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (this.p_MatchRequirementI.equals("P") || this.p_MatchRequirementI.equals("B")) {
            sql = sql + " AND i.p_MatchRequirementI NOT IN ('N','R') AND EXISTS (SELECT * FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND QtyInvoiced IN (SELECT SUM(Qty) FROM M_MatchPO m WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))";
        }
        if (this.p_MatchRequirementI.equals("R") || this.p_MatchRequirementI.equals("B")) {
            sql = sql + " AND i.p_MatchRequirementI NOT IN ('N','P') AND EXISTS (SELECT * FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND QtyInvoiced IN (SELECT SUM(Qty) FROM M_MatchInv m WHERE il.C_InvoiceLine_ID=m.C_InvoiceLine_ID))";
        } else if (this.m_DocumentNo_From != null && this.m_DocumentNo_To != null) {
            sql = sql + " AND i.DocumentNo BETWEEN " + DB.TO_STRING((String)this.m_DocumentNo_From) + " AND " + DB.TO_STRING((String)this.m_DocumentNo_To);
        } else if (this.m_DocumentNo_From != null) {
            sql = sql + " AND ";
            sql = this.m_DocumentNo_From.indexOf(37) == -1 ? sql + "i.DocumentNo >= " + DB.TO_STRING((String)this.m_DocumentNo_From) : sql + "i.DocumentNo LIKE " + DB.TO_STRING((String)this.m_DocumentNo_From);
        }
        int lines = 0;
        int C_CurrencyTo_ID = psel.getC_Currency_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int index = 1;
            pstmt.setInt(index++, C_CurrencyTo_ID);
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setTimestamp(index++, psel.getPayDate());
            pstmt.setInt(index++, C_CurrencyTo_ID);
            pstmt.setTimestamp(index++, psel.getPayDate());
            if (this.p_PaymentRule != null && this.p_PaymentRule.equals("D")) {
                pstmt.setString(index++, "Y");
            } else {
                pstmt.setString(index++, "N");
            }
            pstmt.setInt(index++, psel.getAD_Client_ID());
            if (this.p_PaymentRule != null) {
                pstmt.setString(index++, this.p_PaymentRule);
            }
            if (this.p_OnlyDiscount) {
                pstmt.setTimestamp(index++, psel.getPayDate());
            }
            if (this.p_OnlyDue) {
                pstmt.setTimestamp(index++, psel.getPayDate());
            }
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(index++, this.p_C_BP_Group_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Invoice_ID = rs.getInt(1);
                BigDecimal PayAmt = rs.getBigDecimal(2);
                if (C_Invoice_ID == 0 || Env.ZERO.compareTo(PayAmt) == 0) continue;
                BigDecimal DiscountAmt = rs.getBigDecimal(3);
                String PaymentRule = rs.getString(4);
                boolean isSOTrx = "Y".equals(rs.getString(5));
                MPaySelectionLine pselLine = new MPaySelectionLine(psel, ++lines * 10, PaymentRule);
                pselLine.setInvoice(C_Invoice_ID, isSOTrx, PayAmt, PayAmt.subtract(DiscountAmt), DiscountAmt);
                if (pselLine.save()) continue;
                pstmt.close();
                throw new IllegalStateException("Cannot save MPaySelectionLine");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@C_PaySelectionLine_ID@  - #" + lines;
    }
}

