/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereUserException;
import org.compiere.util.DB;

public class PriceListCreate
extends SvrProcess {
    private boolean p_DeleteOld = false;
    private int p_M_PriceList_Version_ID = 0;
    private MPriceListVersion m_plv = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("DeleteOld")) {
                this.p_DeleteOld = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_PriceList_Version_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + ", DeleteOld=" + this.p_DeleteOld);
        this.m_plv = new MPriceListVersion(this.getCtx(), this.p_M_PriceList_Version_ID, this.get_TrxName());
        if (this.m_plv.get_ID() == 0 || this.m_plv.get_ID() != this.p_M_PriceList_Version_ID) {
            throw new CompiereUserException("@NotFound@  @M_PriceList_Version_ID@=" + this.p_M_PriceList_Version_ID);
        }
        String error = this.checkPrerequisites();
        if (error != null && error.length() > 0) {
            throw new CompiereUserException(error);
        }
        return this.create();
    }

    private String checkPrerequisites() {
        String clientWhere = " AND AD_Client_ID=" + this.m_plv.getAD_Client_ID();
        int no = DB.executeUpdate((String)("UPDATE M_Product_PO SET PriceList = 0 WHERE PriceList IS NULL" + clientWhere), (String)this.get_TrxName());
        no = DB.executeUpdate((String)("UPDATE M_Product_PO SET PriceLastPO = 0 WHERE PriceLastPO IS NULL" + clientWhere), (String)this.get_TrxName());
        no = DB.executeUpdate((String)("UPDATE M_Product_PO SET PricePO = PriceLastPO WHERE (PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0" + clientWhere), (String)this.get_TrxName());
        no = DB.executeUpdate((String)("UPDATE\tM_Product_PO SET PricePO = 0 WHERE PricePO IS NULL" + clientWhere), (String)this.get_TrxName());
        no = DB.executeUpdate((String)("UPDATE M_Product_PO p SET IsCurrentVendor = 'Y' WHERE IsCurrentVendor = 'N' AND NOT EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE pp.M_Product_ID=p.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1)" + clientWhere), (String)this.get_TrxName());
        String sql = "SELECT * FROM M_Product_PO po WHERE IsCurrentVendor='Y' AND IsActive='Y'" + clientWhere + " AND EXISTS (SELECT M_Product_ID FROM M_Product_PO x " + "WHERE x.M_Product_ID=po.M_Product_ID" + " AND IsCurrentVendor='Y' AND IsActive='Y' " + "GROUP BY M_Product_ID HAVING COUNT(*) > 1) " + "ORDER BY M_Product_ID, Created";
        int success = 0;
        int errors = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int M_Product_ID = 0;
            while (rs.next()) {
                MProductPO po = new MProductPO(this.getCtx(), rs, this.get_TrxName());
                if (M_Product_ID != po.getM_Product_ID()) {
                    M_Product_ID = po.getM_Product_ID();
                    continue;
                }
                po.setIsCurrentVendor(false);
                if (po.save()) {
                    ++success;
                    continue;
                }
                ++errors;
                this.log.warning("Not updated " + (Object)((Object)po));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("Current Vendor - Changes=" + success + ", Errors=" + errors);
        return null;
    }

    private String create() throws Exception {
        StringBuffer info = new StringBuffer();
        if (this.p_DeleteOld) {
            int no = DB.executeUpdate((String)("DELETE M_ProductPrice WHERE M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID), (String)this.get_TrxName());
            this.log.info("Deleted=" + no);
            info.append("@Deleted@=").append(no).append(" - ");
        }
        int M_Pricelist_Version_Base_ID = this.m_plv.getM_Pricelist_Version_Base_ID();
        MPriceList pl = this.m_plv.getPriceList();
        int curPrecision = pl.getStandardPrecision();
        MDiscountSchema ds = new MDiscountSchema(this.getCtx(), this.m_plv.getM_DiscountSchema_ID(), this.get_TrxName());
        MDiscountSchemaLine[] dsl = ds.getLines(false);
        for (int i2 = 0; i2 < dsl.length; ++i2) {
            MDiscountSchemaLine dsLine = dsl[i2];
            String message = "#" + dsLine.getSeqNo();
            String dd = dsLine.getDescription();
            if (dd != null && dd.length() > 0) {
                message = message + " " + dd;
            }
            int noDeleted = DB.executeUpdate((String)"DELETE FROM T_Selection", (String)this.get_TrxName());
            String sql = null;
            int M_DiscountSchemaLine_ID = dsLine.getM_DiscountSchemaLine_ID();
            int p2 = M_Pricelist_Version_Base_ID;
            if (p2 == 0) {
                sql = "INSERT INTO T_Selection (T_Selection_ID) SELECT DISTINCT po.M_Product_ID FROM M_Product_PO po  INNER JOIN M_Product p ON (p.M_Product_ID=po.M_Product_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE p.AD_Client_ID IN (?, 0) AND p.IsActive='Y' AND po.IsActive='Y' AND po.IsCurrentVendor='Y' AND (dl.M_Product_Category_ID IS NULL OR p.M_Product_Category_ID=dl.M_Product_Category_ID) AND (dl.C_BPartner_ID IS NULL OR po.C_BPartner_ID=dl.C_BPartner_ID) AND (dl.M_Product_ID IS NULL OR p.M_Product_ID=dl.M_Product_ID)";
                p2 = dsLine.getAD_Client_ID();
            } else {
                sql = "INSERT INTO T_Selection (T_Selection_ID) SELECT DISTINCT p.M_Product_ID FROM M_ProductPrice pp INNER JOIN M_Product p ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE pp.M_PriceList_Version_ID=? AND p.IsActive='Y' AND pp.IsActive='Y' AND (dl.M_Product_Category_ID IS NULL OR p.M_Product_Category_ID=dl.M_Product_Category_ID) AND (dl.C_BPartner_ID IS NULL OR EXISTS (SELECT * FROM M_Product_PO po WHERE po.M_Product_ID=p.M_Product_ID AND po.C_BPartner_ID=dl.C_BPartner_ID)) AND (dl.M_Product_ID IS NULL OR p.M_Product_ID=dl.M_Product_ID)";
            }
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, M_DiscountSchemaLine_ID);
            pstmt.setInt(2, p2);
            int noSelected = pstmt.executeUpdate();
            pstmt.close();
            message = message + ": @Selected@=" + noSelected;
            if (M_Pricelist_Version_Base_ID == 0 || M_Pricelist_Version_Base_ID != this.p_M_PriceList_Version_ID) {
                sql = "DELETE FROM M_ProductPrice pp WHERE pp.M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + " AND EXISTS (SELECT * FROM T_Selection s WHERE pp.M_Product_ID=s.T_Selection_ID)";
                noDeleted = DB.executeUpdate((String)sql, (String)this.get_TrxName());
                message = message + ", @Deleted@=" + noDeleted;
            }
            int noInserted = 0;
            sql = "INSERT INTO M_ProductPrice (M_PriceList_Version_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, PriceList, PriceStd, PriceLimit) ";
            sql = M_Pricelist_Version_Base_ID == this.p_M_PriceList_Version_ID ? null : (M_Pricelist_Version_Base_ID == 0 ? sql + "SELECT plv.M_PriceList_Version_ID, po.M_Product_ID, plv.AD_Client_ID, plv.AD_Org_ID, 'Y', SysDate, plv.UpdatedBy, SysDate, plv.UpdatedBy, COALESCE(currencyConvert(po.PriceList, po.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -po.PriceList), COALESCE(currencyConvert(po.PriceList,\tpo.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -po.PriceList), COALESCE(currencyConvert(po.PricePO, po.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -po.PricePO) FROM M_Product_PO po INNER JOIN M_PriceList_Version plv ON (plv.M_PriceList_Version_ID=?) INNER JOIN M_PriceList pl ON (pl.M_PriceList_ID=plv.M_PriceList_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE EXISTS (SELECT * FROM T_Selection s WHERE po.M_Product_ID=s.T_Selection_ID) AND po.IsCurrentVendor='Y' AND po.IsActive='Y'" : sql + "SELECT plv.M_PriceList_Version_ID, pp.M_Product_ID, plv.AD_Client_ID, plv.AD_Org_ID, 'Y', SysDate, plv.UpdatedBy, SysDate, plv.UpdatedBy, COALESCE(currencyConvert(pp.PriceList, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -pp.PriceList), COALESCE(currencyConvert(pp.PriceStd, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -pp.PriceStd), COALESCE(currencyConvert(pp.PriceLimit, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), -pp.PriceLimit) FROM M_ProductPrice pp INNER JOIN M_PriceList_Version plv ON (plv.M_PriceList_Version_ID=?) INNER JOIN M_PriceList pl ON (pl.M_PriceList_ID=plv.M_PriceList_ID) INNER JOIN M_PriceList_Version bplv ON (pp.M_PriceList_Version_ID=bplv.M_PriceList_Version_ID) INNER JOIN M_PriceList bpl ON (bplv.M_PriceList_ID=bpl.M_PriceList_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE pp.M_PriceList_Version_ID=? AND EXISTS (SELECT * FROM T_Selection s WHERE pp.M_Product_ID=s.T_Selection_ID) AND pp.IsActive='Y'");
            if (sql != null) {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.p_M_PriceList_Version_ID);
                pstmt.setInt(2, M_DiscountSchemaLine_ID);
                if (M_Pricelist_Version_Base_ID != 0) {
                    pstmt.setInt(3, M_Pricelist_Version_Base_ID);
                }
                noInserted = pstmt.executeUpdate();
                pstmt.close();
                message = message + " @Inserted@=" + noInserted;
            }
            MProductPrice[] pp = this.m_plv.getProductPrice("AND EXISTS (SELECT * FROM T_Selection s WHERE s.T_Selection_ID=M_ProductPrice.M_Product_ID)");
            for (int j = 0; j < pp.length; ++j) {
                MProductPrice price = pp[j];
                BigDecimal priceList = price.getPriceList();
                BigDecimal priceStd = price.getPriceStd();
                BigDecimal priceLimit = price.getPriceLimit();
                price.setPriceList(this.calculate(dsLine.getList_Base(), priceList, priceStd, priceLimit, dsLine.getList_Fixed(), dsLine.getList_AddAmt(), dsLine.getList_Discount(), dsLine.getList_Rounding(), curPrecision));
                price.setPriceStd(this.calculate(dsLine.getStd_Base(), priceList, priceStd, priceLimit, dsLine.getStd_Fixed(), dsLine.getStd_AddAmt(), dsLine.getStd_Discount(), dsLine.getStd_Rounding(), curPrecision));
                price.setPriceLimit(this.calculate(dsLine.getLimit_Base(), priceList, priceStd, priceLimit, dsLine.getLimit_Fixed(), dsLine.getLimit_AddAmt(), dsLine.getLimit_Discount(), dsLine.getLimit_Rounding(), curPrecision));
                price.save();
            }
            noDeleted = DB.executeUpdate((String)"DELETE FROM T_Selection", (String)this.get_TrxName());
            this.addLog(message);
        }
        MProductPrice[] pp = this.m_plv.getProductPrice(true);
        info.append(" - @Records@=").append(pp.length);
        return info.toString();
    }

    private BigDecimal calculate(String base, BigDecimal list, BigDecimal std, BigDecimal limit, BigDecimal fix, BigDecimal add, BigDecimal discount, String round, int curPrecision) {
        BigDecimal calc = null;
        double dd = 0.0;
        if ("L".equals(base)) {
            dd = list.doubleValue();
        } else if ("S".equals(base)) {
            dd = std.doubleValue();
        } else if ("X".equals(base)) {
            dd = limit.doubleValue();
        } else if ("F".equals(base)) {
            calc = fix;
        } else {
            throw new IllegalArgumentException("Unknown Base=" + base);
        }
        if (calc == null) {
            if (add.signum() != 0) {
                dd += add.doubleValue();
            }
            if (discount.signum() != 0) {
                dd *= 1.0 - discount.doubleValue() / 100.0;
            }
            calc = new BigDecimal(dd);
        }
        if ("C".equals(round)) {
            calc = calc.setScale(curPrecision, 4);
        } else if ("D".equals(round)) {
            calc = calc.setScale(1, 4);
        } else if ("h".equals(round)) {
            calc = calc.setScale(-2, 4);
        } else if ("5".equals(round)) {
            BigDecimal mm = new BigDecimal(20);
            calc = calc.multiply(mm);
            calc = calc.setScale(0, 4);
            calc = calc.divide(mm, 2, 4);
        } else if (!"N".equals(round)) {
            if ("Q".equals(round)) {
                BigDecimal mm = new BigDecimal(4);
                calc = calc.multiply(mm);
                calc = calc.setScale(0, 4);
                calc = calc.divide(mm, 2, 4);
            } else if ("T".equals(round)) {
                calc = calc.setScale(-1, 4);
            } else if ("t".equals(round)) {
                calc = calc.setScale(-3, 4);
            } else if ("0".equals(round)) {
                calc = calc.setScale(0, 4);
            }
        }
        return calc;
    }
}

