/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MStorage;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ProjectIssue
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_M_InOut_ID = 0;
    private int m_S_TimeExpense_ID = 0;
    private int m_M_Locator_ID = 0;
    private int m_C_ProjectLine_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private BigDecimal m_MovementQty = null;
    private Timestamp m_MovementDate = null;
    private String m_Description = null;
    private MProject m_project = null;
    private MProjectIssue[] m_projectIssues = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_Project_ID")) {
                this.m_C_Project_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_InOut_ID")) {
                this.m_M_InOut_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("S_TimeExpense_ID")) {
                this.m_S_TimeExpense_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Locator_ID")) {
                this.m_M_Locator_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ProjectLine_ID")) {
                this.m_C_ProjectLine_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.m_M_Product_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_AttributeSetInstance_ID")) {
                this.m_M_AttributeSetInstance_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("MovementQty")) {
                this.m_MovementQty = (BigDecimal)para[i2].getParameter();
                continue;
            }
            if (name.equals("MovementDate")) {
                this.m_MovementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("Description")) {
                this.m_Description = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.m_project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        if (!"W".equals(this.m_project.getProjectCategory()) && !"A".equals(this.m_project.getProjectCategory())) {
            throw new IllegalArgumentException("Project not Work Order or Asset =" + this.m_project.getProjectCategory());
        }
        this.log.info(this.m_project.toString());
        if (this.m_M_InOut_ID != 0) {
            return this.issueReceipt();
        }
        if (this.m_S_TimeExpense_ID != 0) {
            return this.issueExpense();
        }
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("Locator missing");
        }
        if (this.m_C_ProjectLine_ID != 0) {
            return this.issueProjectLine();
        }
        return this.issueInventory();
    }

    private String issueReceipt() {
        MInOut inOut = new MInOut(this.getCtx(), this.m_M_InOut_ID, null);
        if (inOut.isSOTrx() || !inOut.isProcessed() || !"CO".equals(inOut.getDocStatus()) && !"CL".equals(inOut.getDocStatus())) {
            throw new IllegalArgumentException("Receipt not valid - " + (Object)((Object)inOut));
        }
        this.log.info(inOut.toString());
        if (inOut.getC_Project_ID() == 0) {
            inOut.setC_Project_ID(this.m_project.getC_Project_ID());
            inOut.save();
        } else if (inOut.getC_Project_ID() != this.m_project.getC_Project_ID()) {
            throw new IllegalArgumentException("Receipt for other Project (" + inOut.getC_Project_ID() + ")");
        }
        MInOutLine[] inOutLines = inOut.getLines(false);
        int counter = 0;
        for (int i2 = 0; i2 < inOutLines.length; ++i2) {
            if (inOutLines[i2].getM_Product_ID() == 0 || inOutLines[i2].getMovementQty() == null || inOutLines[i2].getMovementQty().signum() == 0 || this.projectIssueHasReceipt(inOutLines[i2].getM_InOutLine_ID())) continue;
            MProjectIssue pi = new MProjectIssue(this.m_project);
            pi.setMandatory(inOutLines[i2].getM_Locator_ID(), inOutLines[i2].getM_Product_ID(), inOutLines[i2].getMovementQty());
            if (this.m_MovementDate != null) {
                pi.setMovementDate(this.m_MovementDate);
            }
            if (this.m_Description != null && this.m_Description.length() > 0) {
                pi.setDescription(this.m_Description);
            } else if (inOutLines[i2].getDescription() != null) {
                pi.setDescription(inOutLines[i2].getDescription());
            } else if (inOut.getDescription() != null) {
                pi.setDescription(inOut.getDescription());
            }
            pi.setM_InOutLine_ID(inOutLines[i2].getM_InOutLine_ID());
            pi.process();
            MProjectLine pl = null;
            MProjectLine[] pls = this.m_project.getLines();
            for (int ii = 0; ii < pls.length; ++ii) {
                if (pls[ii].getC_OrderPO_ID() != inOut.getC_Order_ID() || pls[ii].getM_Product_ID() != inOutLines[i2].getM_Product_ID() || pls[ii].getC_ProjectIssue_ID() != 0) continue;
                pl = pls[ii];
                break;
            }
            if (pl == null) {
                pl = new MProjectLine(this.m_project);
            }
            pl.setMProjectIssue(pi);
            pl.save();
            this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
            ++counter;
        }
        return "@Created@ " + counter;
    }

    private String issueExpense() {
        MTimeExpense expense = new MTimeExpense(this.getCtx(), this.m_S_TimeExpense_ID, this.get_TrxName());
        if (!expense.isProcessed()) {
            throw new IllegalArgumentException("Time+Expense not processed - " + (Object)((Object)expense));
        }
        MTimeExpenseLine[] expenseLines = expense.getLines(false);
        int counter = 0;
        for (int i2 = 0; i2 < expenseLines.length; ++i2) {
            if (expenseLines[i2].getM_Product_ID() == 0 || expenseLines[i2].getQty() == null || expenseLines[i2].getQty().signum() == 0 || expenseLines[i2].getC_Project_ID() != this.m_project.getC_Project_ID() || this.projectIssueHasExpense(expenseLines[i2].getS_TimeExpenseLine_ID())) continue;
            int M_Locator_ID = 0;
            M_Locator_ID = MStorage.getM_Locator_ID(expense.getM_Warehouse_ID(), expenseLines[i2].getM_Product_ID(), 0, expenseLines[i2].getQty(), null);
            if (M_Locator_ID == 0) {
                M_Locator_ID = expense.getM_Locator_ID();
            }
            MProjectIssue pi = new MProjectIssue(this.m_project);
            pi.setMandatory(M_Locator_ID, expenseLines[i2].getM_Product_ID(), expenseLines[i2].getQty());
            if (this.m_MovementDate != null) {
                pi.setMovementDate(this.m_MovementDate);
            }
            if (this.m_Description != null && this.m_Description.length() > 0) {
                pi.setDescription(this.m_Description);
            } else if (expenseLines[i2].getDescription() != null) {
                pi.setDescription(expenseLines[i2].getDescription());
            }
            pi.setS_TimeExpenseLine_ID(expenseLines[i2].getS_TimeExpenseLine_ID());
            pi.process();
            MProjectLine pl = new MProjectLine(this.m_project);
            pl.setMProjectIssue(pi);
            pl.save();
            this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
            ++counter;
        }
        return "@Created@ " + counter;
    }

    private String issueProjectLine() {
        MProjectLine pl = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
        if (pl.getM_Product_ID() == 0) {
            throw new IllegalArgumentException("Projet Line has no Product");
        }
        if (pl.getC_ProjectIssue_ID() != 0) {
            throw new IllegalArgumentException("Projet Line already been issued");
        }
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (pl.getPlannedQty() == null || pl.getPlannedQty().signum() == 0) {
            pl.setPlannedQty(Env.ONE);
        }
        MProjectIssue pi = new MProjectIssue(this.m_project);
        pi.setMandatory(this.m_M_Locator_ID, pl.getM_Product_ID(), pl.getPlannedQty());
        if (this.m_MovementDate != null) {
            pi.setMovementDate(this.m_MovementDate);
        }
        if (this.m_Description != null && this.m_Description.length() > 0) {
            pi.setDescription(this.m_Description);
        } else if (pl.getDescription() != null) {
            pi.setDescription(pl.getDescription());
        }
        pi.process();
        pl.setMProjectIssue(pi);
        pl.save();
        this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
        return "@Created@ 1";
    }

    private String issueInventory() {
        if (this.m_M_Locator_ID == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        if (this.m_M_Product_ID == 0) {
            throw new IllegalArgumentException("No Product");
        }
        if (this.m_MovementQty == null || this.m_MovementQty.signum() == 0) {
            this.m_MovementQty = Env.ONE;
        }
        MProjectIssue pi = new MProjectIssue(this.m_project);
        pi.setMandatory(this.m_M_Locator_ID, this.m_M_Product_ID, this.m_MovementQty);
        if (this.m_MovementDate != null) {
            pi.setMovementDate(this.m_MovementDate);
        }
        if (this.m_Description != null && this.m_Description.length() > 0) {
            pi.setDescription(this.m_Description);
        }
        pi.process();
        MProjectLine pl = new MProjectLine(this.m_project);
        pl.setMProjectIssue(pi);
        pl.save();
        this.addLog(pi.getLine(), pi.getMovementDate(), pi.getMovementQty(), null);
        return "@Created@ 1";
    }

    private boolean projectIssueHasExpense(int S_TimeExpenseLine_ID) {
        if (this.m_projectIssues == null) {
            this.m_projectIssues = this.m_project.getIssues();
        }
        for (int i2 = 0; i2 < this.m_projectIssues.length; ++i2) {
            if (this.m_projectIssues[i2].getS_TimeExpenseLine_ID() != S_TimeExpenseLine_ID) continue;
            return true;
        }
        return false;
    }

    private boolean projectIssueHasReceipt(int M_InOutLine_ID) {
        if (this.m_projectIssues == null) {
            this.m_projectIssues = this.m_project.getIssues();
        }
        for (int i2 = 0; i2 < this.m_projectIssues.length; ++i2) {
            if (this.m_projectIssues[i2].getM_InOutLine_ID() != M_InOutLine_ID) continue;
            return true;
        }
        return false;
    }
}

