/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.DB;

public class RequestInvoice
extends SvrProcess {
    private int p_R_RequestType_ID = 0;
    private int p_R_Group_ID = 0;
    private int p_R_Category_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private MInvoice m_invoice = null;
    private int m_linecount = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("R_RequestType_ID")) {
                this.p_R_RequestType_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("R_Group_ID")) {
                this.p_R_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("R_Category_ID")) {
                this.p_R_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("R_RequestType_ID=" + this.p_R_RequestType_ID + ", R_Group_ID=" + this.p_R_Group_ID + ", R_Category_ID=" + this.p_R_Category_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", p_M_Product_ID=" + this.p_M_Product_ID);
        MRequestType type = MRequestType.get(this.getCtx(), this.p_R_RequestType_ID);
        if (type.get_ID() == 0) {
            throw new CompiereSystemException("@R_RequestType_ID@ @NotFound@ " + this.p_R_RequestType_ID);
        }
        if (!type.isInvoiced()) {
            throw new CompiereSystemException("@R_RequestType_ID@ <> @IsInvoiced@");
        }
        String sql = "SELECT * FROM R_Request r INNER JOIN R_Status s ON (r.R_Status_ID=s.R_Status_ID) WHERE s.IsClosed='Y' AND r.R_RequestType_ID=?";
        if (this.p_R_Group_ID != 0) {
            sql = sql + " AND r.R_Group_ID=?";
        }
        if (this.p_R_Category_ID != 0) {
            sql = sql + " AND r.R_Category_ID=?";
        }
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND r.C_BPartner_ID=?";
        }
        sql = sql + " AND r.IsInvoiced='Y' ORDER BY C_BPartner_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int index = 1;
            pstmt.setInt(index++, this.p_R_RequestType_ID);
            if (this.p_R_Group_ID != 0) {
                pstmt.setInt(index++, this.p_R_Group_ID);
            }
            if (this.p_R_Category_ID != 0) {
                pstmt.setInt(index++, this.p_R_Category_ID);
            }
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            int oldC_BPartner_ID = 0;
            while (rs.next()) {
                MRequest request = new MRequest(this.getCtx(), rs, this.get_TrxName());
                if (!request.isInvoiced()) continue;
                if (oldC_BPartner_ID != request.getC_BPartner_ID()) {
                    this.invoiceDone();
                }
                if (this.m_invoice == null) {
                    this.invoiceNew(request);
                    oldC_BPartner_ID = request.getC_BPartner_ID();
                }
                this.invoiceLine(request);
            }
            this.invoiceDone();
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return null;
    }

    private void invoiceDone() {
        if (this.m_invoice != null) {
            if (this.m_linecount == 0) {
                this.m_invoice.delete(false);
            } else {
                this.m_invoice.processIt("PR");
                this.m_invoice.save();
                this.addLog(0, null, this.m_invoice.getGrandTotal(), this.m_invoice.getDocumentNo());
            }
        }
        this.m_invoice = null;
    }

    private void invoiceNew(MRequest request) {
        this.m_invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        this.m_invoice.setC_DocTypeTarget_ID("ARI");
        MBPartner partner = new MBPartner(this.getCtx(), request.getC_BPartner_ID(), null);
        this.m_invoice.setBPartner(partner);
        this.m_invoice.save();
        this.m_linecount = 0;
    }

    private void invoiceLine(MRequest request) {
        MRequestUpdate[] updates = request.getUpdates(null);
        for (int i2 = 0; i2 < updates.length; ++i2) {
            BigDecimal qty = updates[i2].getQtyInvoiced();
            if (qty == null || qty.signum() == 0) continue;
            MInvoiceLine il = new MInvoiceLine(this.m_invoice);
            ++this.m_linecount;
            il.setLine(this.m_linecount * 10);
            il.setQty(qty);
            int M_Product_ID = updates[i2].getM_ProductSpent_ID();
            if (M_Product_ID == 0) {
                M_Product_ID = this.p_M_Product_ID;
            }
            il.setM_Product_ID(M_Product_ID);
            il.setPrice();
            il.save();
        }
    }
}

