/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCreatePO
extends SvrProcess {
    private int p_C_RfQ_ID = 0;
    private int p_C_DocType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info(rfq.toString());
        MRfQResponse[] responses = rfq.getResponses(true, true);
        this.log.config("#Responses=" + responses.length);
        if (responses.length == 0) {
            throw new IllegalArgumentException("No completed RfQ Responses found");
        }
        for (int i2 = 0; i2 < responses.length; ++i2) {
            MRfQResponse response = responses[i2];
            if (!response.isSelectedWinner()) continue;
            MBPartner bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
            this.log.config("Winner=" + (Object)((Object)bp));
            MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            order.setIsSOTrx(false);
            if (this.p_C_DocType_ID != 0) {
                order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
            } else {
                order.setC_DocTypeTarget_ID();
            }
            order.setBPartner(bp);
            order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
            order.setSalesRep_ID(rfq.getSalesRep_ID());
            if (response.getDateWorkComplete() != null) {
                order.setDatePromised(response.getDateWorkComplete());
            } else if (rfq.getDateWorkComplete() != null) {
                order.setDatePromised(rfq.getDateWorkComplete());
            }
            order.save();
            MRfQResponseLine[] lines = response.getLines(false);
            for (int j = 0; j < lines.length; ++j) {
                MRfQResponseLine line = lines[j];
                if (!line.isActive()) continue;
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int k = 0; k < qtys.length; ++k) {
                    MRfQResponseLineQty qty = qtys[k];
                    if (!qty.getRfQLineQty().isActive() || !qty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine ol = new MOrderLine(order);
                    ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                    ol.setDescription(line.getDescription());
                    ol.setQty(qty.getRfQLineQty().getQty());
                    BigDecimal price = qty.getNetAmt();
                    ol.setPrice(price);
                    ol.save();
                }
            }
            response.setC_Order_ID(order.getC_Order_ID());
            response.save();
            return order.getDocumentNo();
        }
        int noOrders = 0;
        for (int i3 = 0; i3 < responses.length; ++i3) {
            MRfQResponse response = responses[i3];
            MBPartner bp = null;
            MOrder order = null;
            MRfQResponseLine[] lines = response.getLines(false);
            for (int j = 0; j < lines.length; ++j) {
                MRfQResponseLine line = lines[j];
                if (!line.isActive() || !line.isSelectedWinner()) continue;
                if (bp == null) {
                    bp = new MBPartner(this.getCtx(), response.getC_BPartner_ID(), this.get_TrxName());
                    order = null;
                }
                this.log.config("Line=" + (Object)((Object)line) + ", Winner=" + (Object)((Object)bp));
                if (order == null) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setIsSOTrx(false);
                    order.setC_DocTypeTarget_ID();
                    order.setBPartner(bp);
                    order.setC_BPartner_Location_ID(response.getC_BPartner_Location_ID());
                    order.setSalesRep_ID(rfq.getSalesRep_ID());
                    order.save();
                    ++noOrders;
                    this.addLog(0, null, null, order.getDocumentNo());
                }
                MRfQResponseLineQty[] qtys = line.getQtys(false);
                for (int k = 0; k < qtys.length; ++k) {
                    MRfQResponseLineQty qty = qtys[k];
                    if (!qty.getRfQLineQty().isActive() || !qty.getRfQLineQty().isPurchaseQty()) continue;
                    MOrderLine ol = new MOrderLine(order);
                    ol.setM_Product_ID(line.getRfQLine().getM_Product_ID(), qty.getRfQLineQty().getC_UOM_ID());
                    ol.setDescription(line.getDescription());
                    ol.setQty(qty.getRfQLineQty().getQty());
                    BigDecimal price = qty.getNetAmt();
                    ol.setPriceActual(price);
                    ol.save();
                }
            }
            if (order == null) continue;
            response.setC_Order_ID(order.getC_Order_ID());
            response.save();
        }
        return "#" + noOrders;
    }
}

