/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.MViewComponent;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.ViewUtil;

public class ViewImport
extends SvrProcess {
    private String SQLfile = null;
    private String entityType = null;

    private static String replace(String sin, char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = sin.length();
            int i2 = -1;
            char[] val = sin.toCharArray();
            int off = 0;
            while (++i2 < len && val[off + i2] != oldChar) {
            }
            if (i2 < len) {
                char[] buf = new char[len];
                for (int j = 0; j < i2; ++j) {
                    buf[j] = val[off + j];
                }
                while (i2 < len) {
                    char c = val[off + i2];
                    buf[i2] = c == oldChar ? newChar : c;
                    ++i2;
                }
                return new String(buf);
            }
        }
        return sin;
    }

    public void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("EntityType")) {
                this.entityType = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("SQLfile")) {
                this.SQLfile = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    private String trim(String s) {
        int st;
        int len;
        int count = len = s.length();
        int off = 0;
        char[] val = s.toCharArray();
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        while (st < len && val[off + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < count ? s.substring(st, len) : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doIt() throws Exception {
        int viewNum = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.SQLfile);
        }
        catch (IOException e) {
            this.log.severe(e.getMessage());
            throw new CompiereUserException("SQL file error. file name = " + this.SQLfile);
        }
        if (in == null) {
            throw new CompiereUserException("SQL file error. file name = " + this.SQLfile);
        }
        ArrayList<String> commands = ViewUtil.readSqlFromFile(in);
        if (commands == null) {
            throw new CompiereUserException("SQL file error. file name = " + this.SQLfile);
        }
        String tableName = null;
        ArrayList<String> colName = new ArrayList<String>();
        ArrayList<String> colSQL = new ArrayList<String>();
        ArrayList<String> colType = new ArrayList<String>();
        Trx myTrx = Trx.get((String)"ImportView", (boolean)true);
        String Acommand = null;
        try {
            Iterator<String> i$ = commands.iterator();
            while (i$.hasNext()) {
                block51: {
                    MTable mt;
                    int iSel;
                    boolean colNameDone;
                    String command;
                    block48: {
                        block49: {
                            block52: {
                                block53: {
                                    block50: {
                                        Acommand = command = i$.next();
                                        colNameDone = false;
                                        int ir = command.indexOf(9);
                                        while (ir > 0) {
                                            command = ViewImport.replace(command, '\t', ' ');
                                            ir = command.indexOf(9);
                                        }
                                        if (command.equalsIgnoreCase("exit")) {
                                            return "Imported View #" + viewNum;
                                        }
                                        if (command.startsWith("DROP VIEW ")) continue;
                                        tableName = null;
                                        colName.clear();
                                        int iView = command.indexOf(" VIEW ");
                                        if (!command.startsWith("CREATE") || iView <= 0) break block49;
                                        iSel = command.indexOf("SELECT ");
                                        String tc = command.substring(iView + 6, iSel);
                                        int ileft = tc.indexOf(40);
                                        int iright = tc.indexOf(41);
                                        if (ileft > 0) {
                                            String[] colNames;
                                            tableName = tc.substring(0, ileft);
                                            for (String cn : colNames = tc.substring(ileft + 1, iright).split(",")) {
                                                colName.add(this.trim(cn));
                                            }
                                            colNameDone = true;
                                        } else {
                                            tableName = tc.substring(0, tc.indexOf(" AS "));
                                        }
                                        if (tableName != null) {
                                            tableName = this.trim(tableName);
                                        }
                                        if (tableName == null || tableName.length() == 0) {
                                            this.log.severe("No view name from the SQL: " + command);
                                            continue;
                                        }
                                        mt = MTable.get((Ctx)Env.getCtx(), (String)tableName);
                                        if (mt == null || mt.isView()) break block50;
                                        this.log.severe("Duplicated view name with an existing table for the SQL: " + command);
                                        break block51;
                                    }
                                    if (mt != null) break block52;
                                    mt = new MTable(Env.getCtx(), 0, null);
                                    mt.setTableName(tableName);
                                    mt.setAccessLevel("3");
                                    mt.setEntityType(this.entityType);
                                    mt.setIsActive(true);
                                    mt.setIsView(true);
                                    mt.setName("View_" + tableName);
                                    mt.setLoadSeq(900);
                                    mt.setImportTable(null);
                                    if (mt.save()) break block53;
                                    this.log.severe("Unable to insert into AD_Table for the SQL: " + command);
                                    break block51;
                                }
                                this.log.info("Add " + tableName + " into AD_Table for the SQL: " + command);
                            }
                            String vcdel = "DELETE FROM AD_ViewComponent WHERE AD_Table_ID*10000+AD_Client_ID IN (SELECT AD_Table_ID*10000+AD_Client_ID FROM AD_Table WHERE TableName = '" + tableName + "')";
                            try {
                                int no = DB.executeUpdate((String)vcdel, null);
                                break block48;
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, vcdel, (Throwable)e);
                            }
                            break block48;
                        }
                        this.log.warning("Ignore non create view SQL: " + command);
                        continue;
                    }
                    command = command.substring(iSel);
                    String[] selects = command.split("UNION ");
                    int i2 = 0;
                    block13: while (true) {
                        String[] cols;
                        int iFrom;
                        if (i2 < selects.length) {
                            iFrom = selects[i2].lastIndexOf(" FROM  ");
                            if (iFrom < 0) {
                                this.log.severe("No from clause from the SQL: " + command);
                                break;
                            }
                            colSQL.clear();
                            colType.clear();
                            int isel = selects[i2].indexOf("SELECT ");
                            String colstr = selects[i2].substring(isel + 7, iFrom);
                            cols = colstr.split(", ");
                            if (cols.length == 0) {
                                this.log.severe("No view column from the SQL: " + command);
                                break;
                            }
                        } else {
                            this.log.info("Impored view: " + tableName);
                            break;
                        }
                        for (int j = 0; j < cols.length; ++j) {
                            int iAS = cols[j].lastIndexOf(" AS ");
                            String cs = null;
                            if (iAS > 0) {
                                if (i2 == 0 && !colNameDone) {
                                    colName.add(cols[j].substring(iAS + 4, cols[j].length()).trim());
                                }
                                cs = cols[j].substring(0, iAS);
                            } else {
                                cs = cols[j];
                                if (i2 == 0 && !colNameDone) {
                                    int iDot = cols[j].indexOf(46);
                                    String cn = cols[j];
                                    if (iDot > 0) {
                                        cn = cols[j].substring(iDot + 1, cols[j].length()).trim();
                                    }
                                    colName.add(cn);
                                }
                            }
                            cs.trim();
                            if (cs.equalsIgnoreCase("NULLIF(1,1)")) {
                                cs = null;
                                colType.add("I");
                            } else if (cs.equalsIgnoreCase("NULLIF('A','A')")) {
                                cs = null;
                                colType.add("V");
                            } else {
                                colType.add(null);
                            }
                            colSQL.add(cs);
                        }
                        String from = selects[i2].substring(iFrom + 1, selects[i2].length());
                        int iWH = from.indexOf(" WHERE ");
                        String where = null;
                        String others = null;
                        int iGROUP = -1;
                        int iORDER = -1;
                        if (iWH > 0) {
                            where = from.substring(iWH + 1, from.length());
                            from = from.substring(0, iWH);
                            iGROUP = where.indexOf(" GROUP BY ");
                            iORDER = where.indexOf(" ORDER BY ");
                            if (iORDER > 0 && iGROUP == -1) {
                                iGROUP = iORDER;
                            }
                            if (iGROUP > 0) {
                                others = where.substring(iGROUP + 1, where.length());
                                where = where.substring(0, iGROUP);
                            }
                        } else {
                            iGROUP = from.indexOf(" GROUP BY ");
                            iORDER = from.indexOf(" ORDER BY ");
                            if (iORDER > 0 && iGROUP == -1) {
                                iGROUP = iORDER;
                            }
                            if (iGROUP > 0) {
                                others = from.substring(iGROUP + 1, from.length());
                                from = from.substring(0, iGROUP);
                            }
                        }
                        if (from == null || from.length() == 0) {
                            this.log.severe("No from clause from the SQL: " + command);
                            break;
                        }
                        MViewComponent mvc = new MViewComponent(Env.getCtx(), 0, null);
                        mvc.setName("VC_" + tableName);
                        mvc.setAD_Table_ID(mt.get_ID());
                        mvc.setSeqNo((i2 + 1) * 10);
                        mvc.setIsActive(true);
                        mvc.setEntityType(this.entityType);
                        String from1 = from.substring(6);
                        from1 = this.trim(from1);
                        int rtix = from1.indexOf(32);
                        if (rtix < 0) {
                            rtix = from1.length();
                        }
                        String refTab = from1.substring(0, rtix);
                        refTab = this.trim(refTab);
                        MTable rt = MTable.get((Ctx)Env.getCtx(), (String)refTab);
                        if (rt != null) {
                            mvc.setReferenced_Table_ID(rt.get_ID());
                        } else {
                            mvc.setReferenced_Table_ID(0);
                        }
                        mvc.setFromClause(from);
                        mvc.setWhereClause(where);
                        mvc.setOtherClause(others);
                        if (!mvc.save()) {
                            this.log.severe("unable to create view component " + i2 + ": " + command);
                            break;
                        }
                        MViewColumn mvcol = null;
                        for (int j = 0; j < colName.size(); ++j) {
                            mvcol = new MViewColumn(Env.getCtx(), 0, null);
                            mvcol.setAD_ViewComponent_ID(mvc.get_ID());
                            mvcol.setIsActive(true);
                            mvcol.setEntityType(this.entityType);
                            this.log.info("Importing View " + tableName + "(i,j) = (" + i2 + ", " + j + ")");
                            mvcol.setDBDataType((String)colType.get(j));
                            mvcol.setColumnName((String)colName.get(j));
                            mvcol.setColumnSQL((String)colSQL.get(j));
                            if (mvcol.save()) continue;
                            this.log.severe("unable to create view component " + i2 + " column: " + (String)colName.get(j) + " in " + command);
                            break block13;
                        }
                        ++i2;
                    }
                }
                ++viewNum;
            }
            return "Imported View #" + viewNum;
        }
        catch (Exception e) {
            this.log.severe("Error at importing view SQL: " + Acommand + " \n " + e);
            return "Imported View #" + viewNum;
        }
        finally {
            if (myTrx != null && myTrx.isActive()) {
                myTrx.rollback();
                myTrx.close();
            }
        }
    }
}

