/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.report.core.ResultTableCellEditor;
import org.compiere.report.core.ResultTableCellRenderer;
import org.compiere.report.core.ResultTableModel;
import org.compiere.swing.MSort;
import org.compiere.util.CLogger;

public class ResultTable
extends JTable
implements MouseListener {
    private int m_lastSortIndex = -1;
    private boolean m_asc = true;
    private static CLogger log = CLogger.getCLogger(ResultTable.class);

    public ResultTable() {
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        ResultTableCellEditor rtce = new ResultTableCellEditor();
        this.setCellEditor(rtce);
        this.addMouseListener(this);
        this.getTableHeader().addMouseListener(this);
    }

    public ResultTable(RModel reportModel) {
        this();
        this.setModel(reportModel);
    }

    public void setModel(RModel reportModel) {
        log.config(reportModel.toString());
        super.setModel(new ResultTableModel(reportModel));
        TableColumnModel tcm = this.getColumnModel();
        for (int i2 = 0; i2 < tcm.getColumnCount(); ++i2) {
            TableColumn tc = tcm.getColumn(i2);
            RColumn rc = reportModel.getRColumn(i2);
            if (rc.getColHeader().equals(tc.getHeaderValue())) {
                ResultTableCellRenderer rtcr = new ResultTableCellRenderer(reportModel, rc);
                tc.setCellRenderer(rtcr);
                continue;
            }
            log.log(Level.SEVERE, "RColumn=" + rc.getColHeader() + " <> TableColumn=" + tc.getHeaderValue());
        }
        this.autoSize();
    }

    public void setModel(TableModel ignored) {
        super.setModel(ignored);
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        log.fine("Type=" + e.getType());
    }

    public void mouseClicked(MouseEvent e) {
        int col = this.getColumnModel().getColumnIndexAtX(e.getX());
        log.fine("Column " + col + " = " + this.getColumnModel().getColumn(col).getHeaderValue() + ", Table r=" + this.getSelectedRow() + " c=" + this.getSelectedColumn());
        if (e.getSource() != this) {
            int mc = this.convertColumnIndexToModel(col);
            this.sort(mc);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void autoSize() {
        log.config("");
        int SLACK = 8;
        int MAXSIZE = 300;
        TableColumnModel tcm = this.getColumnModel();
        for (int col = 0; col < tcm.getColumnCount(); ++col) {
            TableColumn tc = tcm.getColumn(col);
            int width = 0;
            TableCellRenderer renderer = tc.getHeaderRenderer();
            if (renderer == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width + 8;
            int maxRow = Math.min(30, this.getRowCount());
            for (int row = 0; row < maxRow; ++row) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
        }
    }

    private void sort(int modelColumnIndex) {
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        this.m_asc = modelColumnIndex != this.m_lastSortIndex ? true : !this.m_asc;
        this.m_lastSortIndex = modelColumnIndex;
        log.config("#" + modelColumnIndex + " - rows=" + rows + ", asc=" + this.m_asc);
        ResultTableModel model = (ResultTableModel)this.getModel();
        MSort sort = new MSort(0, null);
        sort.setSortAsc(this.m_asc);
        block0: while (true) {
            int i2;
            ArrayList<MSort> sortList = new ArrayList<MSort>(rows);
            for (i2 = 0; i2 < rows; ++i2) {
                Object value = model.getValueAt(i2, modelColumnIndex);
                sortList.add(new MSort(i2, value));
            }
            Collections.sort(sortList, sort);
            for (i2 = 0; i2 < rows; ++i2) {
                int index = ((MSort)sortList.get((int)i2)).index;
                if (i2 == index) continue;
                model.moveRow(i2, index);
                continue block0;
            }
            break;
        }
    }
}

