/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.compiere.util.Util;

public class FileUtil {
    private String m_filterString = null;
    private FileUtilFilter m_filter = new FileUtilFilter();
    private int m_count = 0;
    private int m_actions = 0;
    private int m_actionIndex = -1;
    static final String[] ACTIONS = new String[]{"List", "Replace", "Latex", "License"};

    public FileUtil(String file, String filter, String action, String p1, String p2) {
        this(new File(file), filter, action, p1, p2);
    }

    public FileUtil(File file, String filter, String action, String p1, String p2) {
        if (action == null || action.length() == 0) {
            System.err.println("FileUtil: No Action");
        } else if (!this.validAction(action)) {
            System.err.println("FileUtil: Action not valid: " + action + ACTIONS);
        } else if (file == null) {
            System.err.println("FileUtil: No Input file");
        } else if (!file.exists()) {
            System.err.println("FileUtil: Input file does not exist: " + file);
        } else {
            System.out.println("FileUtil (" + file + ", Filter=" + filter + ", Action=" + action + ")");
            this.m_filterString = filter;
            this.processFile(file, p1, p2);
            System.out.println("FileUtil  Process count = " + this.m_count + "  actions=" + this.m_actions);
        }
    }

    private boolean validAction(String action) {
        for (int i2 = 0; i2 < ACTIONS.length; ++i2) {
            if (!ACTIONS[i2].equals(action)) continue;
            this.m_actionIndex = i2;
            return true;
        }
        return false;
    }

    private void processFile(File file, String p1, String p2) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] dirFiles = file.listFiles(this.m_filter);
            for (int i2 = 0; i2 < dirFiles.length; ++i2) {
                this.processFile(dirFiles[i2], p1, p2);
            }
        } else {
            System.out.println(" ProcessFile=" + file.getAbsolutePath());
            ++this.m_count;
            this.processFileAction(file, p1, p2);
        }
    }

    void processFileAction(File file, String p1, String p2) {
        try {
            if (this.m_actionIndex != 0) {
                if (this.m_actionIndex == 1) {
                    this.replaceString(file, p1, p2);
                } else if (this.m_actionIndex == 2) {
                    this.latex(file);
                } else if (this.m_actionIndex == 3) {
                    this.license(file);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void replaceString(File file, String from, String to) throws IOException {
        String fileName = file.getAbsolutePath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        File tmpFile = new File(fileName + ".tmp");
        BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile, false));
        boolean found = false;
        String line = null;
        int lineNo = 0;
        while ((line = in.readLine()) != null) {
            ++lineNo;
            if (line.indexOf(from) != -1) {
                found = true;
                System.out.println("  " + lineNo + ": " + line);
                line = Util.replace((String)line, (String)from, (String)to);
                ++this.m_actions;
            }
            out.write(line);
            out.newLine();
        }
        in.close();
        out.close();
        if (found) {
            File oldFile = new File(fileName + ".old");
            if (file.renameTo(oldFile)) {
                if (tmpFile.renameTo(new File(fileName))) {
                    if (oldFile.delete()) {
                        System.out.println(" - File updated: " + fileName);
                    } else {
                        System.err.println(" - Old File not deleted - " + fileName);
                    }
                } else {
                    System.err.println(" - New File not renamed - " + fileName);
                }
            } else {
                System.err.println(" - Old File not renamed - " + fileName);
            }
        } else if (!tmpFile.delete()) {
            System.err.println(" - Temp file not deleted - " + tmpFile.getAbsolutePath());
        }
    }

    private void latex(File file) throws IOException {
        String fileName = file.getAbsolutePath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        File outFile = new File(fileName + ".txt");
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile, false));
        String line = null;
        int lineNo = 0;
        while ((line = in.readLine()) != null) {
            ++lineNo;
            boolean ignore = false;
            char[] inLine = line.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < inLine.length; ++i2) {
                char c = inLine[i2];
                if (c == '\\') {
                    ignore = true;
                    continue;
                }
                if (c == '{') {
                    ignore = false;
                    continue;
                }
                if (c == '}' || ignore) continue;
                sb.append(c);
            }
            out.write(sb.toString());
            out.newLine();
        }
        in.close();
        out.close();
        System.out.println("File " + fileName + " - lines=" + lineNo);
    }

    private void license(File file) throws IOException {
        String fileName = file.getAbsolutePath();
        BufferedReader in = new BufferedReader(new FileReader(file));
        File tmpFile = new File(fileName + ".tmp");
        BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile, false));
        out.write("/******************************************************************************\r\n * Product: Compiere ERP & CRM Smart Business Solution                        *\r\n * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *\r\n * This program is free software, you can redistribute it and/or modify it    *\r\n * under the terms version 2 of the GNU General Public License as published   *\r\n * by the Free Software Foundation. This program is distributed in the hope   *\r\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\r\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\r\n * See the GNU General Public License for more details.                       *\r\n * You should have received a copy of the GNU General Public License along    *\r\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\r\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\r\n * For the text or an alternative of this public license, you may reach us    *\r\n * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *\r\n * or via info@compiere.org or http://www.compiere.org/license.html           *\r\n *****************************************************************************/\r\n");
        boolean changed = true;
        boolean packageLineFound = false;
        boolean utilPackageFound = false;
        boolean classStarted = false;
        ArrayList<String> hdrBuffer = new ArrayList<String>();
        String line = null;
        int lineNo = 0;
        while ((line = in.readLine()) != null) {
            ++lineNo;
            if (!packageLineFound) {
                if (!line.startsWith("package ")) continue;
                packageLineFound = true;
                out.write(line);
                out.newLine();
                continue;
            }
            if (!utilPackageFound && line.indexOf("org.compiere.util") != -1) {
                utilPackageFound = true;
            }
            if (packageLineFound && !classStarted) {
                if (line.indexOf(" class ") != -1) {
                    classStarted = true;
                    if (!utilPackageFound) {
                        out.newLine();
                        out.write("import org.compiere.util.*;");
                        out.newLine();
                    }
                    for (int i2 = 0; i2 < hdrBuffer.size(); ++i2) {
                        out.write((String)hdrBuffer.get(i2));
                        out.newLine();
                    }
                    hdrBuffer.clear();
                } else {
                    hdrBuffer.add(line);
                    continue;
                }
            }
            out.write(line);
            out.newLine();
        }
        in.close();
        out.close();
        if (changed) {
            File oldFile = new File(fileName + ".old");
            if (file.renameTo(oldFile)) {
                if (tmpFile.renameTo(new File(fileName))) {
                    if (oldFile.delete()) {
                        System.out.println(" - File updated: " + fileName);
                    } else {
                        System.err.println(" - Old File not deleted - " + fileName);
                    }
                } else {
                    System.err.println(" - New File not renamed - " + fileName);
                }
            } else {
                System.err.println(" - Old File not renamed - " + fileName);
            }
        } else {
            System.err.println(" - No Copyright - " + fileName);
            if (!tmpFile.delete()) {
                System.err.println(" - Temp file not deleted - " + tmpFile.getAbsolutePath());
            }
        }
    }

    String getFilterString() {
        return this.m_filterString;
    }

    public static void main(String[] args) {
        String directory = "C:\\Compiere\\core\\trunk";
        String filter = ".java";
        String action = "License";
        String from = null;
        String to = null;
        action = "Replace";
        from = "MPeriodControl.DOCBASETYPE";
        to = "MDocBaseType.DOCBASETYPE";
        if (args.length == 1) {
            directory = args[0];
        }
        if (args.length == 2) {
            filter = args[1];
        }
        if (filter == null) {
            filter = "";
        }
        new FileUtil(directory, filter, action, from, to);
    }

    class FileUtilFilter
    implements FilenameFilter {
        FileUtilFilter() {
        }

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                return true;
            }
            String filterString = FileUtil.this.getFilterString();
            if (filterString == null || filterString.length() == 0) {
                return true;
            }
            if (name == null) {
                return false;
            }
            if (name.indexOf("~") != -1 || name.equals("FileUtil.java")) {
                return false;
            }
            return name.endsWith(filterString);
        }
    }
}

