/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebUtil;

public class WebSessionCtx
implements Serializable {
    private static final long serialVersionUID = -5069858671373130221L;
    public static final String CTX_SERVER_CONTEXT = "context";
    public static final String CTX_DOCUMENT_DIR = "documentDir";
    public static final String HDR_MESSAGE = "hdrMessage";
    public static final String HDR_INFO = "hdrInfo";
    private static CLogger log = CLogger.getCLogger(WebSessionCtx.class);
    private static CCache<Integer, Ctx> s_cacheCtx = new CCache("WebSessionCtx", 30, 60);
    public static final String NAME = "WebSessionCtx";
    public static int s_counter = 0;
    public int counter = ++s_counter;
    public Ctx ctx = null;
    public Language language = null;
    public SimpleDateFormat dateFormat = null;
    public SimpleDateFormat dateTimeFormat = null;
    public DecimalFormat amountFormat = null;
    public DecimalFormat integerFormat = null;
    public DecimalFormat numberFormat = null;
    public DecimalFormat quantityFormat = null;
    public String loginInfo = "";
    public MStore wstore = null;

    public static WebSessionCtx get(HttpServletRequest request, int W_Store_ID) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession(true);
        }
        if (session == null) {
            return null;
        }
        WebSessionCtx wsc = (WebSessionCtx)session.getAttribute(NAME);
        if (wsc == null) {
            wsc = new WebSessionCtx(request, W_Store_ID);
            session.setAttribute(NAME, (Object)wsc);
        }
        return wsc;
    }

    public static WebSessionCtx get(HttpServletRequest request, boolean createNew) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = request.getSession(true);
        }
        if (session == null) {
            return null;
        }
        WebSessionCtx wsc = (WebSessionCtx)session.getAttribute(NAME);
        if (createNew && wsc == null) {
            wsc = new WebSessionCtx(request);
            session.setAttribute(NAME, (Object)wsc);
        }
        return wsc;
    }

    private WebSessionCtx(HttpServletRequest request) {
        log.info(request.getContextPath() + " (" + request.getRemoteAddr() + " - " + request.getLocale() + ") #" + this.counter);
        this.ctx = new Ctx();
        this.setLanguage(request);
        HttpSession session = request.getSession(false);
        ServletContext sc = session.getServletContext();
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = sc.getInitParameter(key);
            this.ctx.setContext(key, value);
            log.config(key + "=" + value);
        }
        this.setWStore(request.getContextPath());
        this.ctx = this.getDefaults();
        this.ctx.put((Object)CTX_SERVER_CONTEXT, (Object)(request.getServerName() + request.getContextPath()));
        session.setAttribute("ctx", (Object)this.ctx);
        log.fine("#" + this.ctx.size());
    }

    private WebSessionCtx(HttpServletRequest request, int W_Store_ID) {
        log.info(request.getContextPath() + " (" + request.getRemoteAddr() + " - " + request.getLocale() + ") #" + this.counter);
        this.ctx = new Ctx();
        this.setLanguage(request);
        HttpSession session = request.getSession(false);
        ServletContext sc = session.getServletContext();
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = sc.getInitParameter(key);
            this.ctx.setContext(key, value);
            log.config(key + "=" + value);
        }
        this.setWStore(W_Store_ID);
        this.ctx = this.getDefaults();
        this.ctx.put((Object)CTX_SERVER_CONTEXT, (Object)(request.getServerName() + request.getContextPath()));
        session.setAttribute("ctx", (Object)this.ctx);
        log.fine("#" + this.ctx.size());
    }

    private void setWStore(String contextPath) {
        int W_Store_ID = this.ctx.getContextAsInt("W_Store_ID");
        if (W_Store_ID != 0) {
            this.wstore = MStore.get(this.ctx, W_Store_ID);
            if (this.wstore.getW_Store_ID() != 0) {
                log.info("From web.xml - " + (Object)((Object)this.wstore));
                return;
            }
        }
        if ("/compiere".equals(contextPath)) {
            return;
        }
        this.wstore = MStore.get(this.ctx, contextPath);
        if (this.wstore == null) {
            throw new IllegalStateException("No Web Store found - " + contextPath);
        }
    }

    public void setWStore(int W_Store_ID) {
        if (W_Store_ID != 0) {
            this.wstore = MStore.get(this.ctx, W_Store_ID);
            if (this.wstore.getW_Store_ID() != 0) {
                log.info("From web.xml - " + (Object)((Object)this.wstore));
                return;
            }
        }
        if (this.wstore == null) {
            throw new IllegalStateException("No Web Store found - ID: " + W_Store_ID);
        }
    }

    private Ctx getDefaults() {
        if (this.wstore == null) {
            return new Ctx();
        }
        Integer key = new Integer(this.wstore.getW_Store_ID());
        Ctx newCtx = (Ctx)s_cacheCtx.get((Object)key);
        if (newCtx == null) {
            String docDir;
            log.info(this.wstore.getWebContext());
            newCtx = new Ctx();
            for (String pKey : this.ctx.keySet()) {
                newCtx.setContext(pKey, this.ctx.getContext(pKey));
            }
            newCtx.setAD_Client_ID(this.wstore.getAD_Client_ID());
            newCtx.setAD_Org_ID(this.wstore.getAD_Org_ID());
            newCtx.setContext("#SalesRep_ID", this.wstore.getSalesRep_ID());
            newCtx.setContext("#M_PriceList_ID", this.wstore.getM_PriceList_ID());
            newCtx.setContext("#M_Warehouse_ID", this.wstore.getM_Warehouse_ID());
            String s = this.wstore.getWebParam1();
            newCtx.setContext("webParam1", s == null ? "" : s);
            s = this.wstore.getWebParam2();
            newCtx.setContext("webParam2", s == null ? "" : s);
            s = this.wstore.getWebParam3();
            newCtx.setContext("webParam3", s == null ? "" : s);
            s = this.wstore.getWebParam4();
            newCtx.setContext("webParam4", s == null ? "" : s);
            s = this.wstore.getWebParam5();
            newCtx.setContext("webParam5", s == null ? "" : s);
            s = this.wstore.getWebParam6();
            newCtx.setContext("webParam6", s == null ? "" : s);
            s = this.wstore.getStylesheet();
            if (s == null) {
                s = "standard";
            } else {
                int index = s.lastIndexOf(46);
                if (index != -1) {
                    s = s.substring(0, index);
                }
            }
            newCtx.setContext("Stylesheet", s);
            s = this.wstore.getWebInfo();
            if (s != null && s.length() > 0) {
                newCtx.setContext(HDR_INFO, s);
            }
            newCtx.setContext("#M_PriceList_ID", this.wstore.getM_PriceList_ID());
            if (newCtx.getAD_User_ID() == 0) {
                newCtx.setAD_User_ID(this.wstore.getSalesRep_ID());
            }
            if (newCtx.getAD_Role_ID() == 0) {
                int AD_Role_ID = 0;
                newCtx.setAD_Role_ID(AD_Role_ID);
            }
            MClient client = MClient.get((Ctx)newCtx, (int)this.wstore.getAD_Client_ID());
            newCtx.setContext("name", client.getName());
            newCtx.setContext("description", client.getDescription());
            if (newCtx.getContext("#AD_Language") == null && client.getAD_Language() != null) {
                newCtx.setContext("#AD_Language", client.getAD_Language());
            }
            newCtx.setContext(CTX_DOCUMENT_DIR, (docDir = client.getDocumentDir()) == null ? "" : docDir);
            if (newCtx.getContext("#AD_Language") == null) {
                newCtx.setContext("#AD_Language", "en_US");
            }
            s_cacheCtx.put((Object)key, (Object)newCtx);
        }
        for (String pKey : newCtx.keySet()) {
            this.ctx.setContext(pKey, newCtx.getContext(pKey));
        }
        return this.ctx;
    }

    private void setLanguage(HttpServletRequest request) {
        Properties cProp = WebUtil.getCookieProperties(request);
        String AD_Language = WebUtil.getParameter(request, "#AD_Language");
        if (AD_Language == null && (AD_Language = cProp.getProperty("#AD_Language")) == null) {
            Locale locale = request.getLocale();
            AD_Language = Language.getAD_Language((Locale)locale);
        }
        if (AD_Language != null) {
            Language lang = Language.getLanguage((String)AD_Language);
            lang = Env.verifyLanguage((Ctx)this.ctx, (Language)lang);
            this.ctx.setContext("#AD_Language", lang.getAD_Language());
            Msg.getMsg((Ctx)this.ctx, (String)"0");
            cProp.setProperty("#AD_Language", lang.getAD_Language());
            this.setLanguage(lang);
        } else if (this.language == null) {
            this.setLanguage(Language.getBaseLanguage());
        }
    }

    private void setLanguage(Language lang) {
        this.language = lang;
        this.dateFormat = DisplayType.getDateFormat((int)15, (Language)this.language);
        this.dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)this.language);
        this.amountFormat = DisplayType.getNumberFormat((int)12, (Language)this.language);
        this.integerFormat = DisplayType.getNumberFormat((int)11, (Language)this.language);
        this.numberFormat = DisplayType.getNumberFormat((int)22, (Language)this.language);
        this.quantityFormat = DisplayType.getNumberFormat((int)29, (Language)this.language);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String toString() {
        return "WSessionCtx#" + this.counter;
    }
}

