/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MRefList;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.WebUtil;

public class WebUser {
    private static WebUser s_cache = null;
    public static final String NAME = "webUser";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Ctx m_ctx;
    private MBPartner m_bp;
    private MUser m_bpc;
    private MBPartnerLocation m_bpl;
    private MLocation m_loc;
    private boolean m_passwordOK = false;
    private String m_passwordMessage;
    private String m_saveErrorMessage;
    private int m_AD_Client_ID = 0;
    private boolean m_loggedIn = false;

    public static WebUser get(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (WebUser)session.getAttribute(NAME);
    }

    public static WebUser get(Ctx ctx, String email) {
        return WebUser.get(ctx, email, null, true);
    }

    public static WebUser get(Ctx ctx, String email, String password, boolean useCache) {
        if (!useCache) {
            s_cache = null;
        }
        if (s_cache != null && email != null && email.equals(s_cache.getEmail())) {
            if (password == null || password.equals(s_cache.getPassword())) {
                return s_cache;
            }
            s_cache.setPasswordOK(false, null);
            return s_cache;
        }
        s_cache = new WebUser(ctx, email, password);
        return s_cache;
    }

    public static WebUser get(Ctx ctx, int AD_User_ID) {
        if (s_cache != null && s_cache.getAD_User_ID() == AD_User_ID) {
            return s_cache;
        }
        s_cache = new WebUser(ctx, AD_User_ID, null);
        return s_cache;
    }

    private WebUser(Ctx ctx, String email, String password) {
        this.m_ctx = ctx;
        this.m_AD_Client_ID = ctx.getAD_Client_ID();
        this.load(email, password);
    }

    private WebUser(Ctx ctx, int AD_User_ID, String trxName) {
        this.m_ctx = ctx;
        this.m_AD_Client_ID = ctx.getAD_Client_ID();
        this.load(AD_User_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String email, String password) {
        this.log.info(email + " - AD_Client_ID=" + this.m_AD_Client_ID);
        String sql = "SELECT * FROM AD_User WHERE AD_Client_ID=? AND TRIM(EMail)=?";
        if (email == null) {
            email = "";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_AD_Client_ID);
            pstmt.setString(2, email.trim());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_bpc = new MUser(this.m_ctx, rs, null);
                this.log.fine("Found BPC=" + this.m_bpc);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_passwordOK = false;
        if (this.m_bpc != null && password != null && password.equals(this.m_bpc.getPassword())) {
            this.m_passwordOK = true;
        }
        if (this.m_passwordOK || this.m_bpc == null) {
            this.m_passwordMessage = null;
        } else {
            this.setPasswordOK(false, password);
        }
        if (this.m_bpc != null) {
            this.m_bp = new MBPartner(this.m_ctx, this.m_bpc.getC_BPartner_ID(), null);
            this.log.fine("Found BP=" + (Object)((Object)this.m_bp));
        } else {
            this.m_bp = null;
        }
        if (this.m_bpc != null) {
            if (this.m_bpc.getC_BPartner_Location_ID() != 0) {
                this.m_bpl = new MBPartnerLocation(this.m_ctx, this.m_bpc.getC_BPartner_Location_ID(), null);
                this.log.fine("Found BPL=" + (Object)((Object)this.m_bpl));
            } else {
                MBPartnerLocation[] bpls = this.m_bp.getLocations(false);
                if (bpls != null && bpls.length > 0) {
                    this.m_bpl = bpls[0];
                    this.log.fine("Found BPL=" + (Object)((Object)this.m_bpl));
                }
            }
            if (this.m_bpl != null) {
                this.m_loc = MLocation.get((Ctx)this.m_ctx, (int)this.m_bpl.getC_Location_ID(), null);
                this.log.fine("Found LOC=" + this.m_loc);
            } else {
                this.m_loc = null;
            }
        } else {
            this.m_bpl = null;
            this.m_loc = null;
        }
        if (this.m_bpc == null) {
            this.m_bpc = new MUser(this.m_ctx, 0, null);
            this.m_bpc.setEMail(email);
            this.m_bpc.setPassword(password);
        }
        if (this.m_bp == null) {
            this.m_bp = new MBPartner(this.m_ctx, null);
            this.m_bp.setIsCustomer(true);
        }
        if (this.m_bpl == null) {
            this.m_bpl = new MBPartnerLocation(this.m_bp);
        }
        if (this.m_loc == null) {
            this.m_loc = new MLocation(this.m_ctx, 0, null);
        }
        this.log.config((Object)((Object)this.m_bp) + " - " + this.m_bpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(int AD_User_ID) {
        this.log.info("ID=" + AD_User_ID + ", AD_Client_ID=" + this.m_AD_Client_ID);
        String sql = "SELECT * FROM AD_User WHERE AD_Client_ID=? AND AD_User_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_AD_Client_ID);
            pstmt.setInt(2, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_bpc = new MUser(this.m_ctx, rs, null);
                this.log.fine("= found BPC=" + this.m_bpc);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_passwordOK = false;
        this.m_loggedIn = false;
        if (this.m_bpc != null) {
            this.m_bp = new MBPartner(this.m_ctx, this.m_bpc.getC_BPartner_ID(), null);
            this.log.fine("= Found BP=" + (Object)((Object)this.m_bp));
        } else {
            this.m_bp = null;
        }
        if (this.m_bpc != null) {
            if (this.m_bpc.getC_BPartner_Location_ID() != 0) {
                this.m_bpl = new MBPartnerLocation(this.m_ctx, this.m_bpc.getC_BPartner_Location_ID(), null);
                this.log.fine("= Found BPL=" + (Object)((Object)this.m_bpl));
            } else {
                MBPartnerLocation[] bpls = this.m_bp.getLocations(false);
                if (bpls != null && bpls.length > 0) {
                    this.m_bpl = bpls[0];
                    this.log.fine("= Found BPL=" + (Object)((Object)this.m_bpl));
                }
            }
            if (this.m_bpl != null) {
                this.m_loc = MLocation.get((Ctx)this.m_ctx, (int)this.m_bpl.getC_Location_ID(), null);
                this.log.fine("= Found LOC=" + this.m_loc);
            } else {
                this.m_loc = null;
            }
        } else {
            this.m_bpl = null;
            this.m_loc = null;
        }
        if (this.m_bpc == null) {
            this.m_bpc = new MUser(this.m_ctx, 0, null);
            this.m_bpc.setEMail("?");
            this.m_bpc.setPassword("?");
        }
        if (this.m_bp == null) {
            this.m_bp = new MBPartner(this.m_ctx, null);
            this.m_bp.setIsCustomer(true);
        }
        if (this.m_bpl == null) {
            this.m_bpl = new MBPartnerLocation(this.m_bp);
        }
        if (this.m_loc == null) {
            this.m_loc = new MLocation(this.m_ctx, 0, null);
        }
        this.log.info("= " + (Object)((Object)this.m_bp) + " - " + this.m_bpc);
    }

    public boolean isValid() {
        if (this.m_bpc == null) {
            return false;
        }
        boolean ok = this.m_bpc.getAD_User_ID() != 0;
        return ok;
    }

    public boolean isEMailValid() {
        boolean ok;
        if (this.m_bpc == null || !WebUtil.exists(this.getEmail())) {
            this.log.fine(this.getEmail() + ", bpc=" + this.m_bpc);
            return false;
        }
        boolean bl = ok = this.m_bpc.getAD_User_ID() != 0 && this.m_bpc.isEMailValid();
        if (!ok) {
            this.log.fine(this.getEmail() + ", ID=" + this.m_bpc.getAD_User_ID() + ", Online=" + this.m_bpc.isOnline() + ", EMailValid=" + this.m_bpc.isEMailValid());
        }
        return ok;
    }

    public boolean isEMailVerified() {
        return this.m_bpc != null && this.m_bpc.isEMailVerified();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebUser[");
        sb.append(this.getEmail()).append(",LoggedIn=").append(this.m_loggedIn).append(",").append(this.m_bpc).append(",PasswordOK=").append(this.m_passwordOK).append(",Valid=").append(this.isValid()).append(" - ").append((Object)this.m_bp).append("Customer=").append(this.isCustomer()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        this.m_saveErrorMessage = null;
        this.log.info("BP.Value=" + this.m_bp.getValue() + ", Name=" + this.m_bp.getName());
        try {
            if (this.m_bp.getC_BPartner_ID() == 0) {
                String sql = "SELECT * FROM C_BPartner WHERE AD_Client_ID=? AND Value=?";
                CPreparedStatement pstmt = null;
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    pstmt.setString(2, this.m_bp.getValue());
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_bp = new MBPartner(this.m_ctx, this.m_bpc.getC_BPartner_ID(), null);
                        this.log.fine("BP loaded =" + (Object)((Object)this.m_bp));
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "save-check", (Throwable)e);
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {}
                    pstmt = null;
                }
            }
            if (this.m_bp.getName() == null || this.m_bp.getName().length() == 0) {
                this.m_bp.setName(this.m_bpc.getName());
            }
            if (this.m_bp.getValue() == null || this.m_bp.getValue().length() == 0) {
                this.m_bp.setValue(this.m_bpc.getEMail());
            }
            this.log.fine("BP=" + (Object)((Object)this.m_bp));
            if (!this.m_bp.save()) {
                this.m_saveErrorMessage = "Could not save Business Partner";
                return false;
            }
            this.log.fine("LOC=" + this.m_loc);
            this.m_loc.save();
            if (this.m_bpl.getC_BPartner_ID() != this.m_bp.getC_BPartner_ID()) {
                this.m_bpl.setC_BPartner_ID(this.m_bp.getC_BPartner_ID());
            }
            if (this.m_bpl.getC_Location_ID() != this.m_loc.getC_Location_ID()) {
                this.m_bpl.setC_Location_ID(this.m_loc.getC_Location_ID());
            }
            this.log.fine("BPL=" + (Object)((Object)this.m_bpl));
            if (!this.m_bpl.save()) {
                this.m_saveErrorMessage = "Could not save Location";
                return false;
            }
            if (this.m_bpc.getC_BPartner_ID() != this.m_bp.getC_BPartner_ID()) {
                this.m_bpc.setC_BPartner_ID(this.m_bp.getC_BPartner_ID());
            }
            if (this.m_bpc.getC_BPartner_Location_ID() != this.m_bpl.getC_BPartner_Location_ID()) {
                this.m_bpc.setC_BPartner_Location_ID(this.m_bpl.getC_BPartner_Location_ID());
            }
            this.log.fine("BPC=" + this.m_bpc);
            if (!this.m_bpc.save()) {
                this.m_saveErrorMessage = "Could not save Contact";
                return false;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "save", (Throwable)ex);
            this.m_saveErrorMessage = ex.toString();
            return false;
        }
        return true;
    }

    public void setSaveErrorMessage(String msg) {
        this.m_saveErrorMessage = msg;
    }

    public String getSaveErrorMessage() {
        return this.m_saveErrorMessage;
    }

    public String getEmail() {
        return this.m_bpc.getEMail();
    }

    public void setEmail(String email) {
        this.m_bpc.setEMail(email);
    }

    public String getName() {
        return this.m_bpc.getName();
    }

    public void setName(String name) {
        this.m_bpc.setName(name);
    }

    public void setValue(String value) {
        this.m_bp.setValue(value);
    }

    public String getTitle() {
        return this.m_bpc.getTitle();
    }

    public void setTitle(String title2) {
        this.m_bpc.setTitle(title2);
    }

    public String getPassword() {
        String pwd = this.m_bpc.getPassword();
        if (pwd == null || pwd.length() == 0) {
            pwd = String.valueOf(System.currentTimeMillis());
        }
        return pwd;
    }

    public void setPassword() {
        String pwd = this.m_bpc.getPassword();
        if ((pwd == null || pwd.length() == 0) && this.m_bpc.getC_BPartner_ID() != 0 && this.m_bpc.getAD_User_ID() != 0) {
            pwd = String.valueOf(System.currentTimeMillis());
            this.m_bpc.setPassword(pwd);
            this.m_bpc.save();
        }
    }

    public void setPassword(String password) {
        if (password == null || password.length() == 0) {
            this.m_passwordMessage = "Enter Password";
        }
        this.m_bpc.setPassword(password);
    }

    private void setPasswordOK(boolean ok, String password) {
        this.m_passwordOK = ok;
        this.m_passwordMessage = ok ? null : (password == null || password.length() == 0 ? "Enter Password" : "Invalid Password");
    }

    public boolean isPasswordOK() {
        if (this.m_bpc == null || !WebUtil.exists(this.m_bpc.getPassword())) {
            return false;
        }
        return this.m_passwordOK;
    }

    public String getPasswordMessage() {
        return this.m_passwordMessage;
    }

    public void setPasswordMessage(String passwordMessage) {
        this.m_passwordMessage = passwordMessage;
    }

    public boolean login(String password) {
        this.m_loggedIn = this.isValid() && WebUtil.exists(password) && password.equals(this.getPassword());
        this.setPasswordOK(this.m_loggedIn, password);
        this.log.fine("success=" + this.m_loggedIn);
        if (this.m_loggedIn) {
            this.m_ctx.setAD_User_ID(this.getAD_User_ID());
        }
        return this.m_loggedIn;
    }

    public void logout() {
        this.m_loggedIn = false;
    }

    public boolean isLoggedIn() {
        return this.m_loggedIn;
    }

    public String getPhone() {
        return this.m_bpc.getPhone();
    }

    public void setPhone(String phone) {
        this.m_bpc.setPhone(phone);
    }

    public String getPhone2() {
        return this.m_bpc.getPhone2();
    }

    public void setPhone2(String phone2) {
        this.m_bpc.setPhone2(phone2);
    }

    public String getFax() {
        return this.m_bpc.getFax();
    }

    public void setFax(String fax) {
        this.m_bpc.setFax(fax);
    }

    public Timestamp getBirthday() {
        return this.m_bpc.getBirthday();
    }

    public void setBirthday(Timestamp birthday) {
        this.m_bpc.setBirthday(birthday);
    }

    public String getTaxID() {
        return this.m_bp.getTaxID();
    }

    public void setTaxID(String taxID) {
        this.m_bp.setTaxID(taxID);
    }

    public int getAD_Client_ID() {
        return this.m_bpc.getAD_Client_ID();
    }

    public int getAD_User_ID() {
        return this.m_bpc.getAD_User_ID();
    }

    public int getContactID() {
        return this.getAD_User_ID();
    }

    public String getCompany() {
        return this.m_bp.getName();
    }

    public void setCompany(String company) {
        if (company == null) {
            this.m_bp.setName(this.m_bpc.getName());
        } else {
            this.m_bp.setName(company);
        }
    }

    public int getC_BPartner_ID() {
        return this.m_bp.getC_BPartner_ID();
    }

    public int getBpartnerID() {
        return this.m_bp.getC_BPartner_ID();
    }

    public int getM_PriceList_ID() {
        return this.m_bp.getM_PriceList_ID();
    }

    public int getC_BPartner_Location_ID() {
        return this.m_bpl.getC_BPartner_Location_ID();
    }

    public String getAddress() {
        return this.m_loc.getAddress1();
    }

    public void setAddress(String address) {
        this.m_loc.setAddress1(address);
    }

    public String getAddress2() {
        return this.m_loc.getAddress2();
    }

    public void setAddress2(String address2) {
        this.m_loc.setAddress2(address2);
    }

    public String getCity() {
        return this.m_loc.getCity();
    }

    public void setCity(String city) {
        this.m_loc.setCity(city);
    }

    public String getPostal() {
        return this.m_loc.getPostal();
    }

    public void setPostal(String postal) {
        this.m_loc.setPostal(postal);
    }

    public String getRegionName() {
        return this.m_loc.getRegionName(false);
    }

    public void setRegionName(String region) {
        this.m_loc.setRegionName(region);
    }

    public int getC_Region_ID() {
        return this.m_loc.getC_Region_ID();
    }

    public String getRegionID() {
        return String.valueOf(this.getC_Region_ID());
    }

    public void setC_Region_ID(int C_Region_ID) {
        this.m_loc.setC_Region_ID(C_Region_ID);
    }

    public void setC_Region_ID(String C_Region_ID) {
        try {
            if (C_Region_ID == null || C_Region_ID.length() == 0) {
                this.setC_Region_ID(0);
            } else {
                this.setC_Region_ID(Integer.parseInt(C_Region_ID));
            }
        }
        catch (Exception e) {
            this.setC_Region_ID(0);
            this.log.log(Level.WARNING, C_Region_ID, (Throwable)e);
        }
    }

    public String getCountryName() {
        return this.m_loc.getCountryName();
    }

    public void setCountryName(String country) {
        this.log.warning(country + " Ignored - C_Country_ID=" + this.m_loc.getC_Country_ID());
    }

    public int getC_Country_ID() {
        return this.m_loc.getC_Country_ID();
    }

    public String getCountryID() {
        return String.valueOf(this.getC_Country_ID());
    }

    public void setC_Country_ID(int C_Country_ID) {
        this.m_loc.setC_Country_ID(C_Country_ID);
    }

    public void setC_Country_ID(String C_Country_ID) {
        try {
            if (C_Country_ID == null || C_Country_ID.length() == 0) {
                this.setC_Country_ID(0);
            } else {
                this.setC_Country_ID(Integer.parseInt(C_Country_ID));
            }
        }
        catch (Exception e) {
            this.setC_Country_ID(0);
            this.log.log(Level.WARNING, C_Country_ID, (Throwable)e);
        }
    }

    public void setC_BP_Group_ID(int C_BP_Group_ID) {
        this.m_bp.setC_BP_Group_ID(C_BP_Group_ID);
    }

    public void setC_BP_Group_ID(String C_BP_Group_ID) {
        try {
            if (C_BP_Group_ID == null || C_BP_Group_ID.length() == 0) {
                this.setC_BP_Group_ID(0);
            } else {
                this.setC_BP_Group_ID(Integer.parseInt(C_BP_Group_ID));
            }
        }
        catch (Exception e) {
            this.setC_BP_Group_ID(0);
            this.log.log(Level.WARNING, C_BP_Group_ID, (Throwable)e);
        }
    }

    public boolean isEmployee() {
        return this.m_bp.isEmployee();
    }

    public boolean isSalesRep() {
        return this.m_bp.isSalesRep();
    }

    public boolean isCustomer() {
        return this.m_bp.isCustomer();
    }

    public void setIsCustomer(boolean isCustomer) {
        this.m_bp.setIsCustomer(isCustomer);
    }

    public boolean isVendor() {
        return this.m_bp.isVendor();
    }

    public int getSalesRep_ID() {
        return this.m_bp.getSalesRep_ID();
    }

    public boolean hasBPAccess(String BPAccessType, Object[] params) {
        return this.m_bpc.hasBPAccess(BPAccessType, params);
    }

    public boolean isCreditStopHold() {
        return this.m_bp.isCreditStopHold();
    }

    public boolean isCreditCritical() {
        String status = this.m_bp.getSOCreditStatus();
        return "S".equals(status) || "H".equals(status) || "W".equals(status);
    }

    public String getSOCreditStatus() {
        return MRefList.getListName((Ctx)this.m_ctx, (int)289, (String)this.m_bp.getSOCreditStatus());
    }

    public MBPBankAccount getBankAccount() {
        return this.getBankAccount(false);
    }

    public MBPBankAccount getBankAccount(boolean requery) {
        MBPBankAccount retValue = null;
        MBPBankAccount[] bas = this.m_bp.getBankAccounts(requery);
        for (int i2 = 0; i2 < bas.length; ++i2) {
            if (bas[i2].getAD_User_ID() != this.getAD_User_ID() || !bas[i2].isActive()) continue;
            retValue = bas[i2];
        }
        if (retValue == null) {
            retValue = new MBPBankAccount(this.m_ctx, this.m_bp, this.m_bpc, this.m_loc);
            retValue.setAD_User_ID(this.getAD_User_ID());
            retValue.save();
        }
        return retValue;
    }

    public String getEMailVerifyCode() {
        return this.m_bpc.getEMailVerifyCode();
    }

    public boolean setEMailVerifyCode(String code, String info) {
        boolean success = this.m_bpc.setEMailVerifyCode(code, info);
        String s = this.m_bpc.getEMail() + " - " + info;
        if (this.m_bpc.setEMailVerifyCode(code, info)) {
            this.setPasswordMessage(null);
            s = "OK: " + s;
        } else {
            this.setPasswordMessage("Invalid Code");
            s = "Error: " + s + "; Code=" + code;
        }
        if (!this.m_bpc.save()) {
            this.log.severe("User NOT saved " + s);
            success = false;
        } else {
            this.log.info(s);
        }
        return success;
    }
}

