/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.api.DocWorkflowMgr;
import org.compiere.framework.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.wf.MWorkflow;

public class DocWorkflowManager
implements DocWorkflowMgr {
    private static DocWorkflowManager s_mgr;
    private static CLogger log;
    private int m_noCalled = 0;
    private int m_noStarted = 0;

    public static DocWorkflowManager get() {
        if (s_mgr == null) {
            s_mgr = new DocWorkflowManager();
        }
        return s_mgr;
    }

    private DocWorkflowManager() {
        if (s_mgr == null) {
            s_mgr = this;
        }
    }

    public boolean process(PO document, int AD_Table_ID) {
        ++this.m_noCalled;
        MWorkflow[] wfs = MWorkflow.getDocValue(document.getCtx(), document.getAD_Client_ID(), AD_Table_ID);
        if (wfs == null || wfs.length == 0) {
            return false;
        }
        boolean started = false;
        for (int i2 = 0; i2 < wfs.length; ++i2) {
            MWorkflow wf = wfs[i2];
            String logic = wf.getDocValueLogic();
            if (logic == null || logic.length() == 0) {
                log.severe("Workflow has no Logic - " + wf.getName());
                continue;
            }
            if (wf.getAD_Client_ID() != document.getAD_Client_ID()) continue;
            boolean sql = logic.startsWith("SQL=");
            if (sql && !this.testStart(wf, document)) {
                log.fine("SQL Logic evaluated to false (" + logic + ")");
                continue;
            }
            if (!sql && !Evaluator.evaluateLogic((Evaluatee)document, (String)logic)) {
                log.fine("Logic evaluated to false (" + logic + ")");
                continue;
            }
            if (document.get_TrxName() != null) {
                log.severe("Not started: " + (Object)((Object)wf));
                continue;
            }
            log.fine(logic);
            int AD_Process_ID = 305;
            ProcessInfo pi = new ProcessInfo(wf.getName(), AD_Process_ID, AD_Table_ID, document.get_ID());
            pi.setAD_User_ID(document.getCtx().getAD_User_ID());
            pi.setAD_Client_ID(document.getAD_Client_ID());
            if (wf.start(pi) == null) continue;
            log.config(wf.getName());
            ++this.m_noStarted;
            started = true;
        }
        return started;
    }

    private boolean testStart(MWorkflow wf, PO document) {
        boolean retValue = false;
        String logic = wf.getDocValueLogic();
        logic = logic.substring(4);
        String tableName = document.get_TableName();
        String[] keyColumns = document.get_KeyColumns();
        if (keyColumns.length != 1) {
            log.severe("Tables with more then one key column not supported - " + tableName + " = " + keyColumns.length);
            return false;
        }
        String keyColumn = keyColumns[0];
        StringBuffer sql = new StringBuffer("SELECT ").append(keyColumn).append(" FROM ").append(tableName).append(" WHERE AD_Client_ID=? AND ").append(keyColumn).append("=? AND ").append(logic).append(" AND NOT EXISTS (SELECT * FROM AD_WF_Process wfp ").append("WHERE wfp.AD_Table_ID=? AND wfp.Record_ID=").append(tableName).append(".").append(keyColumn).append(" AND wfp.AD_Workflow_ID=?").append(" AND SUBSTR(wfp.WFState,1,1)='O')");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)document.get_TrxName());
            pstmt.setInt(1, wf.getAD_Client_ID());
            pstmt.setInt(2, document.get_ID());
            pstmt.setInt(3, document.get_Table_ID());
            pstmt.setInt(4, wf.getAD_Workflow_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = true;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Logic=" + logic + " - SQL=" + sql.toString(), (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DocWorkflowManager[");
        sb.append("Called=").append(this.m_noCalled).append(",Stated=").append(this.m_noStarted).append("]");
        return sb.toString();
    }

    static {
        PO.setDocWorkflowMgr((DocWorkflowMgr)DocWorkflowManager.get());
        s_mgr = null;
        log = CLogger.getCLogger(DocWorkflowManager.class);
    }
}

