/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.awt.Point;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MColumn;
import org.compiere.model.TranslationTable;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFNodePara;
import org.compiere.wf.MWorkflow;

public class MWFNode
extends X_AD_WF_Node {
    private static CCache<Integer, MWFNode> s_cache = new CCache("AD_WF_Node", 50);
    private ArrayList<MWFNodeNext> m_next = new ArrayList();
    private String m_name_trl = null;
    private String m_description_trl = null;
    private String m_help_trl = null;
    private boolean m_translated = false;
    private MColumn m_column = null;
    private MWFNodePara[] m_paras = null;
    private long m_durationBaseMS = -1L;

    public static MWFNode get(Ctx ctx, int AD_WF_Node_ID) {
        Integer key = new Integer(AD_WF_Node_ID);
        MWFNode retValue = (MWFNode)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWFNode(ctx, AD_WF_Node_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MWFNode(Ctx ctx, int AD_WF_Node_ID, String trxName) {
        super(ctx, AD_WF_Node_ID, trxName);
        if (AD_WF_Node_ID == 0) {
            this.setAction("Z");
            this.setCost(Env.ZERO);
            this.setDuration(0);
            this.setEntityType("U");
            this.setIsCentrallyMaintained(true);
            this.setJoinElement("X");
            this.setDurationLimit(0);
            this.setSplitElement("X");
            this.setWaitingTime(0);
            this.setXPosition(0);
            this.setYPosition(0);
        }
        if (this.get_ID() != 0) {
            s_cache.put((Object)new Integer(this.getAD_WF_Node_ID()), (Object)this);
        }
    }

    public MWFNode(MWorkflow wf, String Value, String Name2) {
        this(wf.getCtx(), 0, wf.get_TrxName());
        this.setClientOrg((PO)wf);
        this.setAD_Workflow_ID(wf.getAD_Workflow_ID());
        this.setValue(Value);
        this.setName(Name2);
        this.m_durationBaseMS = wf.getDurationBaseSec() * 1000L;
    }

    public MWFNode(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadNext();
        this.loadTrl();
        s_cache.put((Object)new Integer(this.getAD_WF_Node_ID()), (Object)this);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    private void loadNext() {
        String sql = "SELECT * FROM AD_WF_NodeNext WHERE AD_WF_Node_ID=? AND IsActive='Y' ORDER BY SeqNo";
        boolean splitAnd = "A".equals(this.getSplitElement());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MWFNodeNext next = new MWFNodeNext(this.getCtx(), rs, this.get_TrxName());
                next.setFromSplitAnd(splitAnd);
                this.m_next.add(next);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("#" + this.m_next.size());
    }

    private void loadTrl() {
        if (Env.isBaseLanguage((Ctx)this.getCtx(), (String)"AD_Workflow") || this.get_ID() == 0) {
            return;
        }
        String sql = "SELECT Name, Description, Help FROM AD_WF_Node_Trl WHERE AD_WF_Node_ID=? AND AD_Language=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            pstmt.setString(2, Env.getAD_Language((Ctx)this.getCtx()));
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_name_trl = rs.getString(1);
                this.m_description_trl = rs.getString(2);
                this.m_help_trl = rs.getString(3);
                this.m_translated = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("Trl=" + this.m_translated);
    }

    public int getNextNodeCount() {
        return this.m_next.size();
    }

    public MWFNodeNext[] getTransitions(int AD_Client_ID) {
        ArrayList<MWFNodeNext> list = new ArrayList<MWFNodeNext>();
        for (int i2 = 0; i2 < this.m_next.size(); ++i2) {
            MWFNodeNext next = this.m_next.get(i2);
            if (next.getAD_Client_ID() != 0 && next.getAD_Client_ID() != AD_Client_ID) continue;
            list.add(next);
        }
        MWFNodeNext[] retValue = new MWFNodeNext[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String getName(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_name_trl;
        }
        return this.getName();
    }

    public String getDescription(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_description_trl;
        }
        return this.getDescription();
    }

    public String getHelp(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_help_trl;
        }
        return this.getHelp();
    }

    public void setPosition(Point position) {
        this.setPosition(position.x, position.y);
    }

    public void setPosition(int x, int y) {
        this.setXPosition(x);
        this.setYPosition(y);
    }

    public Point getPosition() {
        return new Point(this.getXPosition(), this.getYPosition());
    }

    public String getActionInfo() {
        String action = this.getAction();
        if ("P".equals(action)) {
            return "Process:AD_Process_ID=" + this.getAD_Process_ID();
        }
        if ("D".equals(action)) {
            return "DocumentAction=" + this.getDocAction();
        }
        if ("R".equals(action)) {
            return "Report:AD_Process_ID=" + this.getAD_Process_ID();
        }
        if ("T".equals(action)) {
            return "Task:AD_Task_ID=" + this.getAD_Task_ID();
        }
        if ("V".equals(action)) {
            return "SetVariable:AD_Column_ID=" + this.getAD_Column_ID();
        }
        if ("F".equals(action)) {
            return "Workflow:AD_Workflow_ID=" + this.getAD_Workflow_ID();
        }
        if ("C".equals(action)) {
            return "UserChoice:AD_Column_ID=" + this.getAD_Column_ID();
        }
        if ("B".equals(action)) {
            return "Workbench:?";
        }
        if ("X".equals(action)) {
            return "Form:AD_Form_ID=" + this.getAD_Form_ID();
        }
        if ("W".equals(action)) {
            return "Window:AD_Window_ID=" + this.getAD_Window_ID();
        }
        if ("Z".equals(action)) {
            return "Sleep:WaitTime=" + this.getWaitTime();
        }
        return "??";
    }

    public String getAttributeName() {
        if (this.getAD_Column_ID() == 0) {
            return super.getAttributeName();
        }
        String attribute = super.getAttributeName();
        if (attribute != null && attribute.length() > 0) {
            return attribute;
        }
        this.setAttributeName(this.getColumn().getColumnName());
        return super.getAttributeName();
    }

    public MColumn getColumn() {
        if (this.getAD_Column_ID() == 0) {
            return null;
        }
        if (this.m_column == null) {
            this.m_column = MColumn.get((Ctx)this.getCtx(), (int)this.getAD_Column_ID());
        }
        return this.m_column;
    }

    public boolean isUserApproval() {
        if (!"C".equals(this.getAction())) {
            return false;
        }
        return this.getColumn() != null && "IsApproved".equals(this.getColumn().getColumnName());
    }

    public boolean isUserChoice() {
        return "C".equals(this.getAction());
    }

    public boolean isUserManual() {
        return "X".equals(this.getAction()) || "W".equals(this.getAction()) || "B".equals(this.getAction());
    }

    public long getDurationMS() {
        long duration = super.getDuration();
        if (duration == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getWorkflow().getDurationBaseSec() * 1000L;
        }
        return duration * this.m_durationBaseMS;
    }

    public long getDurationLimitMS() {
        long limit = super.getDurationLimit();
        if (limit == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getWorkflow().getDurationBaseSec() * 1000L;
        }
        return limit * this.m_durationBaseMS;
    }

    public int getDurationCalendarField() {
        return this.getWorkflow().getDurationCalendarField();
    }

    public int calculateDynamicPriority(int seconds) {
        if (seconds == 0 || this.getDynPriorityUnit() == null || this.getDynPriorityChange() == null || Env.ZERO.compareTo(this.getDynPriorityChange()) == 0) {
            return 0;
        }
        BigDecimal divide = Env.ZERO;
        if ("M".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(60);
        } else if ("H".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(3600);
        } else if ("D".equals(this.getDynPriorityUnit())) {
            divide = new BigDecimal(86400);
        } else {
            return 0;
        }
        BigDecimal change = new BigDecimal(seconds).divide(divide, 1).multiply(this.getDynPriorityChange());
        return change.intValue();
    }

    public MWFNodePara[] getParameters() {
        if (this.m_paras == null) {
            this.m_paras = MWFNodePara.getParameters(this.getCtx(), this.getAD_WF_Node_ID());
        }
        return this.m_paras;
    }

    public MWorkflow getWorkflow() {
        return MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWFNode[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Action=").append(this.getActionInfo()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("MWFNode[");
        sb.append(this.getName()).append("-").append(this.getActionInfo()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        String action = this.getAction();
        if (!action.equals("Z")) {
            if (action.equals("P") || action.equals("R")) {
                if (this.getAD_Process_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Process_ID"));
                    return false;
                }
            } else if (action.equals("T")) {
                if (this.getAD_Task_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Task_ID"));
                    return false;
                }
            } else if (action.equals("D")) {
                if (this.getDocAction() == null || this.getDocAction().length() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"DocAction"));
                    return false;
                }
            } else if (action.equals("M")) {
                if (this.getR_MailText_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"R_MailText_ID"));
                    return false;
                }
            } else if (action.equals("V")) {
                if (this.getAttributeValue() == null) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AttributeValue"));
                    return false;
                }
            } else if (action.equals("F")) {
                if (this.getAD_Workflow_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Workflow_ID"));
                    return false;
                }
            } else if (action.equals("C")) {
                if (this.getAD_Column_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Column_ID"));
                    return false;
                }
            } else if (action.equals("X")) {
                if (this.getAD_Form_ID() == 0) {
                    this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Form_ID"));
                    return false;
                }
            } else if (action.equals("W") && this.getAD_Window_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"AD_Window_ID"));
                return false;
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        TranslationTable.save((PO)this, (boolean)newRecord);
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (TranslationTable.isActiveLanguages((boolean)false)) {
            TranslationTable.delete((PO)this);
        }
        return success;
    }
}

