/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.MMenu;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.model.X_AD_Workflow;
import org.compiere.process.ProcessInfo;
import org.compiere.process.StateEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflowAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWorkflow
extends X_AD_Workflow {
    private static CCache<Integer, MWorkflow> s_cache = new CCache("AD_Workflow", 20);
    private static CCache<String, MWorkflow[]> s_cacheDocValue = new CCache("AD_Workflow", 5);
    private static CLogger s_log = CLogger.getCLogger(MWorkflow.class);
    private ArrayList<MWFNode> m_nodes = new ArrayList();
    private String m_name_trl = null;
    private String m_description_trl = null;
    private String m_help_trl = null;
    private boolean m_translated = false;

    public static MWorkflow get(Ctx ctx, int AD_Workflow_ID) {
        Integer key = new Integer(AD_Workflow_ID);
        MWorkflow retValue = (MWorkflow)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWorkflow(ctx, AD_Workflow_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MWorkflow[] getDocValue(Ctx ctx, int AD_Client_ID, int AD_Table_ID) {
        String key = "C" + AD_Client_ID + "T" + AD_Table_ID;
        if (s_cacheDocValue.isReset()) {
            String sql = "SELECT * FROM AD_Workflow WHERE WorkflowType='V' AND IsActive='Y' AND IsValid='Y' ORDER BY AD_Client_ID, AD_Table_ID";
            ArrayList<MWorkflow> list = new ArrayList<MWorkflow>();
            String oldKey = "";
            String newKey = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MWorkflow wf = new MWorkflow(ctx, rs, null);
                    newKey = "C" + wf.getAD_Client_ID() + "T" + wf.getAD_Table_ID();
                    if (!newKey.equals(oldKey) && list.size() > 0) {
                        MWorkflow[] wfs = new MWorkflow[list.size()];
                        list.toArray(wfs);
                        s_cacheDocValue.put((Object)oldKey, (Object)wfs);
                        list = new ArrayList();
                    }
                    oldKey = newKey;
                    list.add(wf);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (list.size() > 0) {
                MWorkflow[] wfs = new MWorkflow[list.size()];
                list.toArray(wfs);
                s_cacheDocValue.put((Object)oldKey, (Object)wfs);
            }
            s_log.config("#" + s_cacheDocValue.size());
        }
        MWorkflow[] retValue = (MWorkflow[])s_cacheDocValue.get((Object)key);
        return retValue;
    }

    public MWorkflow(Ctx ctx, int AD_Workflow_ID, String trxName) {
        super(ctx, AD_Workflow_ID, trxName);
        if (AD_Workflow_ID == 0) {
            this.setAccessLevel("1");
            this.setAuthor("ComPiere, Inc.");
            this.setDurationUnit("D");
            this.setDuration(1);
            this.setEntityType("U");
            this.setIsDefault(false);
            this.setPublishStatus("U");
            this.setVersion(0);
            this.setCost(Env.ZERO);
            this.setWaitingTime(0);
            this.setWorkingTime(0);
        }
        this.loadTrl();
        this.loadNodes();
    }

    public MWorkflow(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadTrl();
        this.loadNodes();
    }

    private void loadTrl() {
        if (Env.isBaseLanguage((Ctx)this.getCtx(), (String)"AD_Workflow") || this.get_ID() == 0) {
            return;
        }
        String sql = "SELECT Name, Description, Help FROM AD_Workflow_Trl WHERE AD_Workflow_ID=? AND AD_Language=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.get_ID());
            pstmt.setString(2, Env.getAD_Language((Ctx)this.getCtx()));
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_name_trl = rs.getString(1);
                this.m_description_trl = rs.getString(2);
                this.m_help_trl = rs.getString(3);
                this.m_translated = true;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("Translated=" + this.m_translated);
    }

    private void loadNodes() {
        String sql = "SELECT * FROM AD_WF_Node WHERE AD_Workflow_ID=? AND IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_nodes.add(new MWFNode(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("#" + this.m_nodes.size());
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    public MWFNode[] getNodes(boolean ordered, int AD_Client_ID) {
        if (ordered) {
            return this.getNodesInOrder(AD_Client_ID);
        }
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        for (int i2 = 0; i2 < this.m_nodes.size(); ++i2) {
            MWFNode node = this.m_nodes.get(i2);
            if (!node.isActive() || node.getAD_Client_ID() != 0 && node.getAD_Client_ID() != AD_Client_ID) continue;
            list.add(node);
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MWFNode getFirstNode() {
        return this.getNode(this.getAD_WF_Node_ID());
    }

    protected MWFNode getNode(int AD_WF_Node_ID) {
        for (int i2 = 0; i2 < this.m_nodes.size(); ++i2) {
            MWFNode node = this.m_nodes.get(i2);
            if (node.getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            return node;
        }
        return null;
    }

    public MWFNode[] getNextNodes(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node == null || node.getNextNodeCount() == 0) {
            return null;
        }
        MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        for (int i2 = 0; i2 < nexts.length; ++i2) {
            MWFNode next = this.getNode(nexts[i2].getAD_WF_Next_ID());
            if (next == null) continue;
            list.add(next);
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private MWFNode[] getNodesInOrder(int AD_Client_ID) {
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        this.addNodesSF(list, this.getAD_WF_Node_ID(), AD_Client_ID);
        if (this.m_nodes.size() != list.size()) {
            for (int n = 0; n < this.m_nodes.size(); ++n) {
                MWFNode node = this.m_nodes.get(n);
                if (!node.isActive() || node.getAD_Client_ID() != 0 && node.getAD_Client_ID() != AD_Client_ID) continue;
                boolean found = false;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    MWFNode existing = list.get(i2);
                    if (existing.getAD_WF_Node_ID() != node.getAD_WF_Node_ID()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.log.log(Level.WARNING, "Added Node w/o transition: " + (Object)((Object)node));
                list.add(node);
            }
        }
        MWFNode[] nodeArray = new MWFNode[list.size()];
        list.toArray(nodeArray);
        return nodeArray;
    }

    private void addNodesDF(ArrayList<MWFNode> list, int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node != null && !list.contains((Object)node)) {
            list.add(node);
            MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
            for (int i2 = 0; i2 < nexts.length; ++i2) {
                if (!nexts[i2].isActive()) continue;
                this.addNodesDF(list, nexts[i2].getAD_WF_Next_ID(), AD_Client_ID);
            }
        }
    }

    private void addNodesSF(ArrayList<MWFNode> list, int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node != null && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
            int i2;
            if (!list.contains((Object)node)) {
                list.add(node);
            }
            MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
            for (i2 = 0; i2 < nexts.length; ++i2) {
                MWFNode child = this.getNode(nexts[i2].getAD_WF_Next_ID());
                if (!child.isActive() || child.getAD_Client_ID() != 0 && child.getAD_Client_ID() != AD_Client_ID || list.contains((Object)child)) continue;
                list.add(child);
            }
            for (i2 = 0; i2 < nexts.length; ++i2) {
                if (!nexts[i2].isActive()) continue;
                this.addNodesSF(list, nexts[i2].getAD_WF_Next_ID(), AD_Client_ID);
            }
        }
    }

    public int getNext(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            if (nodes[i2].getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            MWFNodeNext[] nexts = nodes[i2].getTransitions(AD_Client_ID);
            if (nexts.length > 0) {
                return nexts[0].getAD_WF_Next_ID();
            }
            return 0;
        }
        return 0;
    }

    public MWFNodeNext[] getNodeNexts(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            if (nodes[i2].getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            return nodes[i2].getTransitions(AD_Client_ID);
        }
        return null;
    }

    public int getPrevious(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            if (nodes[i2].getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            if (i2 > 0) {
                return nodes[i2 - 1].getAD_WF_Node_ID();
            }
            return 0;
        }
        return 0;
    }

    public int getLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        if (nodes.length > 0) {
            return nodes[nodes.length - 1].getAD_WF_Node_ID();
        }
        return 0;
    }

    public boolean isFirst(int AD_WF_Node_ID, int AD_Client_ID) {
        return AD_WF_Node_ID == this.getAD_WF_Node_ID();
    }

    public boolean isLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        return AD_WF_Node_ID == nodes[nodes.length - 1].getAD_WF_Node_ID();
    }

    public String getName(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_name_trl;
        }
        return this.getName();
    }

    public String getDescription(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_description_trl;
        }
        return this.getDescription();
    }

    public String getHelp(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_help_trl;
        }
        return this.getHelp();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWorkflow[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        this.validate();
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int i2;
        this.log.fine("Success=" + success);
        if (success && newRecord) {
            MWFNode[] nodes = this.getNodesInOrder(0);
            for (i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2].save(this.get_TrxName());
            }
        }
        if (newRecord) {
            int AD_Role_ID = this.getCtx().getAD_Role_ID();
            MWorkflowAccess wa = new MWorkflowAccess(this, AD_Role_ID);
            wa.save();
        } else if (this.is_ValueChanged("IsActive") || this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help")) {
            MMenu[] menues = MMenu.get((Ctx)this.getCtx(), (String)("AD_Workflow_ID=" + this.getAD_Workflow_ID()));
            for (i2 = 0; i2 < menues.length; ++i2) {
                menues[i2].setIsActive(this.isActive());
                menues[i2].setName(this.getName());
                menues[i2].setDescription(this.getDescription());
                menues[i2].save();
            }
            X_AD_WF_Node[] nodes = MWindow.getWFNodes((Ctx)this.getCtx(), (String)("AD_Workflow_ID=" + this.getAD_Workflow_ID()));
            for (int i3 = 0; i3 < nodes.length; ++i3) {
                boolean changed = false;
                if (nodes[i3].isActive() != this.isActive()) {
                    nodes[i3].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i3].isCentrallyMaintained()) {
                    nodes[i3].setName(this.getName());
                    nodes[i3].setDescription(this.getDescription());
                    nodes[i3].setHelp(this.getHelp());
                    changed = true;
                }
                if (!changed) continue;
                nodes[i3].save();
            }
        }
        return success;
    }

    public MWFProcess start(ProcessInfo pi) {
        MWFProcess retValue = null;
        try {
            retValue = new MWFProcess(this, pi);
            retValue.save();
            retValue.startWork();
            pi.setSummary(Msg.getMsg((Ctx)this.getCtx(), (String)"Processing"));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            pi.setSummary(e.getMessage(), true);
            retValue = null;
        }
        return retValue;
    }

    public MWFProcess startWait(ProcessInfo pi) {
        int SLEEP = 500;
        int MAXLOOPS = 30;
        MWFProcess process = this.start(pi);
        if (process == null) {
            return null;
        }
        Thread.yield();
        StateEngine state = process.getState();
        int loops = 0;
        while (!state.isClosed() && !state.isSuspended()) {
            if (loops > MAXLOOPS) {
                this.log.warning("Timeout after sec " + 500 * MAXLOOPS / 1000);
                pi.setSummary(Msg.getMsg((Ctx)this.getCtx(), (String)"ProcessRunning"));
                pi.setIsTimeout(true);
                return process;
            }
            try {
                Thread.sleep(500L);
                ++loops;
            }
            catch (InterruptedException e) {
                this.log.log(Level.SEVERE, "Interrupted", (Throwable)e);
                pi.setSummary("Interrupted");
                return process;
            }
            Thread.yield();
            state = process.getState();
        }
        String summary = process.getProcessMsg();
        if (summary == null || summary.trim().length() == 0) {
            summary = state.toString();
        }
        pi.setSummary(summary, state.isTerminated() || state.isAborted());
        this.log.fine(summary);
        return process;
    }

    public long getDurationBaseSec() {
        if (this.getDurationUnit() == null) {
            return 0L;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 1L;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 60L;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 3600L;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 86400L;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2592000L;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 31536000L;
        }
        return 0L;
    }

    public int getDurationCalendarField() {
        if (this.getDurationUnit() == null) {
            return 12;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 13;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 12;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 10;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 6;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 1;
        }
        return 12;
    }

    public String validate() {
        StringBuffer errors = new StringBuffer();
        if (this.getAD_WF_Node_ID() == 0) {
            errors.append(" - No Start Node");
        }
        if ("V".equals(this.getWorkflowType()) && (this.getDocValueLogic() == null || this.getDocValueLogic().length() == 0)) {
            errors.append(" - No Document Value Logic");
        }
        boolean valid = errors.length() == 0;
        this.setIsValid(valid);
        if (!valid) {
            this.log.info("validate: " + errors);
        }
        return errors.toString();
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
        MWorkflow wf = new MWorkflow(Env.getCtx(), 0, null);
        wf.setValue("Process_xx");
        wf.setName(wf.getValue());
        wf.setDescription("(Standard " + wf.getValue());
        wf.setEntityType("D");
        wf.save();
        MWFNode node10 = new MWFNode(wf, "10", "(Start)");
        node10.setDescription("(Standard Node)");
        node10.setEntityType("D");
        node10.setAction("Z");
        node10.setWaitTime(0);
        node10.setPosition(5, 5);
        node10.save();
        wf.setAD_WF_Node_ID(node10.getAD_WF_Node_ID());
        wf.save();
        MWFNode node20 = new MWFNode(wf, "20", "(DocAuto)");
        node20.setDescription("(Standard Node)");
        node20.setEntityType("D");
        node20.setAction("D");
        node20.setDocAction("--");
        node20.setPosition(5, 120);
        node20.save();
        MWFNodeNext tr10_20 = new MWFNodeNext(node10, node20.getAD_WF_Node_ID());
        tr10_20.setEntityType("D");
        tr10_20.setDescription("(Standard Transition)");
        tr10_20.setSeqNo(100);
        tr10_20.save();
        MWFNode node100 = new MWFNode(wf, "100", "(DocPrepare)");
        node100.setDescription("(Standard Node)");
        node100.setEntityType("D");
        node100.setAction("D");
        node100.setDocAction("PR");
        node100.setPosition(170, 5);
        node100.save();
        MWFNodeNext tr10_100 = new MWFNodeNext(node10, node100.getAD_WF_Node_ID());
        tr10_100.setEntityType("D");
        tr10_100.setDescription("(Standard Approval)");
        tr10_100.setIsStdUserWorkflow(true);
        tr10_100.setSeqNo(10);
        tr10_100.save();
        MWFNode node200 = new MWFNode(wf, "200", "(DocComplete)");
        node200.setDescription("(Standard Node)");
        node200.setEntityType("D");
        node200.setAction("D");
        node200.setDocAction("CO");
        node200.setPosition(170, 120);
        node200.save();
        MWFNodeNext tr100_200 = new MWFNodeNext(node100, node200.getAD_WF_Node_ID());
        tr100_200.setEntityType("D");
        tr100_200.setDescription("(Standard Transition)");
        tr100_200.setSeqNo(100);
        tr100_200.save();
    }
}

