/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.labels.ContourToolTipGenerator;
import org.jfree.data.ContourDataset;

public class StandardContourToolTipGenerator
implements ContourToolTipGenerator,
Serializable {
    private DecimalFormat valueForm = new DecimalFormat("##.###");

    public String generateToolTip(ContourDataset data, int item) {
        Number x = data.getXValue(0, item);
        Number y = data.getYValue(0, item);
        Number z = data.getZValue(0, item);
        String xString = null;
        if (data.isDateAxis(0)) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
            StringBuffer strbuf = new StringBuffer();
            strbuf = formatter.format(new Date(x.longValue()), strbuf, new FieldPosition(0));
            xString = strbuf.toString();
        } else {
            xString = this.valueForm.format(x.doubleValue());
        }
        if (z != null) {
            return "X: " + xString + ", Y: " + this.valueForm.format(y.doubleValue()) + ", Z: " + this.valueForm.format(z.doubleValue());
        }
        return "X: " + xString + ", Y: " + this.valueForm.format(y.doubleValue()) + ", Z: no data";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof StandardContourToolTipGenerator) {
            StandardContourToolTipGenerator generator = (StandardContourToolTipGenerator)o;
            if (this.valueForm != null) {
                return this.valueForm.equals(generator.valueForm);
            }
        }
        return false;
    }
}

