/*
 * Copyright 2006 Sandy McArthur, Jr.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.mcarthur.sandy.gwt.event.list.client;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/**
 * A skeletal implementation of the EventList interface.
 *
 * @author Sandy McArthur
 * @see java.util.AbstractList
 */
public abstract class AbstractEventList extends AbstractList implements EventList {
    private final List listeners = new ArrayList();

    public void addListEventListener(final ListEventListener listEventListener) {
        listeners.add(listEventListener);
    }

    public void removeListEventListener(final ListEventListener listEventListener) {
        listeners.remove(listEventListener);
    }

    /**
     * Signals each listener of an event.
     *
     * @param listEvent the event to signal.
     */
    protected void fireListEvent(final ListEvent listEvent) {
        final Object[] l = listeners.toArray();
        for (int i=0; i< l.length; i++) {
            final ListEventListener listEventListener = (ListEventListener)l[i];
            listEventListener.listChanged(listEvent);
        }
    }

    /**
     * Same as {@link java.util.AbstractList#removeRange(int, int)}.
     * This is only here because GWT's emulation of AbstractList.removeRange(int,int) is
     * broken as of GWT 1.3.3. When GWT has a stable release with a fixed removeRange this
     * method will disapper and use the inherited version instead.
     */
    protected void removeRange(final int start, final int end) {
        // TODO: Remove this method when GWT has a correct AbstractList.removeRange method.
        for (int i = start; i < end; i++) {
            remove(start);
        }
    }
}
