/*
 * Copyright 2007 Sandy McArthur, Jr.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package org.mcarthur.sandy.gwt.plugin.client;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;

/**
 * TODO: Write Javadoc
 *
 * @author Sandy McArthur
 */
class FlashInnerHtmlImplIE6 extends FlashInnerHtmlImpl {

    public void registerCallbacks(final FlashInnerHtml instance, final String name) {
        Element div = instance.getElement();
        Element obj = DOM.getChild(div, 0);
        boolean attached = doRegister(instance, obj);
        if (!attached) {
            Window.setTitle("IE6 attachEvent deferred.");
            DeferredCommand.add(new Command() {
                public void execute() {
                    registerCallbacks(instance, name);
                }
            });
        }
    }

    private native boolean doRegister(FlashInnerHtml instance, Element obj) /*-{
        return obj.attachEvent("FSCommand", function (command, args) {
            instance.@org.mcarthur.sandy.gwt.plugin.client.FlashInnerHtml::doFSCommand(Ljava/lang/String;Ljava/lang/String;)(command, args);
        });
    }-*/;
}
