/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.sql.*;
import java.util.logging.*;

import org.compiere.util.*;

/**
 *	Organization Info Model
 *	
 *  @author Jorg Janke
 *  @version $Id: MOrgInfo.java,v 1.1 2008/01/16 07:34:29 jrmt Exp $
 */
public class MOrgInfo extends X_AD_OrgInfo
{	
	/**
	 * 	Load Constructor
	 *	@param ctx context
	 *	@param AD_Org_ID id
	 *	@param trx transaction
	 *	@return Org Info
	 */
	public static MOrgInfo get (Ctx ctx, int AD_Org_ID, String trx)
	{
		MOrgInfo retValue = null;
		String sql = "SELECT * FROM AD_OrgInfo WHERE AD_Org_ID=?";
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement(sql, trx);
			pstmt.setInt(1, AD_Org_ID);
			ResultSet rs = pstmt.executeQuery();
			if (rs.next())
				retValue = new MOrgInfo (ctx, rs, null);
			rs.close();
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			s_log.log(Level.SEVERE, sql, e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		return retValue;
	}	//	get

	/** Static Logger					*/
	private static CLogger		s_log = CLogger.getCLogger (MOrgInfo.class);

	
	/**************************************************************************
	 * 	Standard Constructor
	 *	@param ctx context
	 *	@param AD_Org_ID id 
	 *	@param trxName trx
	 */
	public MOrgInfo (Ctx ctx, int AD_Org_ID, String trxName)
	{
		super(ctx, AD_Org_ID, trxName);
	}	//	MOrgInfo
	
	/**
	 * 	Load Constructor
	 *	@param ctx context
	 *	@param rs result set
	 *	@param trxName transaction
	 */
	public MOrgInfo (Ctx ctx, ResultSet rs, String trxName)
	{
		super(ctx, rs, trxName);
	}	//	MOrgInfo

	/**
	 * 	Organization constructor
	 *	@param org org
	 */
	public MOrgInfo (MOrg org)
	{
		super(org.getCtx(), 0, org.get_TrxName());
		setClientOrg(org);
		setDUNS ("?");
		setTaxID ("?");
	}	//	MOrgInfo
	
	/**
	 * 	Get Default Org Warehouse
	 *	@return warehouse
	 */
	public int getM_Warehouse_ID()
	{
		int M_Warehouse_ID = super.getM_Warehouse_ID();
		if (M_Warehouse_ID != 0)
			return M_Warehouse_ID;
		//
		MWarehouse[] whss = MWarehouse.getForOrg(getCtx(), getAD_Org_ID());
		if (whss.length > 0)
		{
			M_Warehouse_ID = whss[0].getM_Warehouse_ID();
			setM_Warehouse_ID(M_Warehouse_ID);
			return M_Warehouse_ID;
		}
		log.warning("No Warehouse for AD_Org_ID=" + getAD_Org_ID());
		return 0;
	}	//	getM_Warehouse_ID

}	//	MOrgInfo
