/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Language
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: GenerateModel.java,v 1.1 2008/01/16 07:34:32 jrmt Exp $ */
public class X_AD_Language extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Language_ID id
@param trxName transaction
*/
public X_AD_Language (Ctx ctx, int AD_Language_ID, String trxName)
{
super (ctx, AD_Language_ID, trxName);
/** if (AD_Language_ID == 0)
{
setAD_Language (null);
setAD_Language_ID (0);	// @SQL=SELECT NVL(MAX(AD_Language_ID),999999)+1 FROM AD_Language WHERE AD_Language_ID > 1000
setCountryCode (null);
setIsBaseLanguage (false);	// N
setIsDecimalPoint (false);
setIsSystemLanguage (false);
setLanguageISO (null);
setName (null);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Language (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27459237995789L;
/** Last Updated Timestamp 2007-04-21 08:44:39.0 */
public static final long updatedMS = 1177112679000L;
/** AD_Table_ID=111 */
public static final int Table_ID=111;

/** TableName=AD_Language */
public static final String Table_Name="AD_Language";

protected static KeyNamePair Model = new KeyNamePair(111,"AD_Language");

protected BigDecimal accessLevel = new BigDecimal(4);
/** AccessLevel
@return 4 - System 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Language[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Language.
@param AD_Language Language for this entity */
public void setAD_Language (String AD_Language)
{
if (AD_Language == null) throw new IllegalArgumentException ("AD_Language is mandatory.");
if (AD_Language.length() > 5)
{
log.warning("Length > 5 - truncated");
AD_Language = AD_Language.substring(0,5);
}
set_ValueNoCheck ("AD_Language", AD_Language);
}
/** Get Language.
@return Language for this entity */
public String getAD_Language() 
{
return (String)get_Value("AD_Language");
}
/** Set Language ID.
@param AD_Language_ID Language ID */
public void setAD_Language_ID (int AD_Language_ID)
{
if (AD_Language_ID < 1) throw new IllegalArgumentException ("AD_Language_ID is mandatory.");
set_ValueNoCheck ("AD_Language_ID", new Integer(AD_Language_ID));
}
/** Get Language ID.
@return Language ID */
public int getAD_Language_ID() 
{
Integer ii = (Integer)get_Value("AD_Language_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set ISO Country Code.
@param CountryCode Upper-case two-letter alphabetic ISO Country code according to ISO 3166-1 - http://www.chemie.fu-berlin.de/diverse/doc/ISO_3166.html */
public void setCountryCode (String CountryCode)
{
if (CountryCode == null) throw new IllegalArgumentException ("CountryCode is mandatory.");
if (CountryCode.length() > 2)
{
log.warning("Length > 2 - truncated");
CountryCode = CountryCode.substring(0,2);
}
set_Value ("CountryCode", CountryCode);
}
/** Get ISO Country Code.
@return Upper-case two-letter alphabetic ISO Country code according to ISO 3166-1 - http://www.chemie.fu-berlin.de/diverse/doc/ISO_3166.html */
public String getCountryCode() 
{
return (String)get_Value("CountryCode");
}
/** Set Date Pattern.
@param DatePattern Java Date Pattern */
public void setDatePattern (String DatePattern)
{
if (DatePattern != null && DatePattern.length() > 20)
{
log.warning("Length > 20 - truncated");
DatePattern = DatePattern.substring(0,20);
}
set_Value ("DatePattern", DatePattern);
}
/** Get Date Pattern.
@return Java Date Pattern */
public String getDatePattern() 
{
return (String)get_Value("DatePattern");
}
/** Set Base Language.
@param IsBaseLanguage The system information is maintained in this language */
public void setIsBaseLanguage (boolean IsBaseLanguage)
{
set_ValueNoCheck ("IsBaseLanguage", new Boolean(IsBaseLanguage));
}
/** Get Base Language.
@return The system information is maintained in this language */
public boolean isBaseLanguage() 
{
Object oo = get_Value("IsBaseLanguage");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Decimal Point.
@param IsDecimalPoint The number notation has a decimal point (no decimal comma) */
public void setIsDecimalPoint (boolean IsDecimalPoint)
{
set_Value ("IsDecimalPoint", new Boolean(IsDecimalPoint));
}
/** Get Decimal Point.
@return The number notation has a decimal point (no decimal comma) */
public boolean isDecimalPoint() 
{
Object oo = get_Value("IsDecimalPoint");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set System Language.
@param IsSystemLanguage The screens, etc. are maintained in this Language */
public void setIsSystemLanguage (boolean IsSystemLanguage)
{
set_Value ("IsSystemLanguage", new Boolean(IsSystemLanguage));
}
/** Get System Language.
@return The screens, etc. are maintained in this Language */
public boolean isSystemLanguage() 
{
Object oo = get_Value("IsSystemLanguage");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set ISO Language Code.
@param LanguageISO Lower-case two-letter ISO-3166 code - http://www.ics.uci.edu/pub/ietf/http/related/iso639.txt  */
public void setLanguageISO (String LanguageISO)
{
if (LanguageISO == null) throw new IllegalArgumentException ("LanguageISO is mandatory.");
if (LanguageISO.length() > 2)
{
log.warning("Length > 2 - truncated");
LanguageISO = LanguageISO.substring(0,2);
}
set_Value ("LanguageISO", LanguageISO);
}
/** Get ISO Language Code.
@return Lower-case two-letter ISO-3166 code - http://www.ics.uci.edu/pub/ietf/http/related/iso639.txt  */
public String getLanguageISO() 
{
return (String)get_Value("LanguageISO");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Process Now.
@param Processing Process Now */
public void setProcessing (boolean Processing)
{
set_Value ("Processing", new Boolean(Processing));
}
/** Get Process Now.
@return Process Now */
public boolean isProcessing() 
{
Object oo = get_Value("Processing");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Time Pattern.
@param TimePattern Java Time Pattern */
public void setTimePattern (String TimePattern)
{
if (TimePattern != null && TimePattern.length() > 20)
{
log.warning("Length > 20 - truncated");
TimePattern = TimePattern.substring(0,20);
}
set_Value ("TimePattern", TimePattern);
}
/** Get Time Pattern.
@return Java Time Pattern */
public String getTimePattern() 
{
return (String)get_Value("TimePattern");
}
}
