/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for AD_Role
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: GenerateModel.java,v 1.1 2008/01/16 07:34:32 jrmt Exp $ */
public class X_AD_Role extends PO
{
/** Standard Constructor
@param ctx context
@param AD_Role_ID id
@param trxName transaction
*/
public X_AD_Role (Ctx ctx, int AD_Role_ID, String trxName)
{
super (ctx, AD_Role_ID, trxName);
/** if (AD_Role_ID == 0)
{
setAD_Role_ID (0);
setConfirmQueryRecords (0);	// 0
setIsAccessAllOrgs (false);	// N
setIsAdministrator (false);	// N
setIsCanApproveOwnDoc (false);
setIsCanExport (true);	// Y
setIsCanReport (true);	// Y
setIsChangeLog (false);	// N
setIsManual (false);
setIsPersonalAccess (false);	// N
setIsPersonalLock (false);	// N
setIsShowAcct (false);	// N
setIsUseBPRestrictions (false);	// N
setIsUseUserOrgAccess (false);	// N
setMaxQueryRecords (0);	// 0
setName (null);
setOverrideReturnPolicy (false);	// N
setOverwritePriceLimit (false);	// N
setPreferenceType (null);	// O
setUserLevel (null);	// O
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_AD_Role (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27477625317789L;
/** Last Updated Timestamp 2007-11-20 04:20:01.0 */
public static final long updatedMS = 1195500001000L;
/** AD_Table_ID=156 */
public static final int Table_ID=156;

/** TableName=AD_Role */
public static final String Table_Name="AD_Role";

protected static KeyNamePair Model = new KeyNamePair(156,"AD_Role");

protected BigDecimal accessLevel = new BigDecimal(6);
/** AccessLevel
@return 6 - System - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_AD_Role[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Role.
@param AD_Role_ID Responsibility Role */
public void setAD_Role_ID (int AD_Role_ID)
{
if (AD_Role_ID < 0) throw new IllegalArgumentException ("AD_Role_ID is mandatory.");
set_ValueNoCheck ("AD_Role_ID", new Integer(AD_Role_ID));
}
/** Get Role.
@return Responsibility Role */
public int getAD_Role_ID() 
{
Integer ii = (Integer)get_Value("AD_Role_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_Tree_Menu_ID AD_Reference_ID=184 */
public static final int AD_TREE_MENU_ID_AD_Reference_ID=184;
/** Set Menu Tree.
@param AD_Tree_Menu_ID Tree of the menu */
public void setAD_Tree_Menu_ID (int AD_Tree_Menu_ID)
{
if (AD_Tree_Menu_ID <= 0) set_Value ("AD_Tree_Menu_ID", null);
else
set_Value ("AD_Tree_Menu_ID", new Integer(AD_Tree_Menu_ID));
}
/** Get Menu Tree.
@return Tree of the menu */
public int getAD_Tree_Menu_ID() 
{
Integer ii = (Integer)get_Value("AD_Tree_Menu_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** AD_Tree_Org_ID AD_Reference_ID=184 */
public static final int AD_TREE_ORG_ID_AD_Reference_ID=184;
/** Set Organization Tree.
@param AD_Tree_Org_ID Tree to determine organizational hierarchy */
public void setAD_Tree_Org_ID (int AD_Tree_Org_ID)
{
if (AD_Tree_Org_ID <= 0) set_Value ("AD_Tree_Org_ID", null);
else
set_Value ("AD_Tree_Org_ID", new Integer(AD_Tree_Org_ID));
}
/** Get Organization Tree.
@return Tree to determine organizational hierarchy */
public int getAD_Tree_Org_ID() 
{
Integer ii = (Integer)get_Value("AD_Tree_Org_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Approval Amount.
@param AmtApproval The approval amount limit for this role */
public void setAmtApproval (BigDecimal AmtApproval)
{
set_Value ("AmtApproval", AmtApproval);
}
/** Get Approval Amount.
@return The approval amount limit for this role */
public BigDecimal getAmtApproval() 
{
BigDecimal bd = (BigDecimal)get_Value("AmtApproval");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Currency.
@param C_Currency_ID The Currency for this record */
public void setC_Currency_ID (int C_Currency_ID)
{
if (C_Currency_ID <= 0) set_Value ("C_Currency_ID", null);
else
set_Value ("C_Currency_ID", new Integer(C_Currency_ID));
}
/** Get Currency.
@return The Currency for this record */
public int getC_Currency_ID() 
{
Integer ii = (Integer)get_Value("C_Currency_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Confirm Query Records.
@param ConfirmQueryRecords Require Confirmation if more records will be returned by the query (If not defined 500) */
public void setConfirmQueryRecords (int ConfirmQueryRecords)
{
set_Value ("ConfirmQueryRecords", new Integer(ConfirmQueryRecords));
}
/** Get Confirm Query Records.
@return Require Confirmation if more records will be returned by the query (If not defined 500) */
public int getConfirmQueryRecords() 
{
Integer ii = (Integer)get_Value("ConfirmQueryRecords");
if (ii == null) return 0;
return ii.intValue();
}

/** ConnectionProfile AD_Reference_ID=364 */
public static final int CONNECTIONPROFILE_AD_Reference_ID=364;
/** LAN = L */
public static final String CONNECTIONPROFILE_LAN = "L";
/** Terminal Server = T */
public static final String CONNECTIONPROFILE_TerminalServer = "T";
/** VPN = V */
public static final String CONNECTIONPROFILE_VPN = "V";
/** WAN = W */
public static final String CONNECTIONPROFILE_WAN = "W";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isConnectionProfileValid (String test)
{
return test == null || test.equals("L") || test.equals("T") || test.equals("V") || test.equals("W");
}
/** Set Connection Profile.
@param ConnectionProfile How a Java Client connects to the server(s) */
public void setConnectionProfile (String ConnectionProfile)
{
if (!isConnectionProfileValid(ConnectionProfile))
throw new IllegalArgumentException ("ConnectionProfile Invalid value - " + ConnectionProfile + " - Reference_ID=364 - L - T - V - W");
if (ConnectionProfile != null && ConnectionProfile.length() > 1)
{
log.warning("Length > 1 - truncated");
ConnectionProfile = ConnectionProfile.substring(0,1);
}
set_Value ("ConnectionProfile", ConnectionProfile);
}
/** Get Connection Profile.
@return How a Java Client connects to the server(s) */
public String getConnectionProfile() 
{
return (String)get_Value("ConnectionProfile");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}

/** DisplayClientOrg AD_Reference_ID=427 */
public static final int DISPLAYCLIENTORG_AD_Reference_ID=427;
/** Always Tenant, Organziation = A */
public static final String DISPLAYCLIENTORG_AlwaysTenantOrganziation = "A";
/** No Tenant nor Org = N */
public static final String DISPLAYCLIENTORG_NoTenantNorOrg = "N";
/** Only Organization = O */
public static final String DISPLAYCLIENTORG_OnlyOrganization = "O";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isDisplayClientOrgValid (String test)
{
return test == null || test.equals("A") || test.equals("N") || test.equals("O");
}
/** Set Display.
@param DisplayClientOrg Display Policy for Tenant and Organization */
public void setDisplayClientOrg (String DisplayClientOrg)
{
if (!isDisplayClientOrgValid(DisplayClientOrg))
throw new IllegalArgumentException ("DisplayClientOrg Invalid value - " + DisplayClientOrg + " - Reference_ID=427 - A - N - O");
if (DisplayClientOrg != null && DisplayClientOrg.length() > 1)
{
log.warning("Length > 1 - truncated");
DisplayClientOrg = DisplayClientOrg.substring(0,1);
}
set_Value ("DisplayClientOrg", DisplayClientOrg);
}
/** Get Display.
@return Display Policy for Tenant and Organization */
public String getDisplayClientOrg() 
{
return (String)get_Value("DisplayClientOrg");
}
/** Set Access all Orgs.
@param IsAccessAllOrgs Access all Organizations (no org access control) of the client */
public void setIsAccessAllOrgs (boolean IsAccessAllOrgs)
{
set_Value ("IsAccessAllOrgs", new Boolean(IsAccessAllOrgs));
}
/** Get Access all Orgs.
@return Access all Organizations (no org access control) of the client */
public boolean isAccessAllOrgs() 
{
Object oo = get_Value("IsAccessAllOrgs");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Administrator.
@param IsAdministrator This is an administrator role */
public void setIsAdministrator (boolean IsAdministrator)
{
set_Value ("IsAdministrator", new Boolean(IsAdministrator));
}
/** Get Administrator.
@return This is an administrator role */
public boolean isAdministrator() 
{
Object oo = get_Value("IsAdministrator");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Approve own Documents.
@param IsCanApproveOwnDoc Users with this role can approve their own documents */
public void setIsCanApproveOwnDoc (boolean IsCanApproveOwnDoc)
{
set_Value ("IsCanApproveOwnDoc", new Boolean(IsCanApproveOwnDoc));
}
/** Get Approve own Documents.
@return Users with this role can approve their own documents */
public boolean isCanApproveOwnDoc() 
{
Object oo = get_Value("IsCanApproveOwnDoc");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Can Export.
@param IsCanExport Users with this role can export data */
public void setIsCanExport (boolean IsCanExport)
{
set_Value ("IsCanExport", new Boolean(IsCanExport));
}
/** Get Can Export.
@return Users with this role can export data */
public boolean isCanExport() 
{
Object oo = get_Value("IsCanExport");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Can Report.
@param IsCanReport Users with this role can create reports */
public void setIsCanReport (boolean IsCanReport)
{
set_Value ("IsCanReport", new Boolean(IsCanReport));
}
/** Get Can Report.
@return Users with this role can create reports */
public boolean isCanReport() 
{
Object oo = get_Value("IsCanReport");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Maintain Change Log.
@param IsChangeLog Maintain a log of changes */
public void setIsChangeLog (boolean IsChangeLog)
{
set_Value ("IsChangeLog", new Boolean(IsChangeLog));
}
/** Get Maintain Change Log.
@return Maintain a log of changes */
public boolean isChangeLog() 
{
Object oo = get_Value("IsChangeLog");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Manual.
@param IsManual This is a manual process */
public void setIsManual (boolean IsManual)
{
set_Value ("IsManual", new Boolean(IsManual));
}
/** Get Manual.
@return This is a manual process */
public boolean isManual() 
{
Object oo = get_Value("IsManual");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Personal Access.
@param IsPersonalAccess Allow access to all personal records */
public void setIsPersonalAccess (boolean IsPersonalAccess)
{
set_Value ("IsPersonalAccess", new Boolean(IsPersonalAccess));
}
/** Get Personal Access.
@return Allow access to all personal records */
public boolean isPersonalAccess() 
{
Object oo = get_Value("IsPersonalAccess");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Personal Lock.
@param IsPersonalLock Allow users with role to lock access to personal records */
public void setIsPersonalLock (boolean IsPersonalLock)
{
set_Value ("IsPersonalLock", new Boolean(IsPersonalLock));
}
/** Get Personal Lock.
@return Allow users with role to lock access to personal records */
public boolean isPersonalLock() 
{
Object oo = get_Value("IsPersonalLock");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Show Accounting.
@param IsShowAcct Users with this role can see accounting information */
public void setIsShowAcct (boolean IsShowAcct)
{
set_Value ("IsShowAcct", new Boolean(IsShowAcct));
}
/** Get Show Accounting.
@return Users with this role can see accounting information */
public boolean isShowAcct() 
{
Object oo = get_Value("IsShowAcct");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Use BP Restrictions.
@param IsUseBPRestrictions Use BP Restrictions */
public void setIsUseBPRestrictions (boolean IsUseBPRestrictions)
{
set_Value ("IsUseBPRestrictions", new Boolean(IsUseBPRestrictions));
}
/** Get Use BP Restrictions.
@return Use BP Restrictions */
public boolean isUseBPRestrictions() 
{
Object oo = get_Value("IsUseBPRestrictions");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Use User Org Access.
@param IsUseUserOrgAccess Use Org Access defined by user instead of Role Org Access */
public void setIsUseUserOrgAccess (boolean IsUseUserOrgAccess)
{
set_Value ("IsUseUserOrgAccess", new Boolean(IsUseUserOrgAccess));
}
/** Get Use User Org Access.
@return Use Org Access defined by user instead of Role Org Access */
public boolean isUseUserOrgAccess() 
{
Object oo = get_Value("IsUseUserOrgAccess");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Max Query Records.
@param MaxQueryRecords If defined, you cannot query more records as defined - the query criteria needs to be changed to query less records */
public void setMaxQueryRecords (int MaxQueryRecords)
{
set_Value ("MaxQueryRecords", new Integer(MaxQueryRecords));
}
/** Get Max Query Records.
@return If defined, you cannot query more records as defined - the query criteria needs to be changed to query less records */
public int getMaxQueryRecords() 
{
Integer ii = (Integer)get_Value("MaxQueryRecords");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name == null) throw new IllegalArgumentException ("Name is mandatory.");
if (Name.length() > 60)
{
log.warning("Length > 60 - truncated");
Name = Name.substring(0,60);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Override Return Policy.
@param OverrideReturnPolicy Override Return Policy if the policy timeframe is exceeded */
public void setOverrideReturnPolicy (boolean OverrideReturnPolicy)
{
set_Value ("OverrideReturnPolicy", new Boolean(OverrideReturnPolicy));
}
/** Get Override Return Policy.
@return Override Return Policy if the policy timeframe is exceeded */
public boolean isOverrideReturnPolicy() 
{
Object oo = get_Value("OverrideReturnPolicy");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Overwrite Price Limit.
@param OverwritePriceLimit Overwrite Price Limit if the Price List  enforces the Price Limit */
public void setOverwritePriceLimit (boolean OverwritePriceLimit)
{
set_Value ("OverwritePriceLimit", new Boolean(OverwritePriceLimit));
}
/** Get Overwrite Price Limit.
@return Overwrite Price Limit if the Price List  enforces the Price Limit */
public boolean isOverwritePriceLimit() 
{
Object oo = get_Value("OverwritePriceLimit");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}

/** PreferenceType AD_Reference_ID=330 */
public static final int PREFERENCETYPE_AD_Reference_ID=330;
/** Client = C */
public static final String PREFERENCETYPE_Client = "C";
/** None = N */
public static final String PREFERENCETYPE_None = "N";
/** Organization = O */
public static final String PREFERENCETYPE_Organization = "O";
/** User = U */
public static final String PREFERENCETYPE_User = "U";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPreferenceTypeValid (String test)
{
return test.equals("C") || test.equals("N") || test.equals("O") || test.equals("U");
}
/** Set Preference Level.
@param PreferenceType Determines what preferences the user can set */
public void setPreferenceType (String PreferenceType)
{
if (PreferenceType == null) throw new IllegalArgumentException ("PreferenceType is mandatory");
if (!isPreferenceTypeValid(PreferenceType))
throw new IllegalArgumentException ("PreferenceType Invalid value - " + PreferenceType + " - Reference_ID=330 - C - N - O - U");
if (PreferenceType.length() > 1)
{
log.warning("Length > 1 - truncated");
PreferenceType = PreferenceType.substring(0,1);
}
set_Value ("PreferenceType", PreferenceType);
}
/** Get Preference Level.
@return Determines what preferences the user can set */
public String getPreferenceType() 
{
return (String)get_Value("PreferenceType");
}

/** Supervisor_ID AD_Reference_ID=286 */
public static final int SUPERVISOR_ID_AD_Reference_ID=286;
/** Set Supervisor.
@param Supervisor_ID Supervisor for this user/organization - used for escalation and approval */
public void setSupervisor_ID (int Supervisor_ID)
{
if (Supervisor_ID <= 0) set_Value ("Supervisor_ID", null);
else
set_Value ("Supervisor_ID", new Integer(Supervisor_ID));
}
/** Get Supervisor.
@return Supervisor for this user/organization - used for escalation and approval */
public int getSupervisor_ID() 
{
Integer ii = (Integer)get_Value("Supervisor_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** UserLevel AD_Reference_ID=226 */
public static final int USERLEVEL_AD_Reference_ID=226;
/** Organization =   O */
public static final String USERLEVEL_Organization = "  O";
/** Client =  C  */
public static final String USERLEVEL_Client = " C ";
/** Client+Organization =  CO */
public static final String USERLEVEL_ClientPlusOrganization = " CO";
/** System = S   */
public static final String USERLEVEL_System = "S  ";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isUserLevelValid (String test)
{
return test.equals("  O") || test.equals(" C ") || test.equals(" CO") || test.equals("S  ");
}
/** Set User Level.
@param UserLevel System Client Organization */
public void setUserLevel (String UserLevel)
{
if (UserLevel == null) throw new IllegalArgumentException ("UserLevel is mandatory");
if (!isUserLevelValid(UserLevel))
throw new IllegalArgumentException ("UserLevel Invalid value - " + UserLevel + " - Reference_ID=226 -   O -  C  -  CO - S  ");
if (UserLevel.length() > 3)
{
log.warning("Length > 3 - truncated");
UserLevel = UserLevel.substring(0,3);
}
set_Value ("UserLevel", UserLevel);
}
/** Get User Level.
@return System Client Organization */
public String getUserLevel() 
{
return (String)get_Value("UserLevel");
}

/** WinUserDefLevel AD_Reference_ID=428 */
public static final int WINUSERDEFLEVEL_AD_Reference_ID=428;
/** Tenant (or Role or User) = C */
public static final String WINUSERDEFLEVEL_TenantOrRoleOrUser = "C";
/** None = N */
public static final String WINUSERDEFLEVEL_None = "N";
/** Role (or User) = R */
public static final String WINUSERDEFLEVEL_RoleOrUser = "R";
/** User only = U */
public static final String WINUSERDEFLEVEL_UserOnly = "U";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isWinUserDefLevelValid (String test)
{
return test == null || test.equals("C") || test.equals("N") || test.equals("R") || test.equals("U");
}
/** Set Customization Level.
@param WinUserDefLevel Level for Window Layout Customization */
public void setWinUserDefLevel (String WinUserDefLevel)
{
if (!isWinUserDefLevelValid(WinUserDefLevel))
throw new IllegalArgumentException ("WinUserDefLevel Invalid value - " + WinUserDefLevel + " - Reference_ID=428 - C - N - R - U");
if (WinUserDefLevel != null && WinUserDefLevel.length() > 1)
{
log.warning("Length > 1 - truncated");
WinUserDefLevel = WinUserDefLevel.substring(0,1);
}
set_Value ("WinUserDefLevel", WinUserDefLevel);
}
/** Get Customization Level.
@return Level for Window Layout Customization */
public String getWinUserDefLevel() 
{
return (String)get_Value("WinUserDefLevel");
}
}
