/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

/** Generated Model - DO NOT CHANGE */
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for I_Request
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: GenerateModel.java,v 1.1 2008/01/16 07:34:32 jrmt Exp $ */
public class X_I_Request extends PO
{
/** Standard Constructor
@param ctx context
@param I_Request_ID id
@param trxName transaction
*/
public X_I_Request (Ctx ctx, int I_Request_ID, String trxName)
{
super (ctx, I_Request_ID, trxName);
/** if (I_Request_ID == 0)
{
setI_IsImported (null);	// N
setI_Request_ID (0);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_I_Request (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27473145870789L;
/** Last Updated Timestamp 2007-09-29 08:02:34.0 */
public static final long updatedMS = 1191020554000L;
/** AD_Table_ID=940 */
public static final int Table_ID=940;

/** TableName=I_Request */
public static final String Table_Name="I_Request";

protected static KeyNamePair Model = new KeyNamePair(940,"I_Request");

protected BigDecimal accessLevel = new BigDecimal(2);
/** AccessLevel
@return 2 - Client 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_I_Request[").append(get_ID()).append("]");
return sb.toString();
}
/** Set Role.
@param AD_Role_ID Responsibility Role */
public void setAD_Role_ID (int AD_Role_ID)
{
if (AD_Role_ID <= 0) set_Value ("AD_Role_ID", null);
else
set_Value ("AD_Role_ID", new Integer(AD_Role_ID));
}
/** Get Role.
@return Responsibility Role */
public int getAD_Role_ID() 
{
Integer ii = (Integer)get_Value("AD_Role_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Table.
@param AD_Table_ID Database Table information */
public void setAD_Table_ID (int AD_Table_ID)
{
if (AD_Table_ID <= 0) set_Value ("AD_Table_ID", null);
else
set_Value ("AD_Table_ID", new Integer(AD_Table_ID));
}
/** Get Table.
@return Database Table information */
public int getAD_Table_ID() 
{
Integer ii = (Integer)get_Value("AD_Table_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set User/Contact.
@param AD_User_ID User within the system - Internal or Business Partner Contact */
public void setAD_User_ID (int AD_User_ID)
{
if (AD_User_ID <= 0) set_Value ("AD_User_ID", null);
else
set_Value ("AD_User_ID", new Integer(AD_User_ID));
}
/** Get User/Contact.
@return User within the system - Internal or Business Partner Contact */
public int getAD_User_ID() 
{
Integer ii = (Integer)get_Value("AD_User_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Asset.
@param A_Asset_ID Asset used internally or by customers */
public void setA_Asset_ID (int A_Asset_ID)
{
if (A_Asset_ID <= 0) set_Value ("A_Asset_ID", null);
else
set_Value ("A_Asset_ID", new Integer(A_Asset_ID));
}
/** Get Asset.
@return Asset used internally or by customers */
public int getA_Asset_ID() 
{
Integer ii = (Integer)get_Value("A_Asset_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Activity Name.
@param ActivityName Activity Name */
public void setActivityName (String ActivityName)
{
if (ActivityName != null && ActivityName.length() > 60)
{
log.warning("Length > 60 - truncated");
ActivityName = ActivityName.substring(0,60);
}
set_Value ("ActivityName", ActivityName);
}
/** Get Activity Name.
@return Activity Name */
public String getActivityName() 
{
return (String)get_Value("ActivityName");
}
/** Set Activity Key.
@param ActivityValue Activity Key */
public void setActivityValue (String ActivityValue)
{
if (ActivityValue != null && ActivityValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ActivityValue = ActivityValue.substring(0,40);
}
set_Value ("ActivityValue", ActivityValue);
}
/** Get Activity Key.
@return Activity Key */
public String getActivityValue() 
{
return (String)get_Value("ActivityValue");
}
/** Set Asset Name.
@param AssetName Asset Name */
public void setAssetName (String AssetName)
{
if (AssetName != null && AssetName.length() > 60)
{
log.warning("Length > 60 - truncated");
AssetName = AssetName.substring(0,60);
}
set_Value ("AssetName", AssetName);
}
/** Get Asset Name.
@return Asset Name */
public String getAssetName() 
{
return (String)get_Value("AssetName");
}
/** Set Asset Key.
@param AssetValue Asset Key */
public void setAssetValue (String AssetValue)
{
if (AssetValue != null && AssetValue.length() > 40)
{
log.warning("Length > 40 - truncated");
AssetValue = AssetValue.substring(0,40);
}
set_Value ("AssetValue", AssetValue);
}
/** Get Asset Key.
@return Asset Key */
public String getAssetValue() 
{
return (String)get_Value("AssetValue");
}
/** Set Business Partner Name.
@param BPartnerName Business Partner Name */
public void setBPartnerName (String BPartnerName)
{
if (BPartnerName != null && BPartnerName.length() > 120)
{
log.warning("Length > 120 - truncated");
BPartnerName = BPartnerName.substring(0,120);
}
set_Value ("BPartnerName", BPartnerName);
}
/** Get Business Partner Name.
@return Business Partner Name */
public String getBPartnerName() 
{
return (String)get_Value("BPartnerName");
}
/** Set BPartner (Agent) Name.
@param BPartnerSRName BPartner (Agent) Name */
public void setBPartnerSRName (String BPartnerSRName)
{
if (BPartnerSRName != null && BPartnerSRName.length() > 120)
{
log.warning("Length > 120 - truncated");
BPartnerSRName = BPartnerSRName.substring(0,120);
}
set_Value ("BPartnerSRName", BPartnerSRName);
}
/** Get BPartner (Agent) Name.
@return BPartner (Agent) Name */
public String getBPartnerSRName() 
{
return (String)get_Value("BPartnerSRName");
}
/** Set BPartner (Agent) Key.
@param BPartnerSRValue BPartner (Agent) Key */
public void setBPartnerSRValue (String BPartnerSRValue)
{
if (BPartnerSRValue != null && BPartnerSRValue.length() > 80)
{
log.warning("Length > 80 - truncated");
BPartnerSRValue = BPartnerSRValue.substring(0,80);
}
set_Value ("BPartnerSRValue", BPartnerSRValue);
}
/** Get BPartner (Agent) Key.
@return BPartner (Agent) Key */
public String getBPartnerSRValue() 
{
return (String)get_Value("BPartnerSRValue");
}
/** Set Business Partner Key.
@param BPartnerValue Key of the Business Partner */
public void setBPartnerValue (String BPartnerValue)
{
if (BPartnerValue != null && BPartnerValue.length() > 80)
{
log.warning("Length > 80 - truncated");
BPartnerValue = BPartnerValue.substring(0,80);
}
set_Value ("BPartnerValue", BPartnerValue);
}
/** Get Business Partner Key.
@return Key of the Business Partner */
public String getBPartnerValue() 
{
return (String)get_Value("BPartnerValue");
}
/** Set Activity.
@param C_Activity_ID Business Activity */
public void setC_Activity_ID (int C_Activity_ID)
{
if (C_Activity_ID <= 0) set_Value ("C_Activity_ID", null);
else
set_Value ("C_Activity_ID", new Integer(C_Activity_ID));
}
/** Get Activity.
@return Business Activity */
public int getC_Activity_ID() 
{
Integer ii = (Integer)get_Value("C_Activity_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** C_BPartnerSR_ID AD_Reference_ID=353 */
public static final int C_BPARTNERSR_ID_AD_Reference_ID=353;
/** Set BPartner (Agent).
@param C_BPartnerSR_ID Business Partner (Agent or Sales Rep) */
public void setC_BPartnerSR_ID (int C_BPartnerSR_ID)
{
if (C_BPartnerSR_ID <= 0) set_Value ("C_BPartnerSR_ID", null);
else
set_Value ("C_BPartnerSR_ID", new Integer(C_BPartnerSR_ID));
}
/** Get BPartner (Agent).
@return Business Partner (Agent or Sales Rep) */
public int getC_BPartnerSR_ID() 
{
Integer ii = (Integer)get_Value("C_BPartnerSR_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Business Partner .
@param C_BPartner_ID Identifies a Business Partner */
public void setC_BPartner_ID (int C_BPartner_ID)
{
if (C_BPartner_ID <= 0) set_Value ("C_BPartner_ID", null);
else
set_Value ("C_BPartner_ID", new Integer(C_BPartner_ID));
}
/** Get Business Partner .
@return Identifies a Business Partner */
public int getC_BPartner_ID() 
{
Integer ii = (Integer)get_Value("C_BPartner_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Campaign.
@param C_Campaign_ID Marketing Campaign */
public void setC_Campaign_ID (int C_Campaign_ID)
{
if (C_Campaign_ID <= 0) set_Value ("C_Campaign_ID", null);
else
set_Value ("C_Campaign_ID", new Integer(C_Campaign_ID));
}
/** Get Campaign.
@return Marketing Campaign */
public int getC_Campaign_ID() 
{
Integer ii = (Integer)get_Value("C_Campaign_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Invoice.
@param C_Invoice_ID Invoice Identifier */
public void setC_Invoice_ID (int C_Invoice_ID)
{
if (C_Invoice_ID <= 0) set_Value ("C_Invoice_ID", null);
else
set_Value ("C_Invoice_ID", new Integer(C_Invoice_ID));
}
/** Get Invoice.
@return Invoice Identifier */
public int getC_Invoice_ID() 
{
Integer ii = (Integer)get_Value("C_Invoice_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Lead.
@param C_Lead_ID Business Lead */
public void setC_Lead_ID (int C_Lead_ID)
{
if (C_Lead_ID <= 0) set_Value ("C_Lead_ID", null);
else
set_Value ("C_Lead_ID", new Integer(C_Lead_ID));
}
/** Get Lead.
@return Business Lead */
public int getC_Lead_ID() 
{
Integer ii = (Integer)get_Value("C_Lead_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Order.
@param C_Order_ID Order */
public void setC_Order_ID (int C_Order_ID)
{
if (C_Order_ID <= 0) set_Value ("C_Order_ID", null);
else
set_Value ("C_Order_ID", new Integer(C_Order_ID));
}
/** Get Order.
@return Order */
public int getC_Order_ID() 
{
Integer ii = (Integer)get_Value("C_Order_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Payment.
@param C_Payment_ID Payment identifier */
public void setC_Payment_ID (int C_Payment_ID)
{
if (C_Payment_ID <= 0) set_Value ("C_Payment_ID", null);
else
set_Value ("C_Payment_ID", new Integer(C_Payment_ID));
}
/** Get Payment.
@return Payment identifier */
public int getC_Payment_ID() 
{
Integer ii = (Integer)get_Value("C_Payment_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Project.
@param C_Project_ID Financial Project */
public void setC_Project_ID (int C_Project_ID)
{
if (C_Project_ID <= 0) set_Value ("C_Project_ID", null);
else
set_Value ("C_Project_ID", new Integer(C_Project_ID));
}
/** Get Project.
@return Financial Project */
public int getC_Project_ID() 
{
Integer ii = (Integer)get_Value("C_Project_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Sales Region.
@param C_SalesRegion_ID Sales coverage region */
public void setC_SalesRegion_ID (int C_SalesRegion_ID)
{
if (C_SalesRegion_ID <= 0) set_Value ("C_SalesRegion_ID", null);
else
set_Value ("C_SalesRegion_ID", new Integer(C_SalesRegion_ID));
}
/** Get Sales Region.
@return Sales coverage region */
public int getC_SalesRegion_ID() 
{
Integer ii = (Integer)get_Value("C_SalesRegion_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Campaign Name.
@param CampaignName Campaign Name */
public void setCampaignName (String CampaignName)
{
if (CampaignName != null && CampaignName.length() > 60)
{
log.warning("Length > 60 - truncated");
CampaignName = CampaignName.substring(0,60);
}
set_Value ("CampaignName", CampaignName);
}
/** Get Campaign Name.
@return Campaign Name */
public String getCampaignName() 
{
return (String)get_Value("CampaignName");
}
/** Set Campaign Key.
@param CampaignValue Campaign Key */
public void setCampaignValue (String CampaignValue)
{
if (CampaignValue != null && CampaignValue.length() > 40)
{
log.warning("Length > 40 - truncated");
CampaignValue = CampaignValue.substring(0,40);
}
set_Value ("CampaignValue", CampaignValue);
}
/** Get Campaign Key.
@return Campaign Key */
public String getCampaignValue() 
{
return (String)get_Value("CampaignValue");
}
/** Set Category Name.
@param CategoryName Name of the Category */
public void setCategoryName (String CategoryName)
{
if (CategoryName != null && CategoryName.length() > 60)
{
log.warning("Length > 60 - truncated");
CategoryName = CategoryName.substring(0,60);
}
set_Value ("CategoryName", CategoryName);
}
/** Get Category Name.
@return Name of the Category */
public String getCategoryName() 
{
return (String)get_Value("CategoryName");
}
/** Set Change Request Name.
@param ChangeRequestName Change Request Name */
public void setChangeRequestName (String ChangeRequestName)
{
if (ChangeRequestName != null && ChangeRequestName.length() > 60)
{
log.warning("Length > 60 - truncated");
ChangeRequestName = ChangeRequestName.substring(0,60);
}
set_Value ("ChangeRequestName", ChangeRequestName);
}
/** Get Change Request Name.
@return Change Request Name */
public String getChangeRequestName() 
{
return (String)get_Value("ChangeRequestName");
}
/** Set Tenant Name.
@param ClientName Tenant Name */
public void setClientName (String ClientName)
{
if (ClientName != null && ClientName.length() > 60)
{
log.warning("Length > 60 - truncated");
ClientName = ClientName.substring(0,60);
}
set_Value ("ClientName", ClientName);
}
/** Get Tenant Name.
@return Tenant Name */
public String getClientName() 
{
return (String)get_Value("ClientName");
}
/** Set Tenant Key.
@param ClientValue Key of the Tenant */
public void setClientValue (String ClientValue)
{
if (ClientValue != null && ClientValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ClientValue = ClientValue.substring(0,40);
}
set_Value ("ClientValue", ClientValue);
}
/** Get Tenant Key.
@return Key of the Tenant */
public String getClientValue() 
{
return (String)get_Value("ClientValue");
}
/** Set Close Date.
@param CloseDate Close Date */
public void setCloseDate (Timestamp CloseDate)
{
set_ValueNoCheck ("CloseDate", CloseDate);
}
/** Get Close Date.
@return Close Date */
public Timestamp getCloseDate() 
{
return (Timestamp)get_Value("CloseDate");
}

/** ConfidentialType AD_Reference_ID=340 */
public static final int CONFIDENTIALTYPE_AD_Reference_ID=340;
/** Public Information = A */
public static final String CONFIDENTIALTYPE_PublicInformation = "A";
/** Partner Confidential = C */
public static final String CONFIDENTIALTYPE_PartnerConfidential = "C";
/** Internal = I */
public static final String CONFIDENTIALTYPE_Internal = "I";
/** Private Information = P */
public static final String CONFIDENTIALTYPE_PrivateInformation = "P";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isConfidentialTypeValid (String test)
{
return test == null || test.equals("A") || test.equals("C") || test.equals("I") || test.equals("P");
}
/** Set Confidentiality.
@param ConfidentialType Type of Confidentiality */
public void setConfidentialType (String ConfidentialType)
{
if (!isConfidentialTypeValid(ConfidentialType))
throw new IllegalArgumentException ("ConfidentialType Invalid value - " + ConfidentialType + " - Reference_ID=340 - A - C - I - P");
if (ConfidentialType != null && ConfidentialType.length() > 1)
{
log.warning("Length > 1 - truncated");
ConfidentialType = ConfidentialType.substring(0,1);
}
set_Value ("ConfidentialType", ConfidentialType);
}
/** Get Confidentiality.
@return Type of Confidentiality */
public String getConfidentialType() 
{
return (String)get_Value("ConfidentialType");
}

/** ConfidentialTypeEntry AD_Reference_ID=340 */
public static final int CONFIDENTIALTYPEENTRY_AD_Reference_ID=340;
/** Public Information = A */
public static final String CONFIDENTIALTYPEENTRY_PublicInformation = "A";
/** Partner Confidential = C */
public static final String CONFIDENTIALTYPEENTRY_PartnerConfidential = "C";
/** Internal = I */
public static final String CONFIDENTIALTYPEENTRY_Internal = "I";
/** Private Information = P */
public static final String CONFIDENTIALTYPEENTRY_PrivateInformation = "P";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isConfidentialTypeEntryValid (String test)
{
return test == null || test.equals("A") || test.equals("C") || test.equals("I") || test.equals("P");
}
/** Set Entry Access Level.
@param ConfidentialTypeEntry Confidentiality of the individual entry */
public void setConfidentialTypeEntry (String ConfidentialTypeEntry)
{
if (!isConfidentialTypeEntryValid(ConfidentialTypeEntry))
throw new IllegalArgumentException ("ConfidentialTypeEntry Invalid value - " + ConfidentialTypeEntry + " - Reference_ID=340 - A - C - I - P");
if (ConfidentialTypeEntry != null && ConfidentialTypeEntry.length() > 1)
{
log.warning("Length > 1 - truncated");
ConfidentialTypeEntry = ConfidentialTypeEntry.substring(0,1);
}
set_Value ("ConfidentialTypeEntry", ConfidentialTypeEntry);
}
/** Get Entry Access Level.
@return Confidentiality of the individual entry */
public String getConfidentialTypeEntry() 
{
return (String)get_Value("ConfidentialTypeEntry");
}
/** Set Contact Name.
@param ContactName Business Partner Contact Name */
public void setContactName (String ContactName)
{
if (ContactName != null && ContactName.length() > 120)
{
log.warning("Length > 120 - truncated");
ContactName = ContactName.substring(0,120);
}
set_Value ("ContactName", ContactName);
}
/** Get Contact Name.
@return Business Partner Contact Name */
public String getContactName() 
{
return (String)get_Value("ContactName");
}
/** Set Contact Key.
@param ContactValue Key of the Contact */
public void setContactValue (String ContactValue)
{
if (ContactValue != null && ContactValue.length() > 80)
{
log.warning("Length > 80 - truncated");
ContactValue = ContactValue.substring(0,80);
}
set_Value ("ContactValue", ContactValue);
}
/** Get Contact Key.
@return Key of the Contact */
public String getContactValue() 
{
return (String)get_Value("ContactValue");
}
/** Set Complete Plan.
@param DateCompletePlan Planned Completion Date */
public void setDateCompletePlan (Timestamp DateCompletePlan)
{
set_ValueNoCheck ("DateCompletePlan", DateCompletePlan);
}
/** Get Complete Plan.
@return Planned Completion Date */
public Timestamp getDateCompletePlan() 
{
return (Timestamp)get_Value("DateCompletePlan");
}
/** Set Date last action.
@param DateLastAction Date this request was last acted on */
public void setDateLastAction (Timestamp DateLastAction)
{
set_ValueNoCheck ("DateLastAction", DateLastAction);
}
/** Get Date last action.
@return Date this request was last acted on */
public Timestamp getDateLastAction() 
{
return (Timestamp)get_Value("DateLastAction");
}
/** Set Last Alert.
@param DateLastAlert Date when last alert were sent */
public void setDateLastAlert (Timestamp DateLastAlert)
{
set_ValueNoCheck ("DateLastAlert", DateLastAlert);
}
/** Get Last Alert.
@return Date when last alert were sent */
public Timestamp getDateLastAlert() 
{
return (Timestamp)get_Value("DateLastAlert");
}
/** Set Date next action.
@param DateNextAction Date that this request should be acted on */
public void setDateNextAction (Timestamp DateNextAction)
{
set_ValueNoCheck ("DateNextAction", DateNextAction);
}
/** Get Date next action.
@return Date that this request should be acted on */
public Timestamp getDateNextAction() 
{
return (Timestamp)get_Value("DateNextAction");
}
/** Set Start Plan.
@param DateStartPlan Planned Start Date */
public void setDateStartPlan (Timestamp DateStartPlan)
{
set_ValueNoCheck ("DateStartPlan", DateStartPlan);
}
/** Get Start Plan.
@return Planned Start Date */
public Timestamp getDateStartPlan() 
{
return (Timestamp)get_Value("DateStartPlan");
}
/** Set Document No.
@param DocumentNo Document sequence number of the document */
public void setDocumentNo (String DocumentNo)
{
if (DocumentNo != null && DocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
DocumentNo = DocumentNo.substring(0,30);
}
set_Value ("DocumentNo", DocumentNo);
}
/** Get Document No.
@return Document sequence number of the document */
public String getDocumentNo() 
{
return (String)get_Value("DocumentNo");
}

/** DueType AD_Reference_ID=222 */
public static final int DUETYPE_AD_Reference_ID=222;
/** Overdue = 3 */
public static final String DUETYPE_Overdue = "3";
/** Due = 5 */
public static final String DUETYPE_Due = "5";
/** Scheduled = 7 */
public static final String DUETYPE_Scheduled = "7";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isDueTypeValid (String test)
{
return test == null || test.equals("3") || test.equals("5") || test.equals("7");
}
/** Set Aging Status.
@param DueType Status of the next action for this Request */
public void setDueType (String DueType)
{
if (!isDueTypeValid(DueType))
throw new IllegalArgumentException ("DueType Invalid value - " + DueType + " - Reference_ID=222 - 3 - 5 - 7");
if (DueType != null && DueType.length() > 1)
{
log.warning("Length > 1 - truncated");
DueType = DueType.substring(0,1);
}
set_Value ("DueType", DueType);
}
/** Get Aging Status.
@return Status of the next action for this Request */
public String getDueType() 
{
return (String)get_Value("DueType");
}
/** Set End Time.
@param EndTime End of the time span */
public void setEndTime (Timestamp EndTime)
{
set_ValueNoCheck ("EndTime", EndTime);
}
/** Get End Time.
@return End of the time span */
public Timestamp getEndTime() 
{
return (Timestamp)get_Value("EndTime");
}
/** Set Group Name.
@param GroupName Group Name */
public void setGroupName (String GroupName)
{
if (GroupName != null && GroupName.length() > 60)
{
log.warning("Length > 60 - truncated");
GroupName = GroupName.substring(0,60);
}
set_Value ("GroupName", GroupName);
}
/** Get Group Name.
@return Group Name */
public String getGroupName() 
{
return (String)get_Value("GroupName");
}
/** Set Import Error Message.
@param I_ErrorMsg Messages generated from import process */
public void setI_ErrorMsg (String I_ErrorMsg)
{
if (I_ErrorMsg != null && I_ErrorMsg.length() > 2000)
{
log.warning("Length > 2000 - truncated");
I_ErrorMsg = I_ErrorMsg.substring(0,2000);
}
set_Value ("I_ErrorMsg", I_ErrorMsg);
}
/** Get Import Error Message.
@return Messages generated from import process */
public String getI_ErrorMsg() 
{
return (String)get_Value("I_ErrorMsg");
}

/** I_IsImported AD_Reference_ID=420 */
public static final int I_ISIMPORTED_AD_Reference_ID=420;
/** Error = E */
public static final String I_ISIMPORTED_Error = "E";
/** No = N */
public static final String I_ISIMPORTED_No = "N";
/** Yes = Y */
public static final String I_ISIMPORTED_Yes = "Y";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isI_IsImportedValid (String test)
{
return test.equals("E") || test.equals("N") || test.equals("Y");
}
/** Set Imported.
@param I_IsImported Has this import been processed */
public void setI_IsImported (String I_IsImported)
{
if (I_IsImported == null) throw new IllegalArgumentException ("I_IsImported is mandatory");
if (!isI_IsImportedValid(I_IsImported))
throw new IllegalArgumentException ("I_IsImported Invalid value - " + I_IsImported + " - Reference_ID=420 - E - N - Y");
if (I_IsImported.length() > 1)
{
log.warning("Length > 1 - truncated");
I_IsImported = I_IsImported.substring(0,1);
}
set_Value ("I_IsImported", I_IsImported);
}
/** Get Imported.
@return Has this import been processed */
public String getI_IsImported() 
{
return (String)get_Value("I_IsImported");
}
/** Set I_Request_ID.
@param I_Request_ID I_Request_ID */
public void setI_Request_ID (int I_Request_ID)
{
if (I_Request_ID < 1) throw new IllegalArgumentException ("I_Request_ID is mandatory.");
set_ValueNoCheck ("I_Request_ID", new Integer(I_Request_ID));
}
/** Get I_Request_ID.
@return I_Request_ID */
public int getI_Request_ID() 
{
Integer ii = (Integer)get_Value("I_Request_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Shipment/Receipt Document No.
@param InOutDocumentNo Shipment/Receipt Document No */
public void setInOutDocumentNo (String InOutDocumentNo)
{
if (InOutDocumentNo != null && InOutDocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
InOutDocumentNo = InOutDocumentNo.substring(0,30);
}
set_Value ("InOutDocumentNo", InOutDocumentNo);
}
/** Get Shipment/Receipt Document No.
@return Shipment/Receipt Document No */
public String getInOutDocumentNo() 
{
return (String)get_Value("InOutDocumentNo");
}
/** Set Invoice Document No.
@param InvoiceDocumentNo Document Number of the Invoice */
public void setInvoiceDocumentNo (String InvoiceDocumentNo)
{
if (InvoiceDocumentNo != null && InvoiceDocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
InvoiceDocumentNo = InvoiceDocumentNo.substring(0,30);
}
set_Value ("InvoiceDocumentNo", InvoiceDocumentNo);
}
/** Get Invoice Document No.
@return Document Number of the Invoice */
public String getInvoiceDocumentNo() 
{
return (String)get_Value("InvoiceDocumentNo");
}
/** Set Escalated.
@param IsEscalated This request has been escalated */
public void setIsEscalated (boolean IsEscalated)
{
set_Value ("IsEscalated", new Boolean(IsEscalated));
}
/** Get Escalated.
@return This request has been escalated */
public boolean isEscalated() 
{
Object oo = get_Value("IsEscalated");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Invoiced.
@param IsInvoiced Is this invoiced? */
public void setIsInvoiced (boolean IsInvoiced)
{
set_Value ("IsInvoiced", new Boolean(IsInvoiced));
}
/** Get Invoiced.
@return Is this invoiced? */
public boolean isInvoiced() 
{
Object oo = get_Value("IsInvoiced");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Self-Service.
@param IsSelfService This is a Self-Service entry or this entry can be changed via Self-Service */
public void setIsSelfService (boolean IsSelfService)
{
set_Value ("IsSelfService", new Boolean(IsSelfService));
}
/** Get Self-Service.
@return This is a Self-Service entry or this entry can be changed via Self-Service */
public boolean isSelfService() 
{
Object oo = get_Value("IsSelfService");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Last Result.
@param LastResult Result of last contact */
public void setLastResult (String LastResult)
{
if (LastResult != null && LastResult.length() > 2000)
{
log.warning("Length > 2000 - truncated");
LastResult = LastResult.substring(0,2000);
}
set_Value ("LastResult", LastResult);
}
/** Get Last Result.
@return Result of last contact */
public String getLastResult() 
{
return (String)get_Value("LastResult");
}
/** Set Lead Document No.
@param LeadDocumentNo Lead Document No */
public void setLeadDocumentNo (String LeadDocumentNo)
{
if (LeadDocumentNo != null && LeadDocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
LeadDocumentNo = LeadDocumentNo.substring(0,30);
}
set_Value ("LeadDocumentNo", LeadDocumentNo);
}
/** Get Lead Document No.
@return Lead Document No */
public String getLeadDocumentNo() 
{
return (String)get_Value("LeadDocumentNo");
}
/** Set Change Request.
@param M_ChangeRequest_ID BOM (Engineering) Change Request */
public void setM_ChangeRequest_ID (int M_ChangeRequest_ID)
{
if (M_ChangeRequest_ID <= 0) set_Value ("M_ChangeRequest_ID", null);
else
set_Value ("M_ChangeRequest_ID", new Integer(M_ChangeRequest_ID));
}
/** Get Change Request.
@return BOM (Engineering) Change Request */
public int getM_ChangeRequest_ID() 
{
Integer ii = (Integer)get_Value("M_ChangeRequest_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Shipment/Receipt.
@param M_InOut_ID Material Shipment Document */
public void setM_InOut_ID (int M_InOut_ID)
{
if (M_InOut_ID <= 0) set_Value ("M_InOut_ID", null);
else
set_Value ("M_InOut_ID", new Integer(M_InOut_ID));
}
/** Get Shipment/Receipt.
@return Material Shipment Document */
public int getM_InOut_ID() 
{
Integer ii = (Integer)get_Value("M_InOut_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** M_ProductSpent_ID AD_Reference_ID=162 */
public static final int M_PRODUCTSPENT_ID_AD_Reference_ID=162;
/** Set Product Used.
@param M_ProductSpent_ID Product/Resource/Service used in Request */
public void setM_ProductSpent_ID (int M_ProductSpent_ID)
{
if (M_ProductSpent_ID <= 0) set_Value ("M_ProductSpent_ID", null);
else
set_Value ("M_ProductSpent_ID", new Integer(M_ProductSpent_ID));
}
/** Get Product Used.
@return Product/Resource/Service used in Request */
public int getM_ProductSpent_ID() 
{
Integer ii = (Integer)get_Value("M_ProductSpent_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Product.
@param M_Product_ID Product, Service, Item */
public void setM_Product_ID (int M_Product_ID)
{
if (M_Product_ID <= 0) set_Value ("M_Product_ID", null);
else
set_Value ("M_Product_ID", new Integer(M_Product_ID));
}
/** Get Product.
@return Product, Service, Item */
public int getM_Product_ID() 
{
Integer ii = (Integer)get_Value("M_Product_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** NextAction AD_Reference_ID=219 */
public static final int NEXTACTION_AD_Reference_ID=219;
/** Follow up = F */
public static final String NEXTACTION_FollowUp = "F";
/** None = N */
public static final String NEXTACTION_None = "N";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isNextActionValid (String test)
{
return test == null || test.equals("F") || test.equals("N");
}
/** Set Next action.
@param NextAction Next Action to be taken */
public void setNextAction (String NextAction)
{
if (!isNextActionValid(NextAction))
throw new IllegalArgumentException ("NextAction Invalid value - " + NextAction + " - Reference_ID=219 - F - N");
if (NextAction != null && NextAction.length() > 1)
{
log.warning("Length > 1 - truncated");
NextAction = NextAction.substring(0,1);
}
set_Value ("NextAction", NextAction);
}
/** Get Next action.
@return Next Action to be taken */
public String getNextAction() 
{
return (String)get_Value("NextAction");
}
/** Set Order Document No.
@param OrderDocumentNo Order Document No */
public void setOrderDocumentNo (String OrderDocumentNo)
{
if (OrderDocumentNo != null && OrderDocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
OrderDocumentNo = OrderDocumentNo.substring(0,30);
}
set_Value ("OrderDocumentNo", OrderDocumentNo);
}
/** Get Order Document No.
@return Order Document No */
public String getOrderDocumentNo() 
{
return (String)get_Value("OrderDocumentNo");
}
/** Set Organization Name.
@param OrgName Name of the Organization */
public void setOrgName (String OrgName)
{
if (OrgName != null && OrgName.length() > 60)
{
log.warning("Length > 60 - truncated");
OrgName = OrgName.substring(0,60);
}
set_Value ("OrgName", OrgName);
}
/** Get Organization Name.
@return Name of the Organization */
public String getOrgName() 
{
return (String)get_Value("OrgName");
}
/** Set Organization Key.
@param OrgValue Key of the Organization */
public void setOrgValue (String OrgValue)
{
if (OrgValue != null && OrgValue.length() > 40)
{
log.warning("Length > 40 - truncated");
OrgValue = OrgValue.substring(0,40);
}
set_Value ("OrgValue", OrgValue);
}
/** Get Organization Key.
@return Key of the Organization */
public String getOrgValue() 
{
return (String)get_Value("OrgValue");
}
/** Set Payment Document No.
@param PaymentDocumentNo Document number of the Payment */
public void setPaymentDocumentNo (String PaymentDocumentNo)
{
if (PaymentDocumentNo != null && PaymentDocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
PaymentDocumentNo = PaymentDocumentNo.substring(0,30);
}
set_Value ("PaymentDocumentNo", PaymentDocumentNo);
}
/** Get Payment Document No.
@return Document number of the Payment */
public String getPaymentDocumentNo() 
{
return (String)get_Value("PaymentDocumentNo");
}

/** Priority AD_Reference_ID=154 */
public static final int PRIORITY_AD_Reference_ID=154;
/** Urgent = 1 */
public static final String PRIORITY_Urgent = "1";
/** High = 3 */
public static final String PRIORITY_High = "3";
/** Medium = 5 */
public static final String PRIORITY_Medium = "5";
/** Low = 7 */
public static final String PRIORITY_Low = "7";
/** Minor = 9 */
public static final String PRIORITY_Minor = "9";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPriorityValid (String test)
{
return test == null || test.equals("1") || test.equals("3") || test.equals("5") || test.equals("7") || test.equals("9");
}
/** Set Priority.
@param Priority Indicates if this request is of a high, medium or low priority. */
public void setPriority (String Priority)
{
if (!isPriorityValid(Priority))
throw new IllegalArgumentException ("Priority Invalid value - " + Priority + " - Reference_ID=154 - 1 - 3 - 5 - 7 - 9");
if (Priority != null && Priority.length() > 1)
{
log.warning("Length > 1 - truncated");
Priority = Priority.substring(0,1);
}
set_Value ("Priority", Priority);
}
/** Get Priority.
@return Indicates if this request is of a high, medium or low priority. */
public String getPriority() 
{
return (String)get_Value("Priority");
}

/** PriorityUser AD_Reference_ID=154 */
public static final int PRIORITYUSER_AD_Reference_ID=154;
/** Urgent = 1 */
public static final String PRIORITYUSER_Urgent = "1";
/** High = 3 */
public static final String PRIORITYUSER_High = "3";
/** Medium = 5 */
public static final String PRIORITYUSER_Medium = "5";
/** Low = 7 */
public static final String PRIORITYUSER_Low = "7";
/** Minor = 9 */
public static final String PRIORITYUSER_Minor = "9";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPriorityUserValid (String test)
{
return test == null || test.equals("1") || test.equals("3") || test.equals("5") || test.equals("7") || test.equals("9");
}
/** Set User Priority.
@param PriorityUser Priority of the issue for the User */
public void setPriorityUser (String PriorityUser)
{
if (!isPriorityUserValid(PriorityUser))
throw new IllegalArgumentException ("PriorityUser Invalid value - " + PriorityUser + " - Reference_ID=154 - 1 - 3 - 5 - 7 - 9");
if (PriorityUser != null && PriorityUser.length() > 1)
{
log.warning("Length > 1 - truncated");
PriorityUser = PriorityUser.substring(0,1);
}
set_Value ("PriorityUser", PriorityUser);
}
/** Get User Priority.
@return Priority of the issue for the User */
public String getPriorityUser() 
{
return (String)get_Value("PriorityUser");
}
/** Set Processed.
@param Processed The document has been processed */
public void setProcessed (boolean Processed)
{
set_Value ("Processed", new Boolean(Processed));
}
/** Get Processed.
@return The document has been processed */
public boolean isProcessed() 
{
Object oo = get_Value("Processed");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Process Now.
@param Processing Process Now */
public void setProcessing (boolean Processing)
{
set_Value ("Processing", new Boolean(Processing));
}
/** Get Process Now.
@return Process Now */
public boolean isProcessing() 
{
Object oo = get_Value("Processing");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Product Name.
@param ProductName Name of the Product */
public void setProductName (String ProductName)
{
if (ProductName != null && ProductName.length() > 60)
{
log.warning("Length > 60 - truncated");
ProductName = ProductName.substring(0,60);
}
set_Value ("ProductName", ProductName);
}
/** Get Product Name.
@return Name of the Product */
public String getProductName() 
{
return (String)get_Value("ProductName");
}
/** Set Product Used Name.
@param ProductSpentName Product Used Name */
public void setProductSpentName (String ProductSpentName)
{
if (ProductSpentName != null && ProductSpentName.length() > 60)
{
log.warning("Length > 60 - truncated");
ProductSpentName = ProductSpentName.substring(0,60);
}
set_Value ("ProductSpentName", ProductSpentName);
}
/** Get Product Used Name.
@return Product Used Name */
public String getProductSpentName() 
{
return (String)get_Value("ProductSpentName");
}
/** Set Product Used Key.
@param ProductSpentValue Product Used Key */
public void setProductSpentValue (String ProductSpentValue)
{
if (ProductSpentValue != null && ProductSpentValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ProductSpentValue = ProductSpentValue.substring(0,40);
}
set_Value ("ProductSpentValue", ProductSpentValue);
}
/** Get Product Used Key.
@return Product Used Key */
public String getProductSpentValue() 
{
return (String)get_Value("ProductSpentValue");
}
/** Set Product Key.
@param ProductValue Key of the Product */
public void setProductValue (String ProductValue)
{
if (ProductValue != null && ProductValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ProductValue = ProductValue.substring(0,40);
}
set_Value ("ProductValue", ProductValue);
}
/** Get Product Key.
@return Key of the Product */
public String getProductValue() 
{
return (String)get_Value("ProductValue");
}
/** Set Project Name.
@param ProjectName Name of the Project */
public void setProjectName (String ProjectName)
{
if (ProjectName != null && ProjectName.length() > 60)
{
log.warning("Length > 60 - truncated");
ProjectName = ProjectName.substring(0,60);
}
set_Value ("ProjectName", ProjectName);
}
/** Get Project Name.
@return Name of the Project */
public String getProjectName() 
{
return (String)get_Value("ProjectName");
}
/** Set Project Key.
@param ProjectValue Key of the Project */
public void setProjectValue (String ProjectValue)
{
if (ProjectValue != null && ProjectValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ProjectValue = ProjectValue.substring(0,40);
}
set_Value ("ProjectValue", ProjectValue);
}
/** Get Project Key.
@return Key of the Project */
public String getProjectValue() 
{
return (String)get_Value("ProjectValue");
}
/** Set Quantity Invoiced.
@param QtyInvoiced Invoiced Quantity */
public void setQtyInvoiced (BigDecimal QtyInvoiced)
{
set_Value ("QtyInvoiced", QtyInvoiced);
}
/** Get Quantity Invoiced.
@return Invoiced Quantity */
public BigDecimal getQtyInvoiced() 
{
BigDecimal bd = (BigDecimal)get_Value("QtyInvoiced");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Quantity Plan.
@param QtyPlan Planned Quantity */
public void setQtyPlan (BigDecimal QtyPlan)
{
set_Value ("QtyPlan", QtyPlan);
}
/** Get Quantity Plan.
@return Planned Quantity */
public BigDecimal getQtyPlan() 
{
BigDecimal bd = (BigDecimal)get_Value("QtyPlan");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Quantity Used.
@param QtySpent Quantity used for this event */
public void setQtySpent (BigDecimal QtySpent)
{
set_Value ("QtySpent", QtySpent);
}
/** Get Quantity Used.
@return Quantity used for this event */
public BigDecimal getQtySpent() 
{
BigDecimal bd = (BigDecimal)get_Value("QtySpent");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Category.
@param R_Category_ID Request Category */
public void setR_Category_ID (int R_Category_ID)
{
if (R_Category_ID <= 0) set_Value ("R_Category_ID", null);
else
set_Value ("R_Category_ID", new Integer(R_Category_ID));
}
/** Get Category.
@return Request Category */
public int getR_Category_ID() 
{
Integer ii = (Integer)get_Value("R_Category_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Group.
@param R_Group_ID Request Group */
public void setR_Group_ID (int R_Group_ID)
{
if (R_Group_ID <= 0) set_Value ("R_Group_ID", null);
else
set_Value ("R_Group_ID", new Integer(R_Group_ID));
}
/** Get Group.
@return Request Group */
public int getR_Group_ID() 
{
Integer ii = (Integer)get_Value("R_Group_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** R_RequestRelated_ID AD_Reference_ID=341 */
public static final int R_REQUESTRELATED_ID_AD_Reference_ID=341;
/** Set Related Request.
@param R_RequestRelated_ID Related Request (Master Issue, ..) */
public void setR_RequestRelated_ID (int R_RequestRelated_ID)
{
if (R_RequestRelated_ID <= 0) set_Value ("R_RequestRelated_ID", null);
else
set_Value ("R_RequestRelated_ID", new Integer(R_RequestRelated_ID));
}
/** Get Related Request.
@return Related Request (Master Issue, ..) */
public int getR_RequestRelated_ID() 
{
Integer ii = (Integer)get_Value("R_RequestRelated_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Request Type.
@param R_RequestType_ID Type of request (e.g. Inquiry, Complaint, ..) */
public void setR_RequestType_ID (int R_RequestType_ID)
{
if (R_RequestType_ID <= 0) set_Value ("R_RequestType_ID", null);
else
set_Value ("R_RequestType_ID", new Integer(R_RequestType_ID));
}
/** Get Request Type.
@return Type of request (e.g. Inquiry, Complaint, ..) */
public int getR_RequestType_ID() 
{
Integer ii = (Integer)get_Value("R_RequestType_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Request.
@param R_Request_ID Request from a Business Partner or Prospect */
public void setR_Request_ID (int R_Request_ID)
{
if (R_Request_ID <= 0) set_Value ("R_Request_ID", null);
else
set_Value ("R_Request_ID", new Integer(R_Request_ID));
}
/** Get Request.
@return Request from a Business Partner or Prospect */
public int getR_Request_ID() 
{
Integer ii = (Integer)get_Value("R_Request_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Resolution.
@param R_Resolution_ID Request Resolution */
public void setR_Resolution_ID (int R_Resolution_ID)
{
if (R_Resolution_ID <= 0) set_Value ("R_Resolution_ID", null);
else
set_Value ("R_Resolution_ID", new Integer(R_Resolution_ID));
}
/** Get Resolution.
@return Request Resolution */
public int getR_Resolution_ID() 
{
Integer ii = (Integer)get_Value("R_Resolution_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Source.
@param R_Source_ID Source for the Lead or Request */
public void setR_Source_ID (int R_Source_ID)
{
if (R_Source_ID <= 0) set_Value ("R_Source_ID", null);
else
set_Value ("R_Source_ID", new Integer(R_Source_ID));
}
/** Get Source.
@return Source for the Lead or Request */
public int getR_Source_ID() 
{
Integer ii = (Integer)get_Value("R_Source_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Status.
@param R_Status_ID Request Status */
public void setR_Status_ID (int R_Status_ID)
{
if (R_Status_ID <= 0) set_Value ("R_Status_ID", null);
else
set_Value ("R_Status_ID", new Integer(R_Status_ID));
}
/** Get Status.
@return Request Status */
public int getR_Status_ID() 
{
Integer ii = (Integer)get_Value("R_Status_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Request Type Name.
@param ReqTypeName Request Type Name */
public void setReqTypeName (String ReqTypeName)
{
if (ReqTypeName != null && ReqTypeName.length() > 120)
{
log.warning("Length > 120 - truncated");
ReqTypeName = ReqTypeName.substring(0,120);
}
set_Value ("ReqTypeName", ReqTypeName);
}
/** Get Request Type Name.
@return Request Type Name */
public String getReqTypeName() 
{
return (String)get_Value("ReqTypeName");
}
/** Set Request Amount.
@param RequestAmt Amount associated with this request */
public void setRequestAmt (BigDecimal RequestAmt)
{
set_Value ("RequestAmt", RequestAmt);
}
/** Get Request Amount.
@return Amount associated with this request */
public BigDecimal getRequestAmt() 
{
BigDecimal bd = (BigDecimal)get_Value("RequestAmt");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Request Related Doc No.
@param RequestRelatedDocNo Request Related Doc No */
public void setRequestRelatedDocNo (String RequestRelatedDocNo)
{
if (RequestRelatedDocNo != null && RequestRelatedDocNo.length() > 30)
{
log.warning("Length > 30 - truncated");
RequestRelatedDocNo = RequestRelatedDocNo.substring(0,30);
}
set_Value ("RequestRelatedDocNo", RequestRelatedDocNo);
}
/** Get Request Related Doc No.
@return Request Related Doc No */
public String getRequestRelatedDocNo() 
{
return (String)get_Value("RequestRelatedDocNo");
}
/** Set Resolution Name.
@param ResolutionName Resolution Name */
public void setResolutionName (String ResolutionName)
{
if (ResolutionName != null && ResolutionName.length() > 60)
{
log.warning("Length > 60 - truncated");
ResolutionName = ResolutionName.substring(0,60);
}
set_Value ("ResolutionName", ResolutionName);
}
/** Get Resolution Name.
@return Resolution Name */
public String getResolutionName() 
{
return (String)get_Value("ResolutionName");
}
/** Set Result.
@param Result Result of the action taken */
public void setResult (String Result)
{
if (Result != null && Result.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Result = Result.substring(0,2000);
}
set_Value ("Result", Result);
}
/** Get Result.
@return Result of the action taken */
public String getResult() 
{
return (String)get_Value("Result");
}
/** Set Role Name.
@param RoleName Role Name */
public void setRoleName (String RoleName)
{
if (RoleName != null && RoleName.length() > 60)
{
log.warning("Length > 60 - truncated");
RoleName = RoleName.substring(0,60);
}
set_Value ("RoleName", RoleName);
}
/** Get Role Name.
@return Role Name */
public String getRoleName() 
{
return (String)get_Value("RoleName");
}
/** Set Sales Region Name.
@param SalesRegionName Sales Region Name */
public void setSalesRegionName (String SalesRegionName)
{
if (SalesRegionName != null && SalesRegionName.length() > 60)
{
log.warning("Length > 60 - truncated");
SalesRegionName = SalesRegionName.substring(0,60);
}
set_Value ("SalesRegionName", SalesRegionName);
}
/** Get Sales Region Name.
@return Sales Region Name */
public String getSalesRegionName() 
{
return (String)get_Value("SalesRegionName");
}
/** Set Sales Region Key.
@param SalesRegionValue Sales Region Key */
public void setSalesRegionValue (String SalesRegionValue)
{
if (SalesRegionValue != null && SalesRegionValue.length() > 40)
{
log.warning("Length > 40 - truncated");
SalesRegionValue = SalesRegionValue.substring(0,40);
}
set_Value ("SalesRegionValue", SalesRegionValue);
}
/** Get Sales Region Key.
@return Sales Region Key */
public String getSalesRegionValue() 
{
return (String)get_Value("SalesRegionValue");
}
/** Set Representative Name.
@param SalesRepName Representative Name */
public void setSalesRepName (String SalesRepName)
{
if (SalesRepName != null && SalesRepName.length() > 120)
{
log.warning("Length > 120 - truncated");
SalesRepName = SalesRepName.substring(0,120);
}
set_Value ("SalesRepName", SalesRepName);
}
/** Get Representative Name.
@return Representative Name */
public String getSalesRepName() 
{
return (String)get_Value("SalesRepName");
}
/** Set Representative Key.
@param SalesRepValue Representative Key */
public void setSalesRepValue (String SalesRepValue)
{
if (SalesRepValue != null && SalesRepValue.length() > 80)
{
log.warning("Length > 80 - truncated");
SalesRepValue = SalesRepValue.substring(0,80);
}
set_Value ("SalesRepValue", SalesRepValue);
}
/** Get Representative Key.
@return Representative Key */
public String getSalesRepValue() 
{
return (String)get_Value("SalesRepValue");
}

/** SalesRep_ID AD_Reference_ID=286 */
public static final int SALESREP_ID_AD_Reference_ID=286;
/** Set Representative.
@param SalesRep_ID Company Agent like Sales Representitive, Purchase Agent, Customer Service Representative, ... */
public void setSalesRep_ID (int SalesRep_ID)
{
if (SalesRep_ID <= 0) set_Value ("SalesRep_ID", null);
else
set_Value ("SalesRep_ID", new Integer(SalesRep_ID));
}
/** Get Representative.
@return Company Agent like Sales Representitive, Purchase Agent, Customer Service Representative, ... */
public int getSalesRep_ID() 
{
Integer ii = (Integer)get_Value("SalesRep_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Source Name.
@param SourceName Source Name */
public void setSourceName (String SourceName)
{
if (SourceName != null && SourceName.length() > 120)
{
log.warning("Length > 120 - truncated");
SourceName = SourceName.substring(0,120);
}
set_Value ("SourceName", SourceName);
}
/** Get Source Name.
@return Source Name */
public String getSourceName() 
{
return (String)get_Value("SourceName");
}
/** Set Source Key.
@param SourceValue Source Key */
public void setSourceValue (String SourceValue)
{
if (SourceValue != null && SourceValue.length() > 40)
{
log.warning("Length > 40 - truncated");
SourceValue = SourceValue.substring(0,40);
}
set_Value ("SourceValue", SourceValue);
}
/** Get Source Key.
@return Source Key */
public String getSourceValue() 
{
return (String)get_Value("SourceValue");
}
/** Set Start Date.
@param StartDate First effective day (inclusive) */
public void setStartDate (Timestamp StartDate)
{
set_ValueNoCheck ("StartDate", StartDate);
}
/** Get Start Date.
@return First effective day (inclusive) */
public Timestamp getStartDate() 
{
return (Timestamp)get_Value("StartDate");
}
/** Set Start Time.
@param StartTime Time started */
public void setStartTime (Timestamp StartTime)
{
set_ValueNoCheck ("StartTime", StartTime);
}
/** Get Start Time.
@return Time started */
public Timestamp getStartTime() 
{
return (Timestamp)get_Value("StartTime");
}
/** Set Status Name.
@param StatusName Status Name */
public void setStatusName (String StatusName)
{
if (StatusName != null && StatusName.length() > 60)
{
log.warning("Length > 60 - truncated");
StatusName = StatusName.substring(0,60);
}
set_Value ("StatusName", StatusName);
}
/** Get Status Name.
@return Status Name */
public String getStatusName() 
{
return (String)get_Value("StatusName");
}
/** Set Summary.
@param Summary Textual summary of this request */
public void setSummary (String Summary)
{
if (Summary != null && Summary.length() > 2000)
{
log.warning("Length > 2000 - truncated");
Summary = Summary.substring(0,2000);
}
set_Value ("Summary", Summary);
}
/** Get Summary.
@return Textual summary of this request */
public String getSummary() 
{
return (String)get_Value("Summary");
}
/** Set DB Table Name.
@param TableName Name of the table in the database */
public void setTableName (String TableName)
{
if (TableName != null && TableName.length() > 60)
{
log.warning("Length > 60 - truncated");
TableName = TableName.substring(0,60);
}
set_Value ("TableName", TableName);
}
/** Get DB Table Name.
@return Name of the table in the database */
public String getTableName() 
{
return (String)get_Value("TableName");
}

/** TaskStatus AD_Reference_ID=366 */
public static final int TASKSTATUS_AD_Reference_ID=366;
/**  0% Not Started = 0 */
public static final String TASKSTATUS_0NotStarted = "0";
/**  20% Started = 2 */
public static final String TASKSTATUS_20Started = "2";
/**  40% Busy = 4 */
public static final String TASKSTATUS_40Busy = "4";
/**  60% Good Progress = 6 */
public static final String TASKSTATUS_60GoodProgress = "6";
/**  80% Nearly Done = 8 */
public static final String TASKSTATUS_80NearlyDone = "8";
/**  90% Finishing = 9 */
public static final String TASKSTATUS_90Finishing = "9";
/**  95% Almost Done = A */
public static final String TASKSTATUS_95AlmostDone = "A";
/**  99% Cleaning up = C */
public static final String TASKSTATUS_99CleaningUp = "C";
/** 100% Complete = D */
public static final String TASKSTATUS_100Complete = "D";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isTaskStatusValid (String test)
{
return test == null || test.equals("0") || test.equals("2") || test.equals("4") || test.equals("6") || test.equals("8") || test.equals("9") || test.equals("A") || test.equals("C") || test.equals("D");
}
/** Set Task Status.
@param TaskStatus Status of the Task */
public void setTaskStatus (String TaskStatus)
{
if (!isTaskStatusValid(TaskStatus))
throw new IllegalArgumentException ("TaskStatus Invalid value - " + TaskStatus + " - Reference_ID=366 - 0 - 2 - 4 - 6 - 8 - 9 - A - C - D");
if (TaskStatus != null && TaskStatus.length() > 1)
{
log.warning("Length > 1 - truncated");
TaskStatus = TaskStatus.substring(0,1);
}
set_Value ("TaskStatus", TaskStatus);
}
/** Get Task Status.
@return Status of the Task */
public String getTaskStatus() 
{
return (String)get_Value("TaskStatus");
}
}
