/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.impexp;

import java.sql.*;
import java.util.*;
import java.util.logging.*;
import org.compiere.model.*;
import org.compiere.util.*;


/**
 *	Import Format Model 
 *	
 *  @author Jorg Janke
 *  @version $Id: MImpFormat.java,v 1.2 2008/02/14 13:01:56 jrmt Exp $
 */
public class MImpFormat extends X_AD_ImpFormat
{

	/**
	 * 	Standard Constructor
	 *	@param ctx context
	 *	@param AD_ImpFormat_ID id
	 *  @param trxName transaction
	 */
	public MImpFormat (Ctx ctx, int AD_ImpFormat_ID, String trxName)
	{
		super (ctx, AD_ImpFormat_ID, trxName);
	}	//	MImpFormat

	/**
	 * 	Load Constructor
	 *	@param ctx context
	 *	@param rs result set
	 *  @param trxName transaction
	 */
	public MImpFormat (Ctx ctx, ResultSet rs, String trxName)
	{
		super(ctx, rs, trxName);
	}	//	MImpFormat
	
	/**
	 * 	Get (all) Rows
	 *	@return array of Rows
	 */
	public MImpFormatRow[] getRows()
	{
		ArrayList<MImpFormatRow> list = new ArrayList<MImpFormatRow>();
		String sql = "SELECT * FROM AD_ImpFormat_Row "
			+ "WHERE AD_ImpFormat_ID=? "
			+ "ORDER BY SeqNo";
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (sql, get_TrxName());
			pstmt.setInt (1, getAD_ImpFormat_ID());
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
				list.add(new MImpFormatRow (getCtx(), rs, get_TrxName()));
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			log.log(Level.SEVERE, "getRows", e);
		}
		try
		{
			if (pstmt != null)
				pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			pstmt = null;
		}
		MImpFormatRow[] retValue = new MImpFormatRow[list.size ()];
		list.toArray (retValue);
		return retValue;
	}	//	getRows
	
	
	// Jirimuto added for Japanese Env 2008/01/22
	/**
	 * 	Get (all) Rows
	 *	@return array of Rows
	 */
	public static int getAD_ImportFormat_ID(String formatName)
	{
		int AD_ImportFormat_ID = 0;
		String sql = "SELECT AD_ImpFormat_ID FROM AD_ImpFormat "
			+ "WHERE name=? ";
		PreparedStatement pstmt = null;
		try
		{
			pstmt = DB.prepareStatement (sql, null);
			pstmt.setString( 1, formatName);
			ResultSet rs = pstmt.executeQuery ();
			while (rs.next ())
				AD_ImportFormat_ID = rs.getInt( 1 );
			rs.close ();
			pstmt.close ();
			pstmt = null;
		}
		catch (Exception e)
		{
			try
			{
				if (pstmt != null)
					pstmt.close ();
				pstmt = null;
			}
			catch (Exception ee)
			{
				pstmt = null;
			}
		}
		
		return AD_ImportFormat_ID;
	}	//	getRows
		
}	//	MImpFormat
