/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import org.compiere.util.*;

import java.io.*;

/**
 * 	Authorize.net Payment Processor Services Interface
 *	
 *  @author Jorg Janke
 *  @version $Id: PP_Authorize.java,v 1.1 2008/01/16 07:40:54 jrmt Exp $
 */
public class PP_Authorize extends PaymentProcessor
	implements Serializable
{
	/**	Status					*/
	private boolean		m_ok = false;

	/**
	 * 	Process CC
	 *	@return processed ok
	 *	@throws IllegalArgumentException
	 */
	public boolean processCC ()
		throws IllegalArgumentException
	{
		setEncoded(true);
		return m_ok;
	}	//	processCC

	/**
	 * 	Is Processed OK
	 *	@return true if OK
	 */
	public boolean isProcessedOK ()
	{
		return m_ok;
	}	//	isProcessedOK
	
}	//	PP_Authorize
