/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.services.ConfigObjectCreateRule;
import org.apache.commons.services.Module;
import org.apache.commons.services.Queue;

public class QueueModule
extends Module {
    protected Map queues = null;
    protected Queue defaultQueue = null;

    protected void initDefaultQueue() {
        this.defaultQueue = new Queue();
        this.defaultQueue.setParentModule(this);
    }

    protected void initQueues() {
        this.queues = new HashMap();
    }

    public QueueModule() {
        this.initQueues();
        this.initDefaultQueue();
    }

    public void init() {
        super.init();
        this.queues.clear();
        this.defaultQueue.init();
    }

    public void destroy() {
        super.destroy();
        Iterator iterator = this.queues.values().iterator();
        Queue queue = null;
        while (iterator.hasNext()) {
            queue = (Queue)iterator.next();
            queue.destroy();
        }
        this.queues.clear();
        this.queues = null;
        this.defaultQueue.destroy();
        this.defaultQueue = null;
    }

    public void addQueue(Queue queue) {
        this.queues.put(queue.getName(), queue);
        queue.setParentModule(this);
    }

    public void removeQueue(String name) {
        this.queues.remove(name);
    }

    public Queue getQueue(String name) {
        Queue queue = (Queue)this.queues.get(name);
        if (queue == null) {
            if (this.strongCheck) {
                return null;
            }
            return this.getDefaultQueue();
        }
        return queue;
    }

    public Queue getDefaultQueue() {
        return this.defaultQueue;
    }

    public Digester initDigester(Digester digester, String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Module can not be used alone. The path argument is mandatory.");
        }
        String queuePath = path + "/queue";
        digester.addRule(queuePath, (Rule)new ConfigObjectCreateRule(digester, "org.apache.commons.services.SequenceQueue", "type", queuePath));
        digester.addSetNext(queuePath, "addQueue", "org.apache.commons.services.Queue");
        digester.addSetProperties(queuePath);
        digester.addSetProperty(queuePath + "/set-property", "property", "value");
        return digester;
    }
}

