/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
implements HttpServletResponse {
    private HttpServletResponse resp;
    private NoBodyOutputStream noBody;
    private PrintWriter writer;
    private boolean didSetContentLength;

    public int getBufferSize() {
        return this.resp.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.resp.flushBuffer();
    }

    public void reset() throws IllegalStateException {
        this.resp.reset();
    }

    public void resetBuffer() throws IllegalStateException {
        this.resp.resetBuffer();
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            this.resp.setContentLength(this.noBody.getContentLength());
        }
    }

    public boolean isCommitted() {
        return this.resp.isCommitted();
    }

    public void sendError(int sc) throws IOException {
        this.resp.sendError(sc);
    }

    public void setBufferSize(int size) throws IllegalStateException {
        this.resp.setBufferSize(size);
    }

    public void setContentLength(int len) {
        this.resp.setContentLength(len);
        this.didSetContentLength = true;
    }

    public void setStatus(int sc) {
        this.resp.setStatus(sc);
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }

    public String getCharacterEncoding() {
        return this.resp.getCharacterEncoding();
    }

    public String getContentType() {
        return this.resp.getContentType();
    }

    public void sendError(int sc, String msg) throws IOException {
        this.resp.sendError(sc, msg);
    }

    public void setStatus(int sc, String sm) {
        this.resp.setStatus(sc, sm);
    }

    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    public void setCharacterEncoding(String charset) {
        this.resp.setCharacterEncoding(charset);
    }

    public void setContentType(String type) {
        this.resp.setContentType(type);
    }

    public boolean containsHeader(String name) {
        return this.resp.containsHeader(name);
    }

    public void addIntHeader(String name, int value) {
        this.resp.addIntHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.resp.setIntHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        this.resp.addDateHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.resp.setDateHeader(name, date);
    }

    public Locale getLocale() {
        return this.resp.getLocale();
    }

    public void setLocale(Locale loc) {
        this.resp.setLocale(loc);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    public void addCookie(Cookie cookie) {
        this.resp.addCookie(cookie);
    }

    NoBodyResponse(HttpServletResponse r) {
        this.resp = r;
        this.noBody = new NoBodyOutputStream();
    }

    public String encodeRedirectURL(String url) {
        return this.resp.encodeRedirectURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return this.resp.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }
}

