/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

class SecurityAssociationActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityAssociationActions() {
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void setServer() {
        AccessController.doPrivileged(SetServerAction.ACTION);
    }

    static void clear() {
        AccessController.doPrivileged(ClearAction.ACTION);
    }

    static Subject getSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static Principal getPrincipal() {
        Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static Object getCredential() {
        Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        PushRunAsRoleAction action = new PushRunAsRoleAction(principal);
        AccessController.doPrivileged(action);
    }

    static RunAsIdentity popRunAsIdentity() {
        RunAsIdentity principal = (RunAsIdentity)AccessController.doPrivileged(PopRunAsRoleAction.ACTION);
        return principal;
    }

    static Throwable getAuthException() {
        Throwable ex = (Throwable)AccessController.doPrivileged(GetAuthExceptionAction.ACTION);
        return ex;
    }

    private static class GetAuthExceptionAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetAuthExceptionAction();

        private GetAuthExceptionAction() {
        }

        public Object run() {
            Object exception = SecurityAssociation.getContextInfo((Object)SecurityAssociationActions.AUTH_EXCEPTION_KEY);
            return exception;
        }
    }

    private static class PopRunAsRoleAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new PopRunAsRoleAction();

        private PopRunAsRoleAction() {
        }

        public Object run() {
            RunAsIdentity principal = SecurityAssociation.popRunAsIdentity();
            return principal;
        }
    }

    private static class PushRunAsRoleAction
    implements PrivilegedAction {
        RunAsIdentity principal;

        PushRunAsRoleAction(RunAsIdentity principal) {
            this.principal = principal;
        }

        public Object run() {
            SecurityAssociation.pushRunAsIdentity((RunAsIdentity)this.principal);
            return null;
        }
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            Object credential = SecurityAssociation.getCredential();
            return credential;
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            Principal principal = SecurityAssociation.getPrincipal();
            return principal;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }

    private static class ClearAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new ClearAction();

        private ClearAction() {
        }

        public Object run() {
            SecurityAssociation.clear();
            return null;
        }
    }

    private static class SetServerAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new SetServerAction();

        private SetServerAction() {
        }

        public Object run() {
            SecurityAssociation.setServer();
            return null;
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityAssociation.pushSubjectContext((Subject)this.subject, (Principal)this.principal, (Object)this.credential);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

