/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.util.NestedRuntimeException;

public class TransactionLocalDelegateImpl
implements TransactionLocalDelegate {
    protected TransactionManager manager;
    protected static ConcurrentHashMap synchronizationsByTransaction = new ConcurrentHashMap();

    protected static TransactionLocalSynchronization getSynchronization(Transaction tx, boolean create) {
        TransactionLocalSynchronization result = (TransactionLocalSynchronization)synchronizationsByTransaction.get((Object)tx);
        if (result == null && create) {
            result = new TransactionLocalSynchronization(tx);
            try {
                tx.registerSynchronization(result);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Transaction already rolled back or marked for rollback");
            }
            catch (SystemException e) {
                throw new NestedRuntimeException(e);
            }
            synchronizationsByTransaction.put((Object)tx, (Object)result);
        }
        return result;
    }

    protected static void removeSynchronization(Transaction tx) {
        synchronizationsByTransaction.remove((Object)tx);
    }

    public TransactionLocalDelegateImpl(TransactionManager manager) {
        this.manager = manager;
    }

    public Object getValue(TransactionLocal unused, Transaction tx) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, false);
        if (sync == null) {
            return null;
        }
        return sync.getValue(this);
    }

    public void storeValue(TransactionLocal unused, Transaction tx, Object value) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, true);
        sync.setValue(this, value);
    }

    public boolean containsValue(TransactionLocal unused, Transaction tx) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, false);
        if (sync == null) {
            return false;
        }
        return sync.containsValue(this);
    }

    protected static class TransactionLocalSynchronization
    implements Synchronization {
        protected Transaction tx;
        protected HashMap valuesByLocal = new HashMap();

        public TransactionLocalSynchronization(Transaction tx) {
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TransactionLocalDelegateImpl.removeSynchronization(this.tx);
            this.valuesByLocal.clear();
        }

        public Object getValue(Object local) {
            return this.valuesByLocal.get(local);
        }

        public void setValue(Object local, Object value) {
            this.valuesByLocal.put(local, value);
        }

        public boolean containsValue(Object local) {
            return this.valuesByLocal.containsKey(local);
        }
    }
}

