/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.expression.DynaBeanExpression;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.Updater;

public class BeanProperty {
    private String propertyName;
    private Class propertyType;
    private Expression propertyExpression;
    private Updater propertyUpdater;

    public BeanProperty(String propertyName, Class propertyType, Expression propertyExpression, Updater propertyUpdater) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.propertyExpression = propertyExpression;
        this.propertyUpdater = propertyUpdater;
    }

    public BeanProperty(PropertyDescriptor descriptor) {
        Method writeMethod;
        this.propertyName = descriptor.getName();
        this.propertyType = descriptor.getPropertyType();
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null) {
            this.propertyExpression = new MethodExpression(readMethod);
        }
        if ((writeMethod = descriptor.getWriteMethod()) != null) {
            this.propertyUpdater = new MethodUpdater(writeMethod);
        }
    }

    public BeanProperty(DynaProperty dynaProperty) {
        this.propertyName = dynaProperty.getName();
        this.propertyType = dynaProperty.getType();
        this.propertyExpression = new DynaBeanExpression(this.propertyName);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Expression getPropertyExpression() {
        return this.propertyExpression;
    }

    public Updater getPropertyUpdater() {
        return this.propertyUpdater;
    }
}

