/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.lf5.util.DateFormatManager;
import org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.LogTableRowRenderer;

public class LogTable
extends JTable {
    protected int _rowHeight = 30;
    protected JTextArea _detailTextArea;
    protected int _numCols = 9;
    protected TableColumn[] _tableColumns = new TableColumn[this._numCols];
    protected int[] _colWidths = new int[]{40, 40, 40, 70, 70, 360, 440, 200, 60};
    protected LogTableColumn[] _colNames = LogTableColumn.getLogTableColumnArray();
    protected int _colDate = 0;
    protected int _colThread = 1;
    protected int _colMessageNum = 2;
    protected int _colLevel = 3;
    protected int _colNDC = 4;
    protected int _colCategory = 5;
    protected int _colMessage = 6;
    protected int _colLocation = 7;
    protected int _colThrown = 8;
    protected DateFormatManager _dateFormatManager = null;

    public LogTable(JTextArea detailTextArea) {
        this.init();
        this._detailTextArea = detailTextArea;
        this.setModel(new FilteredLogTableModel());
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        int i2 = 0;
        while (columns.hasMoreElements()) {
            TableColumn col2 = columns.nextElement();
            col2.setCellRenderer(new LogTableRowRenderer());
            col2.setPreferredWidth(this._colWidths[i2]);
            this._tableColumns[i2] = col2;
            ++i2;
        }
        ListSelectionModel rowSM = this.getSelectionModel();
        rowSM.addListSelectionListener(new LogTableListSelectionListener(this));
    }

    public DateFormatManager getDateFormatManager() {
        return this._dateFormatManager;
    }

    public void setDateFormatManager(DateFormatManager dfm) {
        this._dateFormatManager = dfm;
    }

    public synchronized void clearLogRecords() {
        this.getFilteredLogTableModel().clear();
    }

    public FilteredLogTableModel getFilteredLogTableModel() {
        return (FilteredLogTableModel)this.getModel();
    }

    public void setDetailedView() {
        TableColumnModel model = this.getColumnModel();
        int f2 = 0;
        while (f2 < this._numCols) {
            model.removeColumn(this._tableColumns[f2]);
            ++f2;
        }
        int i2 = 0;
        while (i2 < this._numCols) {
            model.addColumn(this._tableColumns[i2]);
            ++i2;
        }
        this.sizeColumnsToFit(-1);
    }

    public void setView(List columns) {
        TableColumnModel model = this.getColumnModel();
        int f2 = 0;
        while (f2 < this._numCols) {
            model.removeColumn(this._tableColumns[f2]);
            ++f2;
        }
        Iterator selectedColumns = columns.iterator();
        Vector columnNameAndNumber = this.getColumnNameAndNumber();
        while (selectedColumns.hasNext()) {
            model.addColumn(this._tableColumns[columnNameAndNumber.indexOf(selectedColumns.next())]);
        }
        this.sizeColumnsToFit(-1);
    }

    public void setFont(Font font2) {
        super.setFont(font2);
        Graphics g2 = this.getGraphics();
        if (g2 != null) {
            FontMetrics fm = g2.getFontMetrics(font2);
            int height = fm.getHeight();
            this._rowHeight = height + height / 3;
            this.setRowHeight(this._rowHeight);
        }
    }

    protected void init() {
        this.setRowHeight(this._rowHeight);
        this.setSelectionMode(0);
    }

    protected Vector getColumnNameAndNumber() {
        Vector<LogTableColumn> columnNameAndNumber = new Vector<LogTableColumn>();
        int i2 = 0;
        while (i2 < this._colNames.length) {
            columnNameAndNumber.add(i2, this._colNames[i2]);
            ++i2;
        }
        return columnNameAndNumber;
    }

    class LogTableListSelectionListener
    implements ListSelectionListener {
        protected JTable _table;

        public LogTableListSelectionListener(JTable table2) {
            this._table = table2;
        }

        public void valueChanged(ListSelectionEvent e2) {
            if (e2.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e2.getSource();
            if (!lsm.isSelectionEmpty()) {
                StringBuffer buf = new StringBuffer();
                int selectedRow = lsm.getMinSelectionIndex();
                int i2 = 0;
                while (i2 < LogTable.this._numCols - 1) {
                    String value = "";
                    Object obj = this._table.getModel().getValueAt(selectedRow, i2);
                    if (obj != null) {
                        value = obj.toString();
                    }
                    buf.append(LogTable.this._colNames[i2] + ":");
                    buf.append("\t");
                    if (i2 == LogTable.this._colThread || i2 == LogTable.this._colMessage || i2 == LogTable.this._colLevel) {
                        buf.append("\t");
                    }
                    if (i2 == LogTable.this._colDate || i2 == LogTable.this._colNDC) {
                        buf.append("\t\t");
                    }
                    buf.append(value);
                    buf.append("\n");
                    ++i2;
                }
                buf.append(LogTable.this._colNames[LogTable.this._numCols - 1] + ":\n");
                Object obj = this._table.getModel().getValueAt(selectedRow, LogTable.this._numCols - 1);
                if (obj != null) {
                    buf.append(obj.toString());
                }
                LogTable.this._detailTextArea.setText(buf.toString());
            }
        }
    }
}

