/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.functions;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspTagException;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;

public class Functions {
    public static String toUpperCase(String input2) {
        return input2.toUpperCase();
    }

    public static String toLowerCase(String input2) {
        return input2.toLowerCase();
    }

    public static int indexOf(String input2, String substring) {
        if (input2 == null) {
            input2 = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input2.indexOf(substring);
    }

    public static boolean contains(String input2, String substring) {
        return Functions.indexOf(input2, substring) != -1;
    }

    public static boolean containsIgnoreCase(String input2, String substring) {
        String substringUC;
        String inputUC;
        if (input2 == null) {
            input2 = "";
        }
        if (substring == null) {
            substring = "";
        }
        return Functions.indexOf(inputUC = input2.toUpperCase(), substringUC = substring.toUpperCase()) != -1;
    }

    public static boolean startsWith(String input2, String substring) {
        if (input2 == null) {
            input2 = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input2.startsWith(substring);
    }

    public static boolean endsWith(String input2, String substring) {
        int index;
        if (input2 == null) {
            input2 = "";
        }
        if (substring == null) {
            substring = "";
        }
        if ((index = input2.indexOf(substring)) == -1) {
            return false;
        }
        if (index == 0 && substring.length() == 0) {
            return true;
        }
        return index == input2.length() - substring.length();
    }

    public static String substring(String input2, int beginIndex, int endIndex) {
        if (input2 == null) {
            input2 = "";
        }
        if (beginIndex >= input2.length()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > input2.length()) {
            endIndex = input2.length();
        }
        if (endIndex < beginIndex) {
            return "";
        }
        return input2.substring(beginIndex, endIndex);
    }

    public static String substringAfter(String input2, String substring) {
        if (input2 == null) {
            input2 = "";
        }
        if (input2.length() == 0) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.length() == 0) {
            return input2;
        }
        int index = input2.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input2.substring(index + substring.length());
    }

    public static String substringBefore(String input2, String substring) {
        if (input2 == null) {
            input2 = "";
        }
        if (input2.length() == 0) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.length() == 0) {
            return "";
        }
        int index = input2.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input2.substring(0, index);
    }

    public static String escapeXml(String input2) {
        if (input2 == null) {
            return "";
        }
        return Util.escapeXml(input2);
    }

    public static String trim(String input2) {
        if (input2 == null) {
            return "";
        }
        return input2.trim();
    }

    public static String replace(String input2, String substringBefore, String substringAfter) {
        int index;
        if (input2 == null) {
            input2 = "";
        }
        if (input2.length() == 0) {
            return "";
        }
        if (substringBefore == null) {
            substringBefore = "";
        }
        if (substringBefore.length() == 0) {
            return input2;
        }
        StringBuffer buf = new StringBuffer(input2.length());
        int startIndex = 0;
        while ((index = input2.indexOf(substringBefore, startIndex)) != -1) {
            buf.append(input2.substring(startIndex, index)).append(substringAfter);
            startIndex = index + substringBefore.length();
        }
        return buf.append(input2.substring(startIndex)).toString();
    }

    public static String[] split(String input2, String delimiters) {
        if (input2 == null) {
            input2 = "";
        }
        if (input2.length() == 0) {
            String[] array = new String[]{""};
            return array;
        }
        if (delimiters == null) {
            delimiters = "";
        }
        StringTokenizer tok = new StringTokenizer(input2, delimiters);
        int count = tok.countTokens();
        String[] array = new String[count];
        int i2 = 0;
        while (tok.hasMoreTokens()) {
            array[i2++] = tok.nextToken();
        }
        return array;
    }

    public static int length(Object obj) throws JspTagException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enum_ = (Enumeration)obj;
            count = 0;
            while (enum_.hasMoreElements()) {
                ++count;
                enum_.nextElement();
            }
            return count;
        }
        try {
            count = Array.getLength(obj);
            return count;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
        }
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < array.length; ++i2) {
            buf.append(array[i2]);
            if (i2 >= array.length - 1) continue;
            buf.append(separator);
        }
        return buf.toString();
    }
}

