/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.grid.ed;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class WLocatorDialog {
    private MLocatorLookup m_mLocator;
    private boolean m_mandatory = false;
    private int m_only_Warehouse_ID = 0;
    private int m_M_Warehouse_ID;
    private static CLogger log = CLogger.getCLogger(WLocatorDialog.class);
    private ArrayList<KeyNamePair> fWarehouse = new ArrayList();

    public WLocatorDialog(String title, MLocatorLookup mLocator, int M_Locator_ID, boolean mandatory, int only_Warehouse_ID, int windowNo, Ctx ctx) {
        try {
            this.jbInit(ctx);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WLocatorDialog", ex);
        }
        this.m_mLocator = mLocator;
        this.m_mandatory = mandatory;
        this.m_only_Warehouse_ID = only_Warehouse_ID;
        this.initLocator();
    }

    private void jbInit(Ctx ctx) throws Exception {
    }

    private void initLocator() {
        log.fine("");
        String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse";
        if (this.m_only_Warehouse_ID != 0) {
            sql = sql + " WHERE M_Warehouse_ID=" + this.m_only_Warehouse_ID;
        }
        String SQL = MRole.getDefault().addAccessSQL(sql, "M_Warehouse", false, false) + " ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.fWarehouse.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
        log.fine("Warehouses=" + this.fWarehouse.size());
        this.m_mLocator.fillComboBox(this.m_mandatory, true, true, false);
        log.fine(this.m_mLocator.toString());
    }

    protected void getWarehouseInfo(int M_Warehouse_ID) {
        if (M_Warehouse_ID == this.m_M_Warehouse_ID) {
            return;
        }
        this.m_M_Warehouse_ID = 0;
        String SQL = "SELECT M_Warehouse_ID, Value, Name, Separator, AD_Client_ID, AD_Org_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_M_Warehouse_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
    }
}

