/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPaymentExport
extends HttpServlet {
    private static final long serialVersionUID = 5749931628969912520L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrintWindow.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Payment Export Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int paymentSelectionId = WebUtil.getParameterAsInt(request, "paymentSelectionId");
        String paymentRule = WebUtil.getParameter(request, "paymentRule");
        int documentNumber = WebUtil.getParameterAsInt(request, "documentNumber");
        response.setContentType("text/plain;charset=" + this.getCharSet(request.getLocale().getLanguage()));
        response.setHeader("Content-Disposition", "attachment; filename=PaymentExport.txt");
        response.setHeader("Content-Description", "File download for TXT.");
        MPaySelectionCheck[] checks = MPaySelectionCheck.get(paymentSelectionId, paymentRule, documentNumber, null);
        char x = '\"';
        StringBuffer line = null;
        PrintWriter fw = response.getWriter();
        line = new StringBuffer();
        line.append(x).append(Msg.translate(wsc.ctx, "Value")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Name")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Contact")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Addr1")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Addr2")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "City")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "State")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "ZIP")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Country")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "ReferenceNo")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "DocumentNo")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "PayDate")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Currency")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "PayAmount")).append(x).append(",").append(x).append(Msg.translate(wsc.ctx, "Comment")).append(x).append(Env.NL);
        fw.write(line.toString());
        for (int i = 0; i < checks.length; ++i) {
            MPaySelectionCheck mpp = checks[i];
            if (mpp == null) continue;
            String[] bp = this.getBPartnerInfo(mpp.getC_BPartner_ID());
            StringBuffer comment = new StringBuffer();
            MPaySelectionLine[] psls = mpp.getPaySelectionLines(false);
            for (int l = 0; l < psls.length; ++l) {
                if (l > 0) {
                    comment.append(", ");
                }
                comment.append(psls[l].getInvoice().getDocumentNo());
            }
            line = new StringBuffer();
            line.append(x).append(bp[0]).append(x).append(",").append(x).append(bp[1]).append(x).append(",").append(x).append(bp[2]).append(x).append(",").append(x).append(bp[3]).append(x).append(",").append(x).append(bp[4]).append(x).append(",").append(x).append(bp[5]).append(x).append(",").append(x).append(bp[6]).append(x).append(",").append(x).append(bp[7]).append(x).append(",").append(x).append(bp[8]).append(x).append(",").append(x).append(bp[9]).append(x).append(",").append(x).append(mpp.getDocumentNo()).append(x).append(",").append(mpp.getParent().getPayDate()).append(",").append(x).append(MCurrency.getISO_Code(Env.getCtx(), mpp.getParent().getC_Currency_ID())).append(x).append(",").append(mpp.getPayAmt()).append(",").append(x).append(comment.toString()).append(x).append(Env.NL);
            fw.write(line.toString());
        }
        fw.flush();
    }

    private String[] getBPartnerInfo(int businessPartnerId) {
        String[] bp = new String[10];
        String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, businessPartnerId);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = "";
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = "";
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = "";
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = "";
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = "";
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = "";
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = "";
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = "";
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = "";
                }
                bp[9] = rs.getString(10);
                if (bp[9] == null) {
                    bp[9] = "";
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "getBPartnerInfo", e);
        }
        return bp;
    }

    private String getCharSet(String local) {
        String charset = "UTF8";
        charset = local.equals("ar") ? "ISO-8859-6" : (local.equals("be") ? "ISO-8859-5" : (local.equals("bg") ? "ISO-8859-5" : (local.equals("ca") ? "ISO-8859-1" : (local.equals("cs") ? "ISO-8859-2" : (local.equals("da") ? "ISO-8859-1" : (local.equals("de") ? "ISO-8859-1" : (local.equals("el") ? "ISO-8859-7" : (local.equals("en") ? "ISO-8859-1" : (local.equals("es") ? "ISO-8859-1" : (local.equals("et") ? "ISO-8859-1" : (local.equals("fi") ? "ISO-8859-1" : (local.equals("fr") ? "ISO-8859-1" : (local.equals("hr") ? "ISO-8859-2" : (local.equals("hu") ? "ISO-8859-2" : (local.equals("is") ? "ISO-8859-1" : (local.equals("it") ? "ISO-8859-1" : (local.equals("iw") ? "ISO-8859-8" : (local.equals("ja") ? "Shift_JIS" : (local.equals("ko") ? "EUC-KR" : (local.equals("lt") ? "ISO-8859-2" : (local.equals("lv") ? "ISO-8859-2" : (local.equals("mk") ? "ISO-8859-5" : (local.equals("nl") ? "ISO-8859-1" : (local.equals("no") ? "ISO-8859-1" : (local.equals("pl") ? "ISO-8859-2" : (local.equals("pt") ? "ISO-8859-1" : (local.equals("ro") ? "ISO-8859-2" : (local.equals("ru") ? "ISO-8859-5" : (local.equals("sh") ? "ISO-8859-5" : (local.equals("sk") ? "ISO-8859-2" : (local.equals("sl") ? "ISO-8859-2" : (local.equals("sq") ? "ISO-8859-2" : (local.equals("sr") ? "ISO-8859-5" : (local.equals("sv") ? "ISO-8859-1" : (local.equals("tr") ? "ISO-8859-9" : (local.equals("uk") ? "ISO-8859-5" : (local.equals("zh") ? "GB2312" : (local.equals("zh_TW") ? "Big5" : "UTF8"))))))))))))))))))))))))))))))))))))));
        return charset;
    }
}

