/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.PaymentPrintForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class PaymentPrint
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String PAYMENT_LIST = "paymentlist";
    private static final String ACTION_FORM = "PaymentPrintForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 106;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        wsc.ctx.setContext(0, "IsSOTrx", "Y");
        MForm form2 = this.getForm(wsc.ctx, 106);
        wsc.ctx.setContext("FormName", form2.getName());
        PaymentPrintForm myForm = (PaymentPrintForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (PaymentPrintForm)actionForm) == null) {
            myForm = new PaymentPrintForm();
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        this.loadPaymentList(wsc, myForm);
        this.loadBankAccount(wsc, myForm);
        this.loadPaymentRule(wsc, myForm);
        this.loadPaymentRuleInfo(wsc, myForm);
        myForm.setExportLabel(Msg.translate(wsc.ctx, "Export"));
        myForm.setPrintLabel(Msg.translate(wsc.ctx, "Print"));
        myForm.setProcessLabel(Msg.translate(wsc.ctx, "Process"));
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return mapping.findForward(PAYMENT_LIST);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private void loadPaymentList(WebSessionCtx wsc, PaymentPrintForm form2) {
        form2.setPaymentSelectionLabel(Msg.translate(wsc.ctx, "C_PaySelection_ID"));
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.log.config("");
        int clientId = wsc.ctx.getAD_Client_ID();
        String sql = "SELECT C_PaySelection_ID, Name || ' - ' || TotalAmt FROM C_PaySelection WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'ORDER BY PayDate DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, clientId);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                data = new HashMap();
                data.put("key", rs.getInt(1));
                data.put("value", rs.getString(2));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        form2.setPaymentSelectionList(dataList);
        if (dataList.size() == 0) {
            form2.setResultInfo("alert('" + Msg.getMsg(wsc.ctx, "VPayPrintNoRecords") + "');");
        } else if (form2.getPaymentSelectionId() == 0) {
            form2.setPaymentSelectionId(Integer.valueOf(((HashMap)dataList.get(0)).get("key").toString()));
        }
    }

    private void loadBankAccount(WebSessionCtx wsc, PaymentPrintForm form2) {
        this.log.info("VPayPrint.loadPaySelectInfo");
        form2.setBankAccountLabel(Msg.translate(wsc.ctx, "C_BankAccount_ID"));
        form2.setCurrentBalanceLabel(Msg.translate(wsc.ctx, "CurrentBalance"));
        form2.setCurrentCurrencyLabel(Msg.translate(wsc.ctx, "C_Currency_ID"));
        String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.C_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, form2.getPaymentSelectionId());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setBankAccountId(rs.getInt(1));
                form2.setBankAccountName(rs.getString(2));
                form2.setCurrentCurrency(rs.getString(3));
                form2.setCurrentBalance(wsc.amountFormat.format(rs.getBigDecimal(4)));
            } else {
                form2.setBankAccountId(-1);
                form2.setBankAccountName("");
                form2.setCurrentCurrency("");
                form2.setCurrentBalance(wsc.amountFormat.format(Env.ZERO));
                this.log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + form2.getPaymentSelectionId());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    private void loadPaymentRule(WebSessionCtx wsc, PaymentPrintForm form2) {
        this.log.info("");
        form2.setPaymentRuleLabel(Msg.translate(wsc.ctx, "PaymentRule"));
        ArrayList dataList = new ArrayList();
        HashMap<String, String> data = new HashMap<String, String>();
        if (form2.getBankAccountId() == -1) {
            return;
        }
        Language language = Language.getLanguage(Env.getAD_Language(wsc.ctx));
        MLookupInfo info = MLookupFactory.getLookup_List(language, 195);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, form2.getPaymentSelectionId());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                data = new HashMap();
                data.put("key", rs.getString(2));
                data.put("value", rs.getString(3));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        form2.setPaymentRuleList(dataList);
        if (dataList.size() == 0) {
            this.log.config("PaySel=" + form2.getPaymentSelectionId() + ", BAcct=" + form2.getBankAccountId() + " - " + sql);
        } else if (form2.getPaymentRule() == null || form2.getPaymentRule() == "") {
            form2.setPaymentRule(((HashMap)dataList.get(0)).get("key").toString());
        }
    }

    private void loadPaymentRuleInfo(WebSessionCtx wsc, PaymentPrintForm form2) {
        ResultSet rs;
        CPreparedStatement pstmt;
        form2.setDocumentNumberLabel(Msg.translate(wsc.ctx, "DocumentNo"));
        form2.setPaymentNumberLabel(Msg.translate(wsc.ctx, "NoOfPayments"));
        if (form2.getPaymentRule() == null || form2.getPaymentRule() == "") {
            return;
        }
        this.log.info("PaymentRule=" + form2.getPaymentRule());
        form2.setPaymentNumber(0);
        String sql = "SELECT COUNT(*) FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, form2.getPaymentSelectionId());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setPaymentNumber(rs.getInt(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        sql = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, form2.getBankAccountId());
            pstmt.setString(2, form2.getPaymentRule());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                form2.setDocumentNumber(rs.getInt(1));
            } else {
                this.log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + form2.getBankAccountId() + " AND PaymentRule=" + form2.getPaymentRule());
                form2.setResultInfo("alert('" + Msg.translate(wsc.ctx, "VPayPrintNoDoc") + "');");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }
}

