/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import com.jware.apps.scheduler.jobs.DumbDelayJob;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class LoadTest {
    public static void loadTest(SchedulerFactory sf) throws Exception {
        int count;
        int j;
        String[] names;
        int i2;
        Log lg = LogFactory.getLog(LoadTest.class);
        lg.info((Object)"------- Initializing -------------------");
        Scheduler sched = sf.getScheduler();
        lg.warn((Object)"      *** Deleting existing jobs/triggers ***");
        String[] groups = sched.getTriggerGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getTriggerNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.unscheduleJob(names[j], groups[i2]);
            }
        }
        groups = sched.getJobGroupNames();
        for (i2 = 0; i2 < groups.length; ++i2) {
            names = sched.getJobNames(groups[i2]);
            for (j = 0; j < names.length; ++j) {
                sched.deleteJob(names[j], groups[i2]);
            }
        }
        lg.info((Object)"------- Initialization Complete -----------");
        lg.info((Object)"------- Scheduling a Big Pile of Jobs -----------");
        String schedId = sched.getSchedulerInstanceId();
        for (count = 1; count <= 500; ++count) {
            JobDetail job = new JobDetail("job_" + count, "grp_1", DumbDelayJob.class);
            job.getJobDataMap().put("delay", 60000L);
            job.setRequestsRecovery(true);
            SimpleTrigger trigger = new SimpleTrigger("trig_" + count, "grp_1");
            trigger.setStartTime(new Date(System.currentTimeMillis() + 10000L + (long)(count * 100)));
            sched.scheduleJob(job, (Trigger)trigger);
            if (count % 25 != 0) continue;
            lg.info((Object)("...scheduled " + count + " jobs..."));
        }
        lg.info((Object)("Finished scheduling " + count + " jobs."));
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler -----------------");
        lg.info((Object)"------- Waiting... -----------------------");
        try {
            Thread.sleep(600000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown();
        lg.info((Object)"------- Shutdown Complete -----------------");
    }

    public static void main(String[] args) throws Exception {
        try {
            boolean clearJobs = false;
            boolean scheduleJobs = true;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("clearJobs")) {
                    clearJobs = true;
                }
                if (!args[i2].equals("dontScheduleJobs")) continue;
                scheduleJobs = false;
            }
            LoadTest.loadTest((SchedulerFactory)new StdSchedulerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

