/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.schedule;

import com.jware.apps.scheduler.util.JobSchedulerUtils;
import com.jware.apps.scheduler.web.struts.schedule.JobTriggerForm;
import com.jware.base.error.JwareApplicationException;
import com.jware.base.web.struts.jWareBaseAction;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public final class JobCronTriggerEditAction
extends jWareBaseAction {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public ActionForward doExecute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JobTriggerForm info = (JobTriggerForm)form2;
        MessageResources messages = this.getResources(request);
        if (this.isCancelled(request)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)(" " + mapping.getAttribute() + " - HtmlexpDefineEditAction transaction was cancelled"));
            }
            this.removeFormBean(mapping, request);
            return mapping.findForward("success");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JobEditAction:  Processing actions");
        }
        String startTime = info.getStartTime();
        String stopTime = info.getStopTime();
        boolean startTimeHasValue = startTime != null && startTime.length() > 0;
        boolean stopTimeHasValue = stopTime != null && stopTime.length() > 0;
        CronTrigger trigger = null;
        if (info.getCronExpression().length() > 2) {
            trigger = new CronTrigger(info.getTriggerName(), info.getTriggerGroup(), info.getJobName(), info.getJobGroup(), info.getCronExpression());
        }
        trigger.setDescription(info.getDescription());
        if (startTimeHasValue) {
            trigger.setStartTime(info.getStartTimeAsDate());
        }
        if (stopTimeHasValue) {
            trigger.setEndTime(info.getStopTimeAsDate());
        }
        trigger.setVolatility(false);
        try {
            Scheduler scheduler = JobSchedulerUtils.getCurrentScheduler(session);
            scheduler.scheduleJob((Trigger)trigger);
        }
        catch (SchedulerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"JobCronTriggerEditAction:  Scheduler Error occurs.");
            }
            throw new JwareApplicationException("E600001", e);
        }
        return mapping.findForward("success");
    }

    protected void removeFormBean(ActionMapping mapping, HttpServletRequest request) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.removeAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                session.removeAttribute(mapping.getAttribute());
            }
        }
    }
}

