/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String FORMAT_FOR_YEAR = "yyyy";
    private static final String FORMAT_FOR_MONTH = "MM";
    private static final String FORMAT_FOR_DAY = "dd";
    private static final SimpleDateFormat mochaDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat mochaDateFormatWithTimeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static Calendar cal = Calendar.getInstance();

    private DateUtils() {
    }

    public static boolean isDate(String format, String argStr) {
        if (argStr == null || argStr.length() <= 0) {
            return false;
        }
        return DateUtils.isDate(format, argStr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDate(String format, String argStr, boolean nullable) {
        if ((argStr == null || argStr.length() <= 0) && nullable) {
            return true;
        }
        int pForYear = format.indexOf(FORMAT_FOR_YEAR);
        int pForMonth = format.indexOf(FORMAT_FOR_MONTH);
        int pForDay = format.indexOf(FORMAT_FOR_DAY);
        int pForYearMonthDeli = FORMAT_FOR_YEAR.length();
        int pForMonthDayDeli = pForMonth + FORMAT_FOR_MONTH.length();
        if (pForYear == -1 || pForMonth == -1 || pForDay == -1) {
            return false;
        }
        if (!format.substring(pForYearMonthDeli, pForMonth).equals(argStr.substring(pForYearMonthDeli, pForMonth))) {
            return false;
        }
        if (!format.substring(pForMonthDayDeli, pForDay).equals(argStr.substring(pForMonthDayDeli, pForDay))) {
            return false;
        }
        String dateStr = null;
        dateStr = argStr.substring(pForYear, FORMAT_FOR_YEAR.length()) + argStr.substring(pForMonth, pForMonth + FORMAT_FOR_MONTH.length()) + argStr.substring(pForDay, pForDay + FORMAT_FOR_DAY.length());
        try {
            int year = Integer.parseInt(dateStr.substring(0, 4));
            int month = Integer.parseInt(dateStr.substring(4, 6));
            if (month < 1 || month > 12) {
                return false;
            }
            int maxDay = 0;
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.set(year, month - 1, 1);
                maxDay = cal.getActualMaximum(5);
            }
            int day = Integer.parseInt(dateStr.substring(6));
            if (1 <= day && day <= maxDay) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return false;
    }

    public static boolean isDate(String date) {
        if (date == null) {
            return false;
        }
        if (date.length() != 10) {
            return false;
        }
        return DateUtils.isDate(DATE_FORMAT, date);
    }

    public static boolean isDate(String date, boolean nullable) {
        if (date == null || date.length() == 0) {
            return nullable;
        }
        if (date.length() != 10) {
            return false;
        }
        return DateUtils.isDate(DATE_FORMAT, date);
    }

    public static boolean isDateBeforeAfter(String date1, String date2) {
        Date checkDate2;
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return false;
        }
        if (date1.length() != 10) {
            return false;
        }
        if (!DateUtils.isDate(DATE_FORMAT, date1)) {
            return false;
        }
        if (date2.length() != 10) {
            return false;
        }
        if (!DateUtils.isDate(DATE_FORMAT, date2)) {
            return false;
        }
        if (date1.equals(date2)) {
            return true;
        }
        Date checkDate1 = DateUtils.convertToDate(date1);
        return checkDate1.before(checkDate2 = DateUtils.convertToDate(date2));
    }

    public static boolean isDateBeforeAfterNull(String date1, String date2) {
        Date checkDate2;
        if (date1 == null || date1.length() == 0 || date2 == null || date2.length() == 0) {
            return true;
        }
        if (date1.equals(date2)) {
            return true;
        }
        Date checkDate1 = DateUtils.convertToDate(date1);
        return checkDate1.before(checkDate2 = DateUtils.convertToDate(date2));
    }

    public static int getYYYY(String date1) {
        if (date1 == null) {
            return -1;
        }
        int pForYear = DATE_FORMAT.indexOf(FORMAT_FOR_YEAR);
        int pForMonth = DATE_FORMAT.indexOf(FORMAT_FOR_MONTH);
        int pForDay = DATE_FORMAT.indexOf(FORMAT_FOR_DAY);
        return new Integer(date1.substring(pForYear, pForYear + FORMAT_FOR_YEAR.length()));
    }

    public static int getMM(String date1) {
        if (date1 == null) {
            return -1;
        }
        int pForYear = DATE_FORMAT.indexOf(FORMAT_FOR_YEAR);
        int pForMonth = DATE_FORMAT.indexOf(FORMAT_FOR_MONTH);
        int pForDay = DATE_FORMAT.indexOf(FORMAT_FOR_DAY);
        return new Integer(date1.substring(pForMonth, pForMonth + FORMAT_FOR_MONTH.length()));
    }

    public static int getDD(String date1) {
        if (date1 == null) {
            return -1;
        }
        int pForYear = DATE_FORMAT.indexOf(FORMAT_FOR_YEAR);
        int pForMonth = DATE_FORMAT.indexOf(FORMAT_FOR_MONTH);
        int pForDay = DATE_FORMAT.indexOf(FORMAT_FOR_DAY);
        return new Integer(date1.substring(pForDay, pForDay + FORMAT_FOR_DAY.length()));
    }

    public static String getDateFormat(Date date) {
        if (date == null) {
            return null;
        }
        return mochaDateFormat.format(date);
    }

    public static String getDateFormatWithTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        return mochaDateFormatWithTimeStamp.format(date);
    }

    public static String getDateFormat(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String getTimeFormat(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String getHours(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH");
        return dateFormat.format(date);
    }

    public static String getMinutes(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("mm");
        return dateFormat.format(date);
    }

    public static String getSeconds(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("ss");
        return dateFormat.format(date);
    }

    public static String getYYYYMM() {
        String dateTmp = mochaDateFormat.format(new Date());
        String dateYM = dateTmp.substring(0, 4) + dateTmp.substring(5, 7);
        return dateYM;
    }

    public static String getPreviousYYYYMM() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        DecimalFormat fmt = new DecimalFormat("00");
        String mm = fmt.format(cal.get(2) + 1);
        String yy = new Integer(cal.get(1)).toString();
        return yy + mm;
    }

    public static Date getPreviousDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        DecimalFormat fmt = new DecimalFormat("00");
        String mm = fmt.format(cal.get(2) + 1);
        String yy = new Integer(cal.get(1)).toString();
        String dd = fmt.format(cal.get(5));
        return DateUtils.convertToDate(yy + "-" + mm + "-" + dd);
    }

    public static String getYYYYMMDD() {
        return DateUtils.getYYYYMMDD(new Date());
    }

    public static String getYYYYMMDD(Date trialtime) {
        if (trialtime == null) {
            return null;
        }
        String[] arr = DateUtils.getYYYYMMDDArray(trialtime);
        return arr[0] + arr[1] + arr[2];
    }

    public static String[] getYYYYMMDDArray() {
        return DateUtils.getYYYYMMDDArray(new Date());
    }

    public static String[] getYYYYMMDDArray(Date trialtime) {
        if (trialtime == null) {
            return null;
        }
        String[] yyyymmddhhmiss = DateUtils.getYYYYMMDDHHMISSArray(trialtime);
        String[] arr = new String[]{yyyymmddhhmiss[0], yyyymmddhhmiss[1], yyyymmddhhmiss[2]};
        return arr;
    }

    public static String[] getHHMISSArray(Date trialtime) {
        if (trialtime == null) {
            return null;
        }
        String[] yyyymmddhhmiss = DateUtils.getYYYYMMDDHHMISSArray(trialtime);
        String[] arr = new String[]{yyyymmddhhmiss[3], yyyymmddhhmiss[4], yyyymmddhhmiss[5]};
        return arr;
    }

    public static String[] getYYYYMMDDHHMISSArray() {
        return DateUtils.getYYYYMMDDHHMISSArray(new Date());
    }

    public static String[] getYYYYMMDDHHMISSArray(Date trialtime) {
        if (trialtime == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(trialtime);
        int YYYY = calendar.get(1);
        int MM = calendar.get(2) + 1;
        int DD = calendar.get(5);
        int HH = calendar.get(11);
        int MI = calendar.get(12);
        int SS = calendar.get(13);
        int SSS = calendar.get(14);
        String yyyy = Integer.toString(YYYY);
        String mm = MM < 10 ? "0" + Integer.toString(MM) : Integer.toString(MM);
        String dd = DD < 10 ? "0" + Integer.toString(DD) : Integer.toString(DD);
        String hh = HH < 10 ? "0" + Integer.toString(HH) : Integer.toString(HH);
        String mi = MI < 10 ? "0" + Integer.toString(MI) : Integer.toString(MI);
        String ss = SS < 10 ? "0" + Integer.toString(SS) : Integer.toString(SS);
        String sss = SSS < 10 ? "00" + Integer.toString(SSS) : (SSS < 100 ? "0" + Integer.toString(SSS) : Integer.toString(SSS));
        String[] arr = new String[]{yyyy, mm, dd, hh, mi, ss, sss};
        return arr;
    }

    public static String getTimeStamp() {
        String timeStamp = DateUtils.getTimeStamp(new Date());
        return timeStamp;
    }

    public static String getTimeStamp(Date trialtime) {
        if (trialtime == null) {
            return null;
        }
        String[] arr = DateUtils.getYYYYMMDDHHMISSArray();
        String timeStamp = arr[0] + "-" + arr[1] + "-" + arr[2] + " " + arr[3] + ":" + arr[4] + ":" + arr[5];
        return timeStamp;
    }

    public static Date currentDate() {
        return Calendar.getInstance().getTime();
    }

    public static Date stringToDate(String yyyymmdd, String hhmmss) {
        String[] arr;
        int index;
        String year = null;
        String month = null;
        String date = null;
        String hour = null;
        String minute = null;
        String second = null;
        if (yyyymmdd != null) {
            if (yyyymmdd.length() == 8) {
                year = yyyymmdd.substring(0, 4);
                month = yyyymmdd.substring(4, 6);
                date = yyyymmdd.substring(6, 8);
            } else {
                index = -1;
                index = yyyymmdd.indexOf("-");
                if (index != -1) {
                    arr = yyyymmdd.split("-");
                    if (arr.length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                } else {
                    index = yyyymmdd.indexOf("/");
                    if (index != -1 && (arr = yyyymmdd.split("/")).length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                }
            }
        }
        if (hhmmss != null) {
            if (hhmmss.length() == 6) {
                hour = hhmmss.substring(0, 2);
                minute = hhmmss.substring(2, 2);
                second = hhmmss.substring(4, 2);
            } else {
                index = -1;
                index = hhmmss.indexOf(":");
                if (index != -1 && (arr = yyyymmdd.split(":")).length == 3) {
                    hour = arr[0].substring(0, 2);
                    minute = arr[1].substring(0, 2);
                    second = arr[2].substring(0, 2);
                }
            }
        }
        return DateUtils.stringToDate(year, month, date, hour, minute, second);
    }

    public static Date stringToDate(String yyyymmdd) {
        String year = null;
        String month = null;
        String date = null;
        String hour = null;
        String minute = null;
        String second = null;
        if (yyyymmdd != null && yyyymmdd.trim().length() > 0) {
            if (yyyymmdd.length() == 8) {
                year = yyyymmdd.substring(0, 4);
                month = yyyymmdd.substring(4, 6);
                date = yyyymmdd.substring(6, 8);
            } else {
                int index = -1;
                index = yyyymmdd.indexOf("-");
                if (index != -1) {
                    String[] arr = yyyymmdd.split("-");
                    if (arr.length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                } else {
                    String[] arr;
                    index = yyyymmdd.indexOf("/");
                    if (index != -1 && (arr = yyyymmdd.split("/")).length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                }
            }
        }
        if (year == null || month == null || date == null) {
            return null;
        }
        return DateUtils.stringToDate(year, month, date, hour, minute, second);
    }

    public static Date stringToDate(String yyyymmdd, String hour, String minute, String second) {
        String year = null;
        String month = null;
        String date = null;
        if (yyyymmdd != null) {
            if (yyyymmdd.length() == 8) {
                year = yyyymmdd.substring(0, 4);
                month = yyyymmdd.substring(4, 6);
                date = yyyymmdd.substring(6, 8);
            } else {
                int index = -1;
                index = yyyymmdd.indexOf("-");
                if (index != -1) {
                    String[] arr = yyyymmdd.split("-");
                    if (arr.length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                } else {
                    String[] arr;
                    index = yyyymmdd.indexOf("/");
                    if (index != -1 && (arr = yyyymmdd.split("/")).length == 3) {
                        year = arr[0];
                        month = arr[1];
                        date = arr[2];
                    }
                }
            }
        }
        if (year == null || month == null || date == null) {
            return null;
        }
        return DateUtils.stringToDate(year, month, date, hour, minute, second);
    }

    public static Date stringToDate(String year, String month, String date, String hour, String minute, String second) {
        if (year == null || "".equals(year.trim())) {
            year = "0";
        }
        if (month == null || "".equals(month.trim())) {
            month = "0";
        }
        if (date == null || "".equals(date.trim())) {
            date = "0";
        }
        if (hour == null || "".equals(hour.trim())) {
            hour = "0";
        }
        if (minute == null || "".equals(minute.trim())) {
            minute = "0";
        }
        if (second == null || "".equals(second.trim())) {
            second = "0";
        }
        int yyyy = Integer.parseInt(year, 10);
        int mm = Integer.parseInt(month, 10) - 1;
        int dd = Integer.parseInt(date, 10);
        int hh = Integer.parseInt(hour, 10);
        int mi = Integer.parseInt(minute, 10);
        int ss = Integer.parseInt(second, 10);
        GregorianCalendar cal = new GregorianCalendar(yyyy, mm, dd, hh, mi, ss);
        Date dateTime = new Date(cal.getTime().getTime());
        return dateTime;
    }

    public static Date convertToDate(String dateString) {
        try {
            if (dateString.length() == 10) {
                dateString = dateString.substring(0, 4) + "-" + dateString.substring(5, 7) + "-" + dateString.substring(8);
            }
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
            fmt.setLenient(false);
            return fmt.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldnt convert to Date. " + dateString, e);
        }
    }

    public static Date convertToDate(String dateString, String format) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            fmt.setLenient(false);
            return fmt.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldnt convert to Date. " + dateString, e);
        }
    }
}

