/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.mail;

import java.util.Hashtable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class MXLoockup {
    public static String lookupHost(String domain) {
        String mailServer = null;
        Attribute attr = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ictx = new InitialDirContext(env);
            Attributes attrs = ictx.getAttributes(domain, new String[]{"MX"});
            attr = attrs.get("MX");
        }
        catch (Exception e) {
            return null;
        }
        if (attr == null) {
            return null;
        }
        String valueString = attr.toString();
        String[] values = valueString.split(" ");
        if (values.length >= 3) {
            mailServer = values[2].trim();
        }
        if (mailServer.endsWith(",")) {
            mailServer = mailServer.substring(0, mailServer.length() - 1);
        }
        return mailServer;
    }

    public static String lookupDomain(String mailaddress) {
        if (mailaddress == null) {
            return mailaddress;
        }
        String domainname = mailaddress;
        int atIndex = mailaddress.indexOf("@");
        if (atIndex >= 0) {
            domainname = mailaddress.substring(atIndex + 1);
        }
        return domainname;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: MXLookup host [...]");
            System.exit(99);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            try {
                System.out.println(args[i2] + " is using " + MXLoockup.lookupHost(args[i2]) + " mail servers");
                continue;
            }
            catch (Exception e) {
                System.out.println(args[i2] + " : " + e.getMessage());
            }
        }
    }
}

