/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.mail;

import com.jware.util.mail.BaseMailData;
import com.jware.util.mail.BaseMailSender;
import com.jware.util.mail.MailResourceUtility;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleMailSender {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceBundle myResources = null;

    public SimpleMailSender() {
        ResourceBundle myResources = new MailResourceUtility().getResources();
    }

    public boolean execute(BaseMailData mailData) {
        boolean result = false;
        return result;
    }

    public void configMailSender(BaseMailSender mailSender) {
        if (mailSender != null) {
            mailSender.setSmtpDirectFlg(this.isSmtpDirectFlg());
            mailSender.setPopBeforeSmtp(this.isPopBeforeSmtp());
            mailSender.setShiftJISFlg(this.isShiftJISFlg());
            mailSender.setServerOsEncode(this.getResourceString("ServerOsEncode"));
            mailSender.setSmtpEncode(this.getResourceString("SmtpEncode"));
            mailSender.setSmtpServerAddress(this.getResourceString("SmtpServerAddress"));
            mailSender.setPopServerAddress(this.getResourceString("PopServerAddress"));
            mailSender.setPopAccessUserName(this.getResourceString("PopAccessUserName"));
            mailSender.setPopAccessPassword(this.getResourceString("PopAccessPassword"));
            mailSender.setBccMailAdddress(this.getResourceString("BccMailAdddress"));
            mailSender.setClientOsEncode(this.getResourceString("ClientOsEncode"));
            mailSender.setFileEncodingType(this.getResourceString("FileEncodingType"));
            mailSender.setFileDistination(this.getResourceString("FileDistination"));
        }
    }

    public boolean isSmtpDirectFlg() {
        return Pattern.matches("[Yy][Ee][Ss]", this.myResources.getString("SmtpDirectFlg"));
    }

    public boolean isPopBeforeSmtp() {
        return Pattern.matches("[Yy][Ee][Ss]", this.myResources.getString("PopBeforSmtp"));
    }

    public boolean isShiftJISFlg() {
        return Pattern.matches("[Yy][Ee][Ss]", this.getResourceString("ShiftJISFlg"));
    }

    public String getResourceString(String key) {
        String result = null;
        try {
            result = this.myResources.getString(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

