/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class XSLTransform {
    public Document transformDOM2DOM(String xslFile, Document xmlDoc) throws TransformerException, TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        DocumentImpl doc = null;
        StringBuffer w = new StringBuffer();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (!tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
            throw new SAXNotSupportedException("DOM node processing not supported!");
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
        Document xslDoc = dBuilder.parse(xslFile);
        DOMSource xslDomSource = new DOMSource(xslDoc);
        xslDomSource.setSystemId(xslFile);
        Transformer transformer = tFactory.newTransformer(xslDomSource);
        DOMSource xmlDomSource = new DOMSource(xmlDoc);
        DOMResult domResult = new DOMResult();
        transformer.transform(xmlDomSource, domResult);
        doc = new DocumentImpl();
        Node node = doc.importNode(domResult.getNode().getFirstChild(), true);
        doc.appendChild(node);
        return doc;
    }

    public String transformDOM2String(String xslFile, Document xmlDoc, String format) throws TransformerException, TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        StringWriter stringOut = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (!tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") || !tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
            throw new SAXNotSupportedException("DOM node processing not supported!");
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
        Document xslDoc = dBuilder.parse(xslFile);
        DOMSource xslDomSource = new DOMSource(xslDoc);
        xslDomSource.setSystemId(xslFile);
        Transformer transformer = tFactory.newTransformer(xslDomSource);
        DOMSource xmlDomSource = new DOMSource(xmlDoc);
        DOMResult domResult = new DOMResult();
        transformer.transform(xmlDomSource, domResult);
        DocumentImpl doc = new DocumentImpl();
        Node node = doc.importNode(domResult.getNode().getFirstChild(), true);
        doc.appendChild(node);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("indent-amount", "2");
        serializer.setOutputProperties(oprops);
        serializer.transform(new DOMSource((Node)doc), new StreamResult(stringOut));
        return stringOut.toString();
    }

    public String serializeDOM(Document doc) throws TransformerException, TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        StringWriter stringOut = new StringWriter();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("method", "xml");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.transform(new DOMSource(doc), new StreamResult(stringOut));
        StringBuffer s = new StringBuffer();
        s.append(stringOut.toString());
        return s.toString();
    }

    public String SerializeNode(Node node) throws TransformerException, TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        StringWriter stringOut = new StringWriter();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("method", "xml");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.transform(new DOMSource(node), new StreamResult(stringOut));
        return stringOut.toString();
    }
}

