/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.displaytag.decorator.AutolinkColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.util.Anchor;
import org.displaytag.util.CompatibleUrlEncoder;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.LookupUtil;
import org.displaytag.util.ShortToStringStyle;

public class Column {
    private Row row;
    private HeaderCell header;
    private HtmlAttributeMap htmlAttributes;
    private String stringValue;
    private Cell cell;

    public Column(HeaderCell headerCell, Cell currentCell, Row parentRow) {
        this.header = headerCell;
        this.row = parentRow;
        this.cell = currentCell;
        this.htmlAttributes = headerCell.getHtmlAttributes();
    }

    public Object getValue(boolean decorated) throws ObjectLookupException, DecoratorException {
        Object object = null;
        if (this.cell.getStaticValue() != null) {
            object = this.cell.getStaticValue();
        } else if (this.header.getBeanPropertyName() != null) {
            TableDecorator tableDecorator = this.row.getParentTable().getTableDecorator();
            object = decorated && tableDecorator != null && tableDecorator.hasGetterFor(this.header.getBeanPropertyName()) ? LookupUtil.getBeanProperty(tableDecorator, this.header.getBeanPropertyName()) : LookupUtil.getBeanProperty(this.row.getObject(), this.header.getBeanPropertyName());
        }
        if (decorated && this.header.getColumnDecorator() != null) {
            object = this.header.getColumnDecorator().decorate(object);
        }
        if ((object == null || object.equals("null")) && !this.header.getShowNulls()) {
            object = "";
        }
        return object;
    }

    public String getOpenTag() throws ObjectLookupException, DecoratorException {
        this.stringValue = this.createChoppedAndLinkedValue();
        return HtmlTagUtil.createOpenTagString("td", this.htmlAttributes);
    }

    public String getCloseTag() {
        this.stringValue = null;
        return this.header.getCloseTag();
    }

    public String createChoppedAndLinkedValue() throws ObjectLookupException, DecoratorException {
        String choppedValue;
        String fullValue = ObjectUtils.toString(this.getValue(true));
        if (this.header.getAutoLink()) {
            fullValue = AutolinkColumnDecorator.INSTANCE.decorate(fullValue);
        }
        if ((choppedValue = this.header.getMaxLength() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxLength(), false) : (this.header.getMaxWords() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxWords(), true) : fullValue)).length() < fullValue.length()) {
            this.htmlAttributes = (HtmlAttributeMap)this.htmlAttributes.clone();
            this.htmlAttributes.put("title", HtmlTagUtil.stripHTMLTags(fullValue));
        }
        if (this.header.getHref() != null) {
            Href colHref = this.getColumnHref(fullValue);
            Anchor anchor = new Anchor(colHref, choppedValue);
            choppedValue = anchor.toString();
        }
        return choppedValue;
    }

    private Href getColumnHref(String columnContent) throws ObjectLookupException {
        Object paramValue;
        Href colHref = new Href(this.header.getHref());
        if (this.header.getParamName() != null && (paramValue = this.header.getParamProperty() != null ? LookupUtil.getBeanProperty(this.row.getObject(), this.header.getParamProperty()) : columnContent) != null) {
            colHref.addParameter(this.header.getParamName(), CompatibleUrlEncoder.encode(paramValue.toString(), this.row.getParentTable().getEncoding()));
        }
        return colHref;
    }

    public String getChoppedAndLinkedValue() {
        return this.stringValue;
    }

    public int getGroup() {
        return this.header.getGroup();
    }

    public String toString() {
        return new ToStringBuilder(this, ShortToStringStyle.SHORT_STYLE).append("cell", this.cell).append("header", this.header).append("htmlAttributes", this.htmlAttributes).append("stringValue", this.stringValue).toString();
    }
}

