/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.RowSorter;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.ShortToStringStyle;

public class TableModel {
    private static Log log = LogFactory.getLog(TableModel.class);
    private List headerCellList;
    private List rowListFull = new ArrayList(20);
    private List rowListPage;
    private boolean sortOrderAscending = true;
    private boolean sortFullTable = true;
    private int sortedColumn = -1;
    private TableDecorator tableDecorator;
    private String id;
    private TableProperties properties;
    private int pageOffset;
    private String encoding;

    public TableModel(TableProperties tableProperties, String charEncoding) {
        this.headerCellList = new ArrayList(20);
        this.properties = tableProperties;
        this.encoding = charEncoding;
    }

    public void setPageOffset(int offset) {
        this.pageOffset = offset;
    }

    public void setId(String tableId) {
        this.id = tableId;
    }

    public List getRowListFull() {
        return this.rowListFull;
    }

    public List getRowListPage() {
        return this.rowListPage;
    }

    public void addRow(Row row) {
        row.setParentTable(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] adding row " + row));
        }
        this.rowListFull.add(row);
    }

    public void setSortFullTable(boolean sortFull) {
        this.sortFullTable = sortFull;
    }

    public boolean isSortFullTable() {
        return this.sortFullTable;
    }

    public boolean isSortOrderAscending() {
        return this.sortOrderAscending;
    }

    public void setSortOrderAscending(boolean isSortOrderAscending) {
        this.sortOrderAscending = isSortOrderAscending;
    }

    public void setRowListPage(List rowList) {
        this.rowListPage = rowList;
    }

    public TableDecorator getTableDecorator() {
        return this.tableDecorator;
    }

    public void setTableDecorator(TableDecorator decorator) {
        this.tableDecorator = decorator;
    }

    public boolean isSorted() {
        return this.sortedColumn != -1;
    }

    public HeaderCell getSortedColumnHeader() {
        if (this.sortedColumn < 0 || this.sortedColumn > this.headerCellList.size() - 1) {
            return null;
        }
        return (HeaderCell)this.headerCellList.get(this.sortedColumn);
    }

    public int getNumberOfColumns() {
        return this.headerCellList.size();
    }

    public boolean isEmpty() {
        return this.headerCellList.size() <= 1;
    }

    public int getSortedColumnNumber() {
        return this.sortedColumn;
    }

    public void setSortedColumnNumber(int sortIndex) {
        this.sortedColumn = sortIndex;
    }

    public void addColumnHeader(HeaderCell headerCell) {
        if (this.sortedColumn == this.headerCellList.size()) {
            headerCell.setAlreadySorted();
        }
        headerCell.setColumnNumber(this.headerCellList.size());
        this.headerCellList.add(headerCell);
    }

    public List getHeaderCellList() {
        return this.headerCellList;
    }

    public RowIterator getRowIterator(boolean full) {
        RowIterator iterator = new RowIterator(full ? this.rowListFull : this.rowListPage, this.headerCellList, this.tableDecorator, this.pageOffset);
        iterator.setId(this.id);
        return iterator;
    }

    private void sortRowList(List list) {
        HeaderCell sortedHeaderCell;
        if (this.isSorted() && (sortedHeaderCell = this.getSortedColumnHeader()) != null && (sortedHeaderCell.getBeanPropertyName() != null || this.sortedColumn != -1 && this.sortedColumn < this.headerCellList.size())) {
            if (sortedHeaderCell.getSortProperty() != null) {
                Collections.sort(list, new RowSorter(this.sortedColumn, sortedHeaderCell.getSortProperty(), this.getTableDecorator(), this.sortOrderAscending));
            } else {
                Collections.sort(list, new RowSorter(this.sortedColumn, sortedHeaderCell.getBeanPropertyName(), this.getTableDecorator(), this.sortOrderAscending));
            }
        }
    }

    public void sortPageList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] sorting page list"));
        }
        this.sortRowList(this.rowListPage);
    }

    public void sortFullList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] sorting full data"));
        }
        this.sortRowList(this.rowListFull);
    }

    public TableProperties getProperties() {
        return this.properties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return new ToStringBuilder(this, ShortToStringStyle.SHORT_STYLE).append("rowListFull", this.rowListFull).append("rowListPage", this.rowListPage).append("properties", this.properties).append("empty", this.isEmpty()).append("encoding", this.encoding).append("numberOfColumns", this.getNumberOfColumns()).append("headerCellList", this.headerCellList).append("sortFullTable", this.sortFullTable).append("sortedColumnNumber", this.getSortedColumnNumber()).append("sortOrderAscending", this.sortOrderAscending).append("sortedColumnHeader", this.getSortedColumnHeader()).append("sorted", this.isSorted()).append("tableDecorator", this.tableDecorator).toString();
    }
}

