/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.util.Env;

public class ConfigSQLServer
extends Config {
    private static SQLServerDriver s_SQLServerDriver = null;
    private Connection m_con = null;

    public ConfigSQLServer(ConfigurationData data) {
        super(data);
    }

    public void init() {
        this.p_data.setDatabasePort(String.valueOf(1433));
        this.p_data.setDatabaseName("compiere");
        this.p_data.setDatabaseSystemPassword(true);
    }

    public String test() {
        String server = this.p_data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabaseServer", pass, true, error);
        this.log.info("OK: Database Server = " + databaseServer);
        this.setProperty("COMPIERE_DB_SERVER", databaseServer.getHostName());
        this.setProperty("COMPIERE_DB_TYPE", this.p_data.getDatabaseType());
        this.setProperty("COMPIERE_DB_PATH", this.p_data.getDatabaseType());
        int databasePort = this.p_data.getDatabasePort();
        pass = this.p_data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabasePort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Database Port = " + databasePort);
        this.setProperty("COMPIERE_DB_PORT", String.valueOf(databasePort));
        String databaseName = this.p_data.getDatabaseName();
        String systemPassword = this.p_data.getDatabaseSystemPassword();
        pass = systemPassword != null && systemPassword.length() > 0;
        error = "No Database System Password entered";
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url = "jdbc:sqlserver://" + databaseServer.getHostName() + ":" + databasePort;
        this.log.info("url = " + url);
        pass = this.testJDBC(url, "sa", systemPassword);
        this.log.info("testJDBC result = " + pass);
        error = "Error connecting: " + url + " - as sa/" + systemPassword;
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Connection = " + url);
        this.setProperty("COMPIERE_DB_URL", url);
        this.log.info("OK: Database System User " + databaseName);
        this.setProperty("COMPIERE_DB_NAME", databaseName);
        this.setProperty("COMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = this.p_data.getDatabaseUser();
        String databasePassword = this.p_data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "Invalid Database User Password";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Database imported? Cannot connect to User: " + databaseUser + "/" + databasePassword;
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, false, error);
        if (pass) {
            this.log.info("OK: Database User = " + databaseUser);
            if (this.m_con != null) {
                this.setProperty("COMPIERE_WEBSTORES", this.getWebStores(this.m_con));
            }
        } else {
            this.log.warning(error);
        }
        this.setProperty("COMPIERE_DB_USER", databaseUser);
        this.setProperty("COMPIERE_DB_PASSWORD", databasePassword);
        if (!this.p_data.getAppsServerType().equals("tomcatOnly")) {
            String cmd = "";
            if (Env.isWindows()) {
                cmd = "osql -U sa -P " + systemPassword + " -d " + databaseName;
                String sqlcmd2 = cmd + "-i utils/sqlServer/Test.sql";
                this.log.config(sqlcmd2);
                pass = this.testSQL(sqlcmd2);
                error = "Error connecting via: " + sqlcmd2;
                this.signalOK(this.getPanel().okDatabaseSQL, "ErrorTNS", pass, true, error);
                if (pass) {
                    this.log.info("OK: Database SQL Connection");
                }
            }
        }
        this.m_con = null;
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        this.log.fine("Url=" + url + ", UID=" + uid);
        this.log.info("testJDBC: Url=" + url + ", UID=" + uid + ", PWD=" + pwd);
        try {
            if (s_SQLServerDriver == null) {
                this.log.info("s_SQLServerDriver == null");
                s_SQLServerDriver = new SQLServerDriver();
                this.log.info("s_SQLServerDriver = " + s_SQLServerDriver.toString());
                DriverManager.registerDriver((Driver)s_SQLServerDriver);
                this.log.info("SQLServerDriver registered");
            }
            this.m_con = DriverManager.getConnection(url, uid, pwd);
            this.log.info("m_con = " + this.m_con.toString());
        }
        catch (Exception e) {
            this.log.warning(e.toString());
            return false;
        }
        return true;
    }

    private boolean testSQL(String sqlcmd) {
        return true;
    }
}

