/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;

class BSHCastExpression
extends SimpleNode {
    public BSHCastExpression(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Class clazz = ((BSHType)this.jjtGetChild(0)).getType(callStack, interpreter);
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(1);
        Object object2 = simpleNode.eval(callStack, interpreter);
        Class<?> clazz2 = object2.getClass();
        try {
            return BSHCastExpression.castObject(object2, clazz);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }

    public static Object castObject(Object object2, Class clazz) throws UtilEvalError {
        Class<?> clazz2 = object2.getClass();
        Object object3 = null;
        if (clazz.isPrimitive()) {
            if (object2 instanceof Primitive) {
                object3 = BSHCastExpression.castPrimitive((Primitive)object2, clazz);
            } else {
                BSHCastExpression.castError(object2.getClass(), clazz);
            }
        } else if (object2 instanceof Primitive) {
            object3 = BSHCastExpression.castPrimitive((Primitive)object2, clazz);
        } else if (Capabilities.canGenerateInterfaces() && object2 instanceof This && clazz.isInterface()) {
            object3 = ((This)object2).getInterface(clazz);
        } else if (clazz.isInstance(object2)) {
            object3 = object2;
        } else {
            BSHCastExpression.castError(clazz2, clazz);
        }
        if (object3 == null) {
            throw new InternalError("bad construct somewhere...");
        }
        return object3;
    }

    public static void castError(Class clazz, Class clazz2) throws UtilEvalError {
        BSHCastExpression.castError(Reflect.normalizeClassName(clazz), Reflect.normalizeClassName(clazz2));
    }

    public static void castError(String string, String string2) throws UtilEvalError {
        ClassCastException classCastException = new ClassCastException("Illegal cast. Cannot cast " + string + " to " + string2);
        throw new UtilTargetError(classCastException);
    }

    public static Primitive castPrimitive(Primitive primitive, Class clazz) throws UtilEvalError {
        if (primitive == Primitive.VOID) {
            BSHCastExpression.castError("void value", Reflect.normalizeClassName(clazz));
        }
        Object object2 = primitive.getValue();
        Class clazz2 = primitive.getType();
        if (!clazz.isPrimitive()) {
            if (primitive != Primitive.NULL) {
                BSHCastExpression.castError("primitive value", "object type:" + clazz);
            } else {
                return primitive;
            }
        }
        if (clazz2 == Boolean.TYPE) {
            if (clazz != Boolean.TYPE) {
                BSHCastExpression.castError(clazz2, clazz);
            } else {
                return primitive;
            }
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (object2 instanceof Number) {
            Number number = (Number)object2;
            if (clazz == Byte.TYPE) {
                object2 = new Primitive(number.byteValue());
            } else if (clazz == Short.TYPE) {
                object2 = new Primitive(number.shortValue());
            } else if (clazz == Character.TYPE) {
                object2 = new Primitive((char)number.intValue());
            } else if (clazz == Integer.TYPE) {
                object2 = new Primitive(number.intValue());
            } else if (clazz == Long.TYPE) {
                object2 = new Primitive(number.longValue());
            } else if (clazz == Float.TYPE) {
                object2 = new Primitive(number.floatValue());
            } else if (clazz == Double.TYPE) {
                object2 = new Primitive(number.doubleValue());
            } else {
                BSHCastExpression.castError(clazz2, clazz);
            }
            return (Primitive)object2;
        }
        throw new UtilEvalError("unknown type in cast");
    }
}

