/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Object object2, String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws ReflectError, EvalError, InvocationTargetException {
        if (object2 instanceof This && !Reflect.passThisMethod(string)) {
            return ((This)object2).invokeMethod(string, objectArray, interpreter, callStack, simpleNode);
        }
        try {
            BshClassManager bshClassManager = callStack.top().getClassManager();
            Class<?> clazz = object2.getClass();
            Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, object2, string, objectArray, false);
            return Reflect.invokeOnMethod(method, object2, objectArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(simpleNode, callStack);
        }
    }

    public static Object invokeStaticMethod(BshClassManager bshClassManager, Class clazz, String string, Object[] objectArray) throws ReflectError, UtilEvalError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        Method method = Reflect.resolveJavaMethod(bshClassManager, clazz, null, string, objectArray, true);
        return Reflect.invokeOnMethod(method, null, objectArray);
    }

    private static Object invokeOnMethod(Method method, Object object2, Object[] objectArray) throws ReflectError, InvocationTargetException {
        int n;
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (entry): " + method + " with args:");
            int n2 = 0;
            while (n2 < objectArray.length) {
                Interpreter.debug("args[" + n2 + "] = " + objectArray[n2] + " type = " + objectArray[n2].getClass());
                ++n2;
            }
        }
        Object[] objectArray2 = new Object[objectArray.length];
        Class<?>[] classArray = method.getParameterTypes();
        try {
            n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = NameSpace.getAssignableForm(objectArray[n], classArray[n]);
                ++n;
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("illegal argument type in method invocation: " + utilEvalError);
        }
        objectArray2 = Reflect.unwrapPrimitives(objectArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Invoking method (after massaging values): " + method + " with tmpArgs:");
            n = 0;
            while (n < objectArray2.length) {
                Interpreter.debug("tmpArgs[" + n + "] = " + objectArray2[n] + " type = " + objectArray2[n].getClass());
                ++n;
            }
        }
        try {
            Object object3 = method.invoke(object2, objectArray2);
            if (object3 == null) {
                object3 = Primitive.NULL;
            }
            Class<?> clazz = method.getReturnType();
            return Reflect.wrapPrimitive(object3, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(method.getName(), method.getParameterTypes()) + " in '" + method.getDeclaringClass() + "' :" + illegalAccessException);
        }
    }

    private static boolean passThisMethod(String string) {
        return string.equals("getClass") || string.equals("invokeMethod") || string.equals("getInterface") || string.equals("wait") || string.equals("notify") || string.equals("notifyAll");
    }

    public static Object getIndex(Object object2, int n) throws ReflectError, UtilTargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + object2 + ", index=" + n);
        }
        try {
            Object object3 = Array.get(object2, n);
            return Reflect.wrapPrimitive(object3, object2.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new UtilTargetError(arrayIndexOutOfBoundsException);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object2, int n, Object object3) throws ReflectError, UtilTargetError {
        try {
            object3 = Primitive.unwrap(object3);
            Array.set(object2, n, object3);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new UtilTargetError(arrayStoreException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UtilTargetError(new ArrayStoreException(illegalArgumentException.toString()));
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        return Reflect.getFieldValue(clazz, null, string);
    }

    public static Object getObjectField(Object object2, String string) throws UtilEvalError, ReflectError {
        if (object2 instanceof This) {
            return ((This)object2).namespace.getVariable(string);
        }
        try {
            return Reflect.getFieldValue(object2.getClass(), object2, string);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertyGetter(object2.getClass(), string)) {
                return Reflect.getObjectProperty(object2, string);
            }
            throw reflectError;
        }
    }

    static LHS getLHSStaticField(Class clazz, String string) throws UtilEvalError, ReflectError {
        Field field = Reflect.getField(clazz, string);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object2, String string) throws UtilEvalError, ReflectError {
        if (object2 instanceof This) {
            boolean bl = false;
            return new LHS(((This)object2).namespace, string, bl);
        }
        try {
            Field field = Reflect.getField(object2.getClass(), string);
            return new LHS(object2, field);
        }
        catch (ReflectError reflectError) {
            if (Reflect.hasObjectPropertySetter(object2.getClass(), string)) {
                return new LHS(object2, string);
            }
            throw reflectError;
        }
    }

    private static Object getFieldValue(Class clazz, Object object2, String string) throws UtilEvalError, ReflectError {
        try {
            Field field = Reflect.getField(clazz, string);
            if (field == null) {
                throw new ReflectError("internal: field not found:" + string);
            }
            Object object3 = field.get(object2);
            Class<?> clazz2 = field.getType();
            return Reflect.wrapPrimitive(object3, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    private static Field getField(Class clazz, String string) throws UtilEvalError, ReflectError {
        try {
            if (Capabilities.haveAccessibility()) {
                return Reflect.findAccessibleField(clazz, string);
            }
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Field findAccessibleField(Class var0, String var1_1) throws UtilEvalError, NoSuchFieldException {
        try {
            return var0.getField(var1_1);
        }
        catch (NoSuchFieldException var2_2) {
            ** while (var0 != null)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var2_3 = var0.getDeclaredField(var1_1);
                if (ReflectManager.RMSetAccessible(var2_3)) {
                    return var2_3;
                }
            }
            catch (NoSuchFieldException var2_4) {
                // empty catch block
            }
            var0 = var0.getSuperclass();
            continue;
        }
lbl14:
        // 1 sources

        throw new NoSuchFieldException(var1_1);
    }

    static Method resolveJavaMethod(BshClassManager bshClassManager, Class clazz, Object object2, String string, Object[] objectArray, boolean bl) throws ReflectError, UtilEvalError {
        Method method = null;
        if (bshClassManager == null) {
            Interpreter.debug("resolveJavaMethod UNOPTIMIZED lookup");
        } else {
            method = bshClassManager.getResolvedMethod(clazz, string, objectArray, bl);
            if (method != null) {
                return method;
            }
        }
        if (object2 == Primitive.NULL) {
            throw new UtilTargetError(new NullPointerException("Attempt to invoke method " + string + " on null value"));
        }
        Class[] classArray = Reflect.getTypes(objectArray);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Searching for method: " + StringUtil.methodString(string, classArray) + " in '" + clazz.getName() + "'");
        }
        try {
            method = Reflect.findAccessibleMethod(clazz, string, classArray, bl);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (Interpreter.DEBUG && method != null) {
            Interpreter.debug("findAccessibleMethod found: " + method);
        }
        if (method == null) {
            if (classArray.length == 0) {
                throw new ReflectError("No args " + (bl ? "static " : "") + "method " + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
            }
            Method[] methodArray = clazz.getMethods();
            if (bl) {
                methodArray = Reflect.retainStaticMethods(methodArray);
            }
            method = Reflect.findMostSpecificMethod(string, classArray, methodArray);
            if (Interpreter.DEBUG && method != null) {
                Interpreter.debug("findMostSpecificMethod found: " + method);
            }
            if (method == null) {
                method = Reflect.findExtendedMethod(string, objectArray, methodArray);
                if (Interpreter.DEBUG && method != null) {
                    Interpreter.debug("findExtendedMethod found: " + method);
                }
            }
            if (method != null) {
                try {
                    method = Reflect.findAccessibleMethod(clazz, method.getName(), method.getParameterTypes(), bl);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (Interpreter.DEBUG && method == null) {
                    Interpreter.debug("had a method, but it wasn't accessible");
                }
            }
        }
        if (method == null) {
            throw new ReflectError((bl ? "Static method " : "Method ") + StringUtil.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
        }
        if (bshClassManager != null) {
            bshClassManager.cacheResolvedMethod(clazz, objectArray, method);
        }
        return method;
    }

    private static Method[] retainStaticMethods(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (Modifier.isStatic(methodArray[n].getModifiers())) {
                vector.addElement(methodArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static Method findAccessibleMethod(Class clazz, String string, Class[] classArray, boolean bl) throws UtilEvalError {
        Method method = null;
        Method method2 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(clazz);
        Method method3 = null;
        while (vector.size() > 0) {
            Class<?>[] classArray2;
            Class clazz2 = (Class)vector.firstElement();
            vector.removeElementAt(0);
            if (Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility()) {
                try {
                    method = clazz2.getDeclaredMethod(string, classArray);
                    if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(clazz2.getModifiers()) || Capabilities.haveAccessibility() && ReflectManager.RMSetAccessible(method)) {
                        method3 = method;
                        break;
                    }
                    method2 = method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!clazz2.isInterface() && (classArray2 = clazz2.getSuperclass()) != null) {
                vector.addElement(classArray2);
            }
            classArray2 = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                vector.addElement(classArray2[n]);
                ++n;
            }
        }
        if (method3 != null && (!bl || Modifier.isStatic(method3.getModifiers()))) {
            return method3;
        }
        if (method2 != null) {
            throw new UtilEvalError("Found non-public method: " + method2 + ".  Use setAccessibility(true) to enable access to " + " private and protected members of classes.");
        }
        return null;
    }

    private static Object wrapPrimitive(Object object2, Class clazz) throws ReflectError {
        if (object2 == null) {
            return Primitive.NULL;
        }
        if (clazz == Void.TYPE) {
            return Primitive.VOID;
        }
        if (clazz.isPrimitive()) {
            if (object2 instanceof Number) {
                return new Primitive((Number)object2);
            }
            if (object2 instanceof Boolean) {
                return new Primitive((Boolean)object2);
            }
            if (object2 instanceof Character) {
                return new Primitive((Character)object2);
            }
            throw new ReflectError("Something bad happened");
        }
        return object2;
    }

    public static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n] == null ? null : (objectArray[n] instanceof Primitive ? ((Primitive)objectArray[n]).getType() : objectArray[n].getClass());
            ++n;
        }
        return classArray;
    }

    private static Object[] unwrapPrimitives(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = Primitive.unwrap(objectArray[n]);
            ++n;
        }
        return objectArray2;
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (clazz.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clazz);
        }
        Object var2_2 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Constructor constructor = null;
        Constructor[] constructorArray = clazz.getDeclaredConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clazz);
        }
        if ((constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray)) == null) {
            if (classArray.length == 0) {
                throw new ReflectError("Can't find default constructor for: " + clazz);
            }
            constructor = Reflect.findExtendedConstructor(objectArray, constructorArray);
        }
        if (constructor == null) {
            throw new ReflectError("Can't find constructor: " + StringUtil.methodString(clazz.getName(), classArray) + " in class: " + clazz.getName());
        }
        try {
            objectArray = Reflect.unwrapPrimitives(objectArray);
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("we don't have permission to create an instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (var2_2 == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return var2_2;
    }

    static Method findMostSpecificMethod(String string, Class[] classArray, Method[] methodArray) {
        int n;
        Vector<Class<?>[]> vector = new Vector<Class<?>[]>();
        Vector<Method> vector2 = new Vector<Method>();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (methodArray[n2].getName().equals(string)) {
                vector2.addElement(methodArray[n2]);
                vector.addElement(methodArray[n2].getParameterTypes());
            }
            ++n2;
        }
        Class[][] classArray2 = new Class[vector.size()][];
        vector.copyInto((Object[])classArray2);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + string);
        }
        if ((n = Reflect.findMostSpecificSignature(classArray, classArray2)) == -1) {
            return null;
        }
        return (Method)vector2.elementAt(n);
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        Class[][] classArray2 = new Class[constructorArray.length][];
        int n = 0;
        while (n < classArray2.length) {
            classArray2[n] = constructorArray[n].getParameterTypes();
            ++n;
        }
        int n2 = Reflect.findMostSpecificSignature(classArray, classArray2);
        if (n2 == -1) {
            return null;
        }
        return constructorArray[n2];
    }

    static Method findExtendedMethod(String string, Object[] objectArray, Method[] methodArray) {
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            Class[] classArray = method.getParameterTypes();
            if (string.equals(method.getName()) && Reflect.argsAssignable(classArray, objectArray)) {
                return method;
            }
            ++n;
        }
        return null;
    }

    static Constructor findExtendedConstructor(Object[] objectArray, Constructor[] constructorArray) {
        int n = 0;
        while (n < constructorArray.length) {
            Constructor constructor = constructorArray[n];
            Class[] classArray = constructor.getParameterTypes();
            if (Reflect.argsAssignable(classArray, objectArray)) {
                return constructor;
            }
            ++n;
        }
        return null;
    }

    private static boolean argsAssignable(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return false;
        }
        try {
            int n = 0;
            while (n < classArray.length) {
                NameSpace.getAssignableForm(objectArray[n], classArray[n]);
                ++n;
            }
        }
        catch (UtilEvalError utilEvalError) {
            return false;
        }
        return true;
    }

    static int findMostSpecificSignature(Class[] classArray, Class[][] classArray2) {
        Class[] classArray3 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < classArray2.length) {
            Class[] classArray4 = classArray2[n2];
            if (Reflect.isSignatureAssignable(classArray, classArray4) && (classArray3 == null || Reflect.isSignatureAssignable(classArray4, classArray3))) {
                classArray3 = classArray4;
                n = n2;
            }
            ++n2;
        }
        if (classArray3 != null) {
            return n;
        }
        Interpreter.debug("no match found");
        return -1;
    }

    private static boolean isSignatureAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (classArray2[n] != null && !Reflect.isJavaAssignableFrom(classArray2[n], classArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean isJavaAssignableFrom(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            if (clazz == clazz2) {
                return true;
            }
            if (clazz2 == Byte.TYPE && (clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Short.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Character.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && clazz == Double.TYPE) {
                return true;
            }
        } else if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        return false;
    }

    private static String accessorName(String string, String string2) {
        return string + String.valueOf(Character.toUpperCase(string2.charAt(0))) + string2.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("get", string);
        try {
            clazz.getMethod(string2, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = Reflect.accessorName("is", string);
            try {
                Method method = clazz.getMethod(string2, new Class[0]);
                return method.getReturnType() == Boolean.TYPE;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return false;
            }
        }
    }

    public static boolean hasObjectPropertySetter(Class clazz, String string) {
        String string2 = Reflect.accessorName("set", string);
        Class[] classArray = new Class[]{clazz};
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Object getObjectProperty(Object object2, String string) throws UtilEvalError, ReflectError {
        String string2;
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        Method method = null;
        Exception exception = null;
        Exception exception2 = null;
        try {
            string2 = Reflect.accessorName("get", string);
            method = Reflect.resolveJavaMethod(null, object2.getClass(), object2, string2, objectArray, false);
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        if (method == null) {
            try {
                string2 = Reflect.accessorName("is", string);
                method = Reflect.resolveJavaMethod(null, object2.getClass(), object2, string2, objectArray, false);
                if (method.getReturnType() != Boolean.TYPE) {
                    method = null;
                }
            }
            catch (Exception exception4) {
                exception2 = exception4;
            }
        }
        if (method == null) {
            throw new ReflectError("Error in property getter: " + exception + (exception2 != null ? " : " + exception2 : ""));
        }
        try {
            return Reflect.invokeOnMethod(method, object2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static void setObjectProperty(Object object2, String string, Object object3) throws ReflectError, UtilEvalError {
        String string2 = Reflect.accessorName("set", string);
        Object[] objectArray = new Object[]{object3};
        Interpreter.debug("property access: ");
        try {
            Method method = Reflect.resolveJavaMethod(null, object2.getClass(), object2, string2, objectArray, false);
            Reflect.invokeOnMethod(method, object2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Property accessor threw exception: " + invocationTargetException.getTargetException());
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName());
            int n = 0;
            while (n < Reflect.getArrayDimensions(clazz)) {
                stringBuffer.append("[]");
                ++n;
            }
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    public static Object invokeCompiledCommand(Class clazz, Object[] objectArray, Interpreter interpreter, CallStack callStack) throws UtilEvalError {
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = callStack;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        BshClassManager bshClassManager = interpreter.getClassManager();
        try {
            return Reflect.invokeStaticMethod(bshClassManager, clazz, "invoke", objectArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UtilEvalError("Error in compiled command: " + invocationTargetException.getTargetException());
        }
        catch (ReflectError reflectError) {
            throw new UtilEvalError("Error invoking compiled command: " + reflectError);
        }
    }
}

