/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.UtilEvalError;
import java.io.Serializable;

public class This
implements Serializable,
Runnable {
    NameSpace namespace;
    transient Interpreter declaringInterpreter;

    static This getThis(NameSpace nameSpace, Interpreter interpreter) {
        try {
            Class<?> clazz;
            if (Capabilities.canGenerateInterfaces()) {
                clazz = Class.forName("bsh.XThis");
            } else if (Capabilities.haveSwing()) {
                clazz = Class.forName("bsh.JThis");
            } else {
                return new This(nameSpace, interpreter);
            }
            return (This)Reflect.constructObject(clazz, new Object[]{nameSpace, interpreter});
        }
        catch (Exception exception) {
            throw new InterpreterError("internal error 1 in This: " + exception);
        }
    }

    public Object getInterface(Class clazz) throws UtilEvalError {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + clazz);
    }

    public Object getInterface(Class[] classArray) throws UtilEvalError {
        int n = 0;
        while (n < classArray.length) {
            if (!classArray[n].isInstance(this)) {
                throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + classArray[n]);
            }
            ++n;
        }
        return this;
    }

    protected This(NameSpace nameSpace, Interpreter interpreter) {
        this.namespace = nameSpace;
        this.declaringInterpreter = interpreter;
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public String toString() {
        return "'this' reference to Bsh object: " + this.namespace;
    }

    public void run() {
        try {
            this.invokeMethod("run", new Object[0]);
        }
        catch (EvalError evalError) {
            this.declaringInterpreter.error("Exception in runnable:" + evalError);
        }
    }

    public Object invokeMethod(String string, Object[] objectArray) throws EvalError {
        return this.invokeMethod(string, objectArray, this.declaringInterpreter, null, SimpleNode.JAVACODE);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        if (callStack == null) {
            callStack = new CallStack(this.namespace);
        }
        Class[] classArray = Reflect.getTypes(objectArray);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(string, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(objectArray, interpreter, callStack, simpleNode);
        }
        if (string.equals("toString")) {
            return this.toString();
        }
        if (string.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (string.equals("equals")) {
            Object object2 = objectArray[0];
            return new Boolean(this == object2);
        }
        try {
            bshMethod = this.namespace.getMethod("invoke", new Class[]{null, null});
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(new Object[]{string, objectArray}, interpreter, callStack, simpleNode);
        }
        throw new EvalError("Method " + StringUtil.methodString(string, classArray) + " not found in bsh scripted object: " + this.namespace.getName(), simpleNode, callStack);
    }

    public static void bind(This this_, NameSpace nameSpace, Interpreter interpreter) {
        this_.namespace.setParent(nameSpace);
        this_.declaringInterpreter = interpreter;
    }
}

