/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.AString;
import com.sun.mail.iap.Atom;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Argument {
    protected Vector items = new Vector(1);

    public void append(Argument argument) {
        this.items.ensureCapacity(this.items.size() + argument.items.size());
        int n = 0;
        while (n < argument.items.size()) {
            this.items.addElement(argument.items.elementAt(n));
            ++n;
        }
    }

    public void writeString(String string) {
        this.items.addElement(new AString(ASCIIUtility.getBytes(string)));
    }

    public void writeString(String string, String string2) throws UnsupportedEncodingException {
        if (string2 == null) {
            this.writeString(string);
            return;
        }
        this.items.addElement(new AString(string.getBytes(string2)));
    }

    public void writeBytes(byte[] byArray) {
        this.items.addElement(byArray);
    }

    public void writeBytes(ByteArrayOutputStream byteArrayOutputStream) {
        this.items.addElement(byteArrayOutputStream);
    }

    public void writeBytes(Literal literal) {
        this.items.addElement(literal);
    }

    public void writeAtom(String string) {
        this.items.addElement(new Atom(string));
    }

    public void writeNumber(int n) {
        this.items.addElement(new Integer(n));
    }

    public void writeNumber(long l) {
        this.items.addElement(new Long(l));
    }

    public void writeArgument(Argument argument) {
        this.items.addElement(argument);
    }

    public void write(Protocol protocol) throws IOException, ProtocolException {
        int n = this.items != null ? this.items.size() : 0;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        int n2 = 0;
        while (n2 < n) {
            Object e2;
            if (n2 > 0) {
                dataOutputStream.write(32);
            }
            if ((e2 = this.items.elementAt(n2)) instanceof Atom) {
                dataOutputStream.writeBytes(((Atom)e2).string);
            } else if (e2 instanceof Number) {
                dataOutputStream.writeBytes(((Number)e2).toString());
            } else if (e2 instanceof AString) {
                this.astring(((AString)e2).bytes, protocol);
            } else if (e2 instanceof byte[]) {
                this.literal((byte[])e2, protocol);
            } else if (e2 instanceof ByteArrayOutputStream) {
                this.literal((ByteArrayOutputStream)e2, protocol);
            } else if (e2 instanceof Literal) {
                this.literal((Literal)e2, protocol);
            } else if (e2 instanceof Argument) {
                dataOutputStream.write(40);
                ((Argument)e2).write(protocol);
                dataOutputStream.write(41);
            }
            ++n2;
        }
    }

    private void astring(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        byte by;
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        int n = byArray.length;
        if (n > 1024) {
            this.literal(byArray, protocol);
            return;
        }
        boolean bl = n == 0;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            by = byArray[n2];
            if (by == 0 || by == 13 || by == 10 || (by & 0xFF) > 127) {
                this.literal(byArray, protocol);
                return;
            }
            if (by == 42 || by == 37 || by == 40 || by == 41 || by == 123 || by == 34 || by == 92 || (by & 0xFF) <= 32) {
                bl = true;
                if (by == 34 || by == 92) {
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl) {
            dataOutputStream.write(34);
        }
        if (bl2) {
            int n3 = 0;
            while (n3 < n) {
                by = byArray[n3];
                if (by == 34 || by == 92) {
                    dataOutputStream.write(92);
                }
                dataOutputStream.write(by);
                ++n3;
            }
        } else {
            dataOutputStream.write(byArray);
        }
        if (bl) {
            dataOutputStream.write(34);
        }
    }

    private void literal(byte[] byArray, Protocol protocol) throws IOException, ProtocolException {
        this.startLiteral(protocol, byArray.length).write(byArray);
    }

    private void literal(ByteArrayOutputStream byteArrayOutputStream, Protocol protocol) throws IOException, ProtocolException {
        byteArrayOutputStream.writeTo(this.startLiteral(protocol, byteArrayOutputStream.size()));
    }

    private void literal(Literal literal, Protocol protocol) throws IOException, ProtocolException {
        literal.writeTo(this.startLiteral(protocol, literal.size()));
    }

    private OutputStream startLiteral(Protocol protocol, int n) throws IOException, ProtocolException {
        DataOutputStream dataOutputStream = (DataOutputStream)protocol.getOutputStream();
        boolean bl = protocol.supportsNonSyncLiterals();
        dataOutputStream.write(123);
        dataOutputStream.writeBytes(Integer.toString(n));
        if (bl) {
            dataOutputStream.writeBytes("+}\r\n");
        } else {
            dataOutputStream.writeBytes("}\r\n");
        }
        dataOutputStream.flush();
        if (!bl) {
            Response response;
            while (!(response = protocol.readResponse()).isContinuation()) {
                if (!response.isTagged()) continue;
                throw new LiteralException(response);
            }
        }
        return dataOutputStream;
    }
}

