/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus;
    private long cachedStatusTime;
    private boolean debug = false;
    private PrintStream out;
    private boolean connectionPoolDebug;
    static /* synthetic */ Class class$javax$mail$Flags;

    protected IMAPFolder(String string, char c2, IMAPStore iMAPStore) {
        super(iMAPStore);
        if (string == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = string;
        this.separator = c2;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
        this.out = iMAPStore.getSession().getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, String.valueOf(this.fullName) + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    private void checkRange(int n) throws MessagingException {
        if (n < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this.total) {
            return;
        }
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        block2: {
            if (this.name != null) break block2;
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {}
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c2 = this.getSeparator0();
        int n = this.fullName.lastIndexOf(c2);
        if (n != -1) {
            return new IMAPFolder(this.fullName.substring(0, n), c2, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        listInfoArray = (ListInfo[])this.doCommand(new 1());
        if (listInfoArray != null) {
            this.fullName = listInfoArray[0].name;
            this.separator = listInfoArray[0].separator;
            if (listInfoArray[0].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[0].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private Folder[] doList(String string, boolean bl) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        char c2 = this.getSeparator0();
        ListInfo[] listInfoArray = (ListInfo[])this.doCommandIgnoreFailure(new 2(c2, string, bl, this));
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n = 0;
        if (listInfoArray[0].name.equals(String.valueOf(this.fullName) + c2)) {
            n = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n];
        int n2 = n;
        while (n2 < listInfoArray.length) {
            folderArray[n2 - n] = new IMAPFolder(listInfoArray[n2], (IMAPStore)this.store);
            ++n2;
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            listInfoArray = (ListInfo[])this.doCommand(new 3());
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        try {
            listInfoArray = (ListInfo[])this.doProtocolCommand(new 4());
        }
        catch (ProtocolException protocolException) {}
        return listInfoArray != null;
    }

    public void setSubscribed(boolean bl) throws MessagingException {
        this.checkExists();
        this.doCommandIgnoreFailure(new 5(bl, this));
    }

    public synchronized boolean create(int n) throws MessagingException {
        char c2;
        Object object2;
        char c3 = '\u0000';
        if ((n & 1) == 0) {
            c3 = this.getSeparator0();
        }
        if ((object2 = this.doCommandIgnoreFailure(new 6(c2 = c3, this, n))) == null) {
            return false;
        }
        this.exists = true;
        this.type = n;
        this.notifyFolderListeners(1);
        return true;
    }

    public synchronized boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            return this.recent > 0;
        }
        Boolean bl = (Boolean)this.doCommandIgnoreFailure(new 7());
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c2 = this.getSeparator0();
        return new IMAPFolder(String.valueOf(this.fullName) + c2 + string, c2, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean bl) throws MessagingException {
        Object object2;
        this.checkClosed();
        if (bl) {
            object2 = this.list();
            int n = 0;
            while (n < ((Folder[])object2).length) {
                object2[n].delete(bl);
                ++n;
            }
        }
        if ((object2 = this.doCommandIgnoreFailure(new 8())) == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object object2 = this.doCommandIgnoreFailure(new 9(folder, this));
        if (object2 == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    public synchronized void open(int n) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            this.protocol.addResponseHandler(this);
            try {
                mailboxInfo = n == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (CommandFailedException commandFailedException) {
                this.releaseProtocol(true);
                this.protocol = null;
                throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
            }
            catch (ProtocolException protocolException) {
                try {
                    try {
                        this.protocol.logout();
                    }
                    catch (ProtocolException protocolException2) {}
                }
                catch (Throwable throwable) {}
                this.releaseProtocol(false);
                this.protocol = null;
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (!(mailboxInfo.mode == n || n == 2 && mailboxInfo.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                try {
                    try {
                        this.protocol.close();
                        this.releaseProtocol(true);
                    }
                    catch (ProtocolException protocolException) {
                        try {
                            try {
                                this.protocol.logout();
                            }
                            catch (ProtocolException protocolException3) {
                            }
                            Object var6_8 = null;
                            this.releaseProtocol(false);
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            this.releaseProtocol(false);
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {}
                this.protocol = null;
                throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.messageCache = new Vector(this.total);
            int n2 = 0;
            while (n2 < this.total) {
                this.messageCache.addElement(new IMAPMessage(this, n2 + 1, n2 + 1));
                ++n2;
            }
        }
        this.notifyConnectionListeners(1);
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            try {
                this.protocol.storeFlags(Utility.toMessageSet(messageArray, null), flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            return;
        }
    }

    public synchronized void close(boolean bl) throws MessagingException {
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            if (!this.opened && this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            this.reallyClosed = true;
            if (!this.opened) {
                Object var3_3 = null;
                return;
            }
            try {
                block19: {
                    try {
                        block20: {
                            if (((IMAPStore)this.store).isConnectionPoolFull()) {
                                if (this.debug) {
                                    this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                                }
                                if (bl) {
                                    this.protocol.close();
                                }
                                if (this.protocol != null) {
                                    this.protocol.logout();
                                }
                                break block19;
                            }
                            if (!bl && this.mode == 2) {
                                try {
                                    this.protocol.examine(this.fullName);
                                }
                                catch (ProtocolException protocolException) {
                                    if (this.protocol == null) break block20;
                                    this.protocol.disconnect();
                                }
                            }
                        }
                        if (this.protocol != null) {
                            this.protocol.close();
                        }
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                Object var5_5 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.opened) {
                    this.cleanup(true);
                }
                throw throwable;
            }
            return;
        }
    }

    private void cleanup(boolean bl) {
        this.releaseProtocol(bl);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    public synchronized boolean isOpen() {
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {}
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                        iMAPProtocol.close();
                        int n = mailboxInfo.total;
                        Object var4_10 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            try {
                this.keepConnectionAlive(true);
                int n = this.total;
                Object var3_15 = null;
                return n;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    try {
                        iMAPProtocol = this.getStoreProtocol();
                        MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                        iMAPProtocol.close();
                        int n = mailboxInfo.recent;
                        Object var4_10 = null;
                        this.releaseStoreProtocol(iMAPProtocol);
                        return n;
                    }
                    catch (ProtocolException protocolException) {
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    this.releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            try {
                this.keepConnectionAlive(true);
                int n = this.recent;
                Object var3_15 = null;
                return n;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, false));
                int n = nArray.length;
                Object var4_10 = null;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.DELETED);
        try {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, true));
                int n = nArray.length;
                Object var4_7 = null;
                return n;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    private Status getStatus() throws ProtocolException {
        int n = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            Status status = iMAPProtocol.status(this.fullName, null);
            if (n > 0) {
                this.cachedStatus = status;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status2 = status;
            Object var5_5 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            return status2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpened();
        this.checkRange(n);
        return (Message)this.messageCache.elementAt(n - 1);
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n = ((IMAPStore)this.store).getAppendBufferSize();
        int n2 = 0;
        while (n2 < messageArray.length) {
            block5: {
                MessageLiteral messageLiteral;
                Message message = messageArray[n2];
                try {
                    messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
                }
                catch (IOException iOException) {
                    throw new MessagingException("IOException while appending messages", iOException);
                }
                catch (MessageRemovedException messageRemovedException) {
                    break block5;
                }
                Date date = message.getReceivedDate();
                if (date == null) {
                    date = message.getSentDate();
                }
                Date date2 = date;
                Flags flags = message.getFlags();
                this.doCommand(new 10(date2, flags, messageLiteral, this));
            }
            ++n2;
        }
    }

    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                try {
                    this.protocol.copy(Utility.toMessageSet(messageArray, null), folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, String.valueOf(folder.getFullName()) + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                return;
            }
        }
        super.copyMessages(messageArray, folder);
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object[] objectArray = this.messageCacheLock;
        synchronized (objectArray) {
            IMAPMessage iMAPMessage;
            this.doExpungeNotification = false;
            try {
                try {
                    this.protocol.expunge();
                }
                catch (CommandFailedException commandFailedException) {
                    if (this.mode != 2) {
                        throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                iMAPMessage = null;
                this.doExpungeNotification = true;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.doExpungeNotification = true;
                throw throwable;
            }
            int n = 0;
            while (n < this.messageCache.size()) {
                iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n);
                if (iMAPMessage.isExpunged()) {
                    long l;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n);
                    if (this.uidTable == null || (l = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n;
            }
        }
        this.total = this.messageCache.size();
        objectArray = new Message[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            this.notifyMessageRemovedListeners(true, (Message[])objectArray);
        }
        return objectArray;
    }

    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                int[] nArray = this.protocol.search(Utility.toMessageSet(messageArray, null), searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        messageArray2[n] = this.getMessageBySeqNumber(nArray[n]);
                        ++n;
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            try {
                iMAPProtocol = this.getStoreProtocol();
                String[] stringArray = new String[]{"UIDVALIDITY"};
                status = iMAPProtocol.status(this.fullName, stringArray);
            }
            catch (BadCommandException badCommandException) {
                throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
            }
            catch (ConnectionException connectionException) {
                this.throwClosedException(connectionException);
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            Object var4_7 = null;
            this.releaseStoreProtocol(iMAPProtocol);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.releaseStoreProtocol(iMAPProtocol);
            throw throwable;
        }
        return status.uidvalidity;
    }

    public synchronized Message getMessageByUID(long l) throws MessagingException {
        this.checkOpened();
        Long l2 = new Long(l);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)this.uidTable.get(l2);
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                UID uID = this.protocol.fetchSequenceNumber(l);
                if (uID != null) {
                    iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uID.msgno - 1);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l2, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return iMAPMessage;
    }

    public synchronized Message[] getMessagesByUID(long l, long l2) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object2 = this.messageCacheLock;
            synchronized (object2) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l, l2);
                messageArray = new Message[uIDArray.length];
                int n = 0;
                while (n < uIDArray.length) {
                    IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n].msgno - 1);
                    iMAPMessage.setUID(uIDArray[n].uid);
                    messageArray[n] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                    ++n;
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            messageArray = new Vector();
            int n2 = 0;
            while (n2 < lArray.length) {
                Long l = new Long(lArray[n2]);
                if (!this.uidTable.containsKey(l)) {
                    messageArray.addElement(l);
                }
                ++n2;
            }
            int n3 = messageArray.size();
            lArray2 = new long[n3];
            n = 0;
            while (n < n3) {
                lArray2[n] = (Long)messageArray.elementAt(n);
                ++n;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    UID[] uIDArray = this.protocol.fetchSequenceNumbers(lArray2);
                    n = 0;
                    while (n < uIDArray.length) {
                        IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n].msgno - 1);
                        iMAPMessage.setUID(uIDArray[n].uid);
                        this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                        ++n;
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        int n4 = 0;
        while (n4 < lArray.length) {
            messageArray[n4] = (Message)this.uidTable.get(new Long(lArray[n4]));
            ++n4;
        }
        return messageArray;
    }

    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l = iMAPMessage.getUID();
        if (l != -1L) {
            return l;
        }
        UID uID = null;
        Object object2 = this.messageCacheLock;
        synchronized (object2) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (uID != null) {
            l = uID.uid;
            iMAPMessage.setUID(l);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l), iMAPMessage);
        }
        return l;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", new 11());
    }

    public void setQuota(Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", new 12(quota));
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", new 13());
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(String string) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new 14(string, this));
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(String string) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", new 15(string, this));
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", new 16());
    }

    private void setACL(ACL aCL, char c2) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new 17(aCL, c2, this));
    }

    public void handleResponse(Response response) {
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            return;
        }
        if (!response.isUnTagged()) {
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            this.out.println("UNEXPECTED RESPONSE : " + response.toString());
            this.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n = iMAPResponse.getNumber();
            if (n <= this.realTotal) {
                return;
            }
            int n2 = n - this.realTotal;
            Message[] messageArray = new Message[n2];
            int n3 = 0;
            while (n3 < n2) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[n3] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
                ++n3;
            }
            this.notifyMessageAddedListeners(messageArray);
            return;
        }
        if (iMAPResponse.keyEquals("EXPUNGE")) {
            Message[] messageArray;
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            int n = iMAPMessage.getMessageNumber();
            while (n < this.total) {
                messageArray = (Message[])this.messageCache.elementAt(n);
                if (!messageArray.isExpunged()) {
                    messageArray.setSequenceNumber(messageArray.getSequenceNumber() - 1);
                }
                ++n;
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
                return;
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            IMAPMessage iMAPMessage;
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(class$javax$mail$Flags != null ? class$javax$mail$Flags : (class$javax$mail$Flags = IMAPFolder.class$("javax.mail.Flags"))));
            if (flags != null && (iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber())) != null) {
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
                return;
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        int n = 0;
        while (n < responseArray.length) {
            if (responseArray[n] != null) {
                this.handleResponse(responseArray[n]);
            }
            ++n;
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.connectionPoolDebug) {
            this.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(ConnectionException connectionException) throws FolderClosedException, StoreClosedException {
        if (connectionException.getProtocol() == this.protocol) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        throw new StoreClosedException(this.store, connectionException.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doOptionalCommand(String string, ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException(string, badCommandException);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (CommandFailedException commandFailedException) {
            return null;
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object doProtocolCommand(ProtocolCommand protocolCommand) throws ProtocolException {
        Object object2 = this;
        synchronized (object2) {
            if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
                Object object4 = this.messageCacheLock;
                synchronized (object4) {
                    return protocolCommand.doCommand(this.getProtocol());
                }
            }
        }
        object2 = null;
        try {
            object2 = this.getStoreProtocol();
            Object object5 = protocolCommand.doCommand((IMAPProtocol)object2);
            Object var5_4 = null;
            this.releaseStoreProtocol((IMAPProtocol)object2);
            return object5;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseStoreProtocol((IMAPProtocol)object2);
            throw throwable;
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private void releaseProtocol(boolean bl) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
                return;
            }
            ((IMAPStore)this.store).releaseProtocol(this, null);
        }
    }

    private void keepConnectionAlive(boolean bl) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (bl && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol;
            block4: {
                iMAPProtocol = null;
                try {
                    iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                    if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() <= 1000L) break block4;
                    iMAPProtocol.noop();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
                    throw throwable;
                }
            }
            Object var4_3 = null;
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            return;
        }
    }

    IMAPMessage getMessageBySeqNumber(int n) {
        int n2 = n - 1;
        while (n2 < this.total) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n2);
            if (iMAPMessage.getSequenceNumber() == n) {
                return iMAPMessage;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String string) {
            super(string);
        }
    }

    private final class 1
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.list("", IMAPFolder.this.fullName);
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements ProtocolCommand {
        private final /* synthetic */ String val$pattern;
        private final /* synthetic */ char val$c;
        private final /* synthetic */ IMAPFolder this$0;
        private final /* synthetic */ boolean val$subscribed;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            if (this.val$subscribed) {
                return iMAPProtocol.lsub("", String.valueOf(this.this$0.fullName) + this.val$c + this.val$pattern);
            }
            return iMAPProtocol.list("", String.valueOf(this.this$0.fullName) + this.val$c + this.val$pattern);
        }

        /* synthetic */ 2(char c2, String string, boolean bl, IMAPFolder iMAPFolder) {
            this.val$c = c2;
            this.val$pattern = string;
            this.val$subscribed = bl;
            this.this$0 = iMAPFolder;
        }
    }

    private final class 3
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            if (iMAPProtocol.isREV1()) {
                return iMAPProtocol.list(IMAPFolder.this.fullName, "");
            }
            return iMAPProtocol.list("", IMAPFolder.this.fullName);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.lsub("", IMAPFolder.this.fullName);
        }

        /* synthetic */ 4() {
        }
    }

    private static final class 5
    implements ProtocolCommand {
        private final /* synthetic */ IMAPFolder this$0;
        private final /* synthetic */ boolean val$subscribe;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            if (this.val$subscribe) {
                iMAPProtocol.subscribe(this.this$0.fullName);
            } else {
                iMAPProtocol.unsubscribe(this.this$0.fullName);
            }
            return null;
        }

        /* synthetic */ 5(boolean bl, IMAPFolder iMAPFolder) {
            this.val$subscribe = bl;
            this.this$0 = iMAPFolder;
        }
    }

    private static final class 6
    implements ProtocolCommand {
        private final /* synthetic */ char val$sep;
        private final /* synthetic */ IMAPFolder this$0;
        private final /* synthetic */ int val$type;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            if ((this.val$type & 1) == 0) {
                iMAPProtocol.create(String.valueOf(this.this$0.fullName) + this.val$sep);
            } else {
                ListInfo[] listInfoArray;
                iMAPProtocol.create(this.this$0.fullName);
                if ((this.val$type & 2) != 0 && (listInfoArray = iMAPProtocol.list("", this.this$0.fullName)) != null && !listInfoArray[0].hasInferiors) {
                    iMAPProtocol.delete(this.this$0.fullName);
                    throw new ProtocolException("Unsupported type");
                }
            }
            return Boolean.TRUE;
        }

        /* synthetic */ 6(char c2, IMAPFolder iMAPFolder, int n) {
            this.val$sep = c2;
            this.this$0 = iMAPFolder;
            this.val$type = n;
        }
    }

    private final class 7
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            ListInfo[] listInfoArray = iMAPProtocol.list("", IMAPFolder.this.fullName);
            if (listInfoArray != null) {
                if (listInfoArray[0].changeState == 1) {
                    return Boolean.TRUE;
                }
                if (listInfoArray[0].changeState == 2) {
                    return Boolean.FALSE;
                }
            }
            Status status = IMAPFolder.this.getStatus();
            if (status.recent > 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.delete(IMAPFolder.this.fullName);
            return Boolean.TRUE;
        }

        /* synthetic */ 8() {
        }
    }

    private static final class 9
    implements ProtocolCommand {
        private final /* synthetic */ Folder val$f;
        private final /* synthetic */ IMAPFolder this$0;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.rename(this.this$0.fullName, this.val$f.getFullName());
            return Boolean.TRUE;
        }

        /* synthetic */ 9(Folder folder, IMAPFolder iMAPFolder) {
            this.val$f = folder;
            this.this$0 = iMAPFolder;
        }
    }

    private static final class 10
    implements ProtocolCommand {
        private final /* synthetic */ MessageLiteral val$mos;
        private final /* synthetic */ Date val$dd;
        private final /* synthetic */ Flags val$f;
        private final /* synthetic */ IMAPFolder this$0;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.append(this.this$0.fullName, this.val$f, this.val$dd, this.val$mos);
            return null;
        }

        /* synthetic */ 10(Date date, Flags flags, MessageLiteral messageLiteral, IMAPFolder iMAPFolder) {
            this.val$dd = date;
            this.val$f = flags;
            this.val$mos = messageLiteral;
            this.this$0 = iMAPFolder;
        }
    }

    private final class 11
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.getQuotaRoot(IMAPFolder.this.fullName);
        }

        /* synthetic */ 11() {
        }
    }

    private static final class 12
    implements ProtocolCommand {
        private final /* synthetic */ Quota val$quota;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.setQuota(this.val$quota);
            return null;
        }

        /* synthetic */ 12(Quota quota) {
            this.val$quota = quota;
        }
    }

    private final class 13
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.getACL(IMAPFolder.this.fullName);
        }

        /* synthetic */ 13() {
        }
    }

    private static final class 14
    implements ProtocolCommand {
        private final /* synthetic */ String val$name;
        private final /* synthetic */ IMAPFolder this$0;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.deleteACL(this.this$0.fullName, this.val$name);
            return null;
        }

        /* synthetic */ 14(String string, IMAPFolder iMAPFolder) {
            this.val$name = string;
            this.this$0 = iMAPFolder;
        }
    }

    private static final class 15
    implements ProtocolCommand {
        private final /* synthetic */ String val$name;
        private final /* synthetic */ IMAPFolder this$0;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.listRights(this.this$0.fullName, this.val$name);
        }

        /* synthetic */ 15(String string, IMAPFolder iMAPFolder) {
            this.val$name = string;
            this.this$0 = iMAPFolder;
        }
    }

    private final class 16
    implements ProtocolCommand {
        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            return iMAPProtocol.myRights(IMAPFolder.this.fullName);
        }

        /* synthetic */ 16() {
        }
    }

    private static final class 17
    implements ProtocolCommand {
        private final /* synthetic */ ACL val$acl;
        private final /* synthetic */ char val$mod;
        private final /* synthetic */ IMAPFolder this$0;

        public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
            iMAPProtocol.setACL(this.this$0.fullName, this.val$mod, this.val$acl);
            return null;
        }

        /* synthetic */ 17(ACL aCL, char c2, IMAPFolder iMAPFolder) {
            this.val$acl = aCL;
            this.val$mod = c2;
            this.this$0 = iMAPFolder;
        }
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }
}

