/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.activation.SecuritySupport;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static MimeTypeFile defDB = null;
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static String defaultType = "application/octet-stream";
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$activation$MimetypesFileTypeMap;

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable throwable) {}
    }

    public MimetypesFileTypeMap() {
        Object object2;
        Vector<MimeTypeFile> vector = new Vector<MimeTypeFile>(5);
        MimeTypeFile mimeTypeFile = null;
        vector.addElement(null);
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load HOME");
        }
        try {
            String string;
            object2 = System.getProperty("user.home");
            if (object2 != null && (mimeTypeFile = this.loadFile(string = String.valueOf(object2) + File.separator + ".mime.types")) != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load SYS");
        }
        try {
            object2 = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "mime.types";
            mimeTypeFile = this.loadFile((String)object2);
            if (mimeTypeFile != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load JAR");
        }
        this.loadAllResources(vector, "META-INF/mime.types");
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load DEF");
        }
        object2 = class$javax$activation$MimetypesFileTypeMap != null ? class$javax$activation$MimetypesFileTypeMap : (class$javax$activation$MimetypesFileTypeMap = MimetypesFileTypeMap.class$("javax.activation.MimetypesFileTypeMap"));
        synchronized (object2) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mimetypes.default");
            }
        }
        if (defDB != null) {
            vector.addElement(defDB);
        }
        this.DB = new MimeTypeFile[vector.size()];
        vector.copyInto(this.DB);
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(inputStream);
        }
        catch (IOException iOException) {}
    }

    public MimetypesFileTypeMap(String string) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(string);
    }

    public synchronized void addMimeTypes(String string) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public synchronized String getContentType(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return defaultType;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() == 0) {
            return defaultType;
        }
        int n2 = 0;
        while (n2 < this.DB.length) {
            String string3;
            if (this.DB[n2] != null && (string3 = this.DB[n2].getMIMETypeString(string2)) != null) {
                return string3;
            }
            ++n2;
        }
        return defaultType;
    }

    private void loadAllResources(Vector vector, String string) {
        Object object2;
        boolean bl;
        block24: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getInstance().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object2 = classLoader != null ? SecuritySupport.getInstance().getResources(classLoader, string) : SecuritySupport.getInstance().getSystemResources(string)) == null) break block24;
                if (debug) {
                    MimetypesFileTypeMap.pr("MimetypesFileTypeMap: getResources");
                }
                int n = 0;
                while (n < ((URL[])object2).length) {
                    Object var10_10;
                    URL uRL = object2[n];
                    InputStream inputStream = null;
                    if (debug) {
                        MimetypesFileTypeMap.pr("MimetypesFileTypeMap: URL " + uRL);
                    }
                    try {
                        block25: {
                            try {
                                inputStream = SecuritySupport.getInstance().openStream(uRL);
                                if (inputStream != null) {
                                    vector.addElement(new MimeTypeFile(inputStream));
                                    bl = true;
                                    if (debug) {
                                        MimetypesFileTypeMap.pr("MimetypesFileTypeMap: successfully loaded mime types from URL: " + uRL);
                                    }
                                } else if (debug) {
                                    MimetypesFileTypeMap.pr("MimetypesFileTypeMap: not loading mime types from URL: " + uRL);
                                }
                            }
                            catch (IOException iOException) {
                                if (debug) {
                                    MimetypesFileTypeMap.pr("MimetypesFileTypeMap: " + iOException);
                                }
                            }
                            catch (SecurityException securityException) {
                                if (!debug) break block25;
                                MimetypesFileTypeMap.pr("MimetypesFileTypeMap: " + securityException);
                            }
                        }
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!debug) break block24;
                MimetypesFileTypeMap.pr("MimetypesFileTypeMap: " + exception);
            }
        }
        if (!bl) {
            if (debug) {
                MimetypesFileTypeMap.pr("MimetypesFileTypeMap: !anyLoaded");
            }
            if ((object2 = this.loadResource("/" + string)) != null) {
                vector.addElement(object2);
            }
        }
    }

    private MimeTypeFile loadFile(String string) {
        MimeTypeFile mimeTypeFile = null;
        try {
            mimeTypeFile = new MimeTypeFile(string);
        }
        catch (IOException iOException) {}
        return mimeTypeFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MimeTypeFile loadResource(String string) {
        InputStream inputStream;
        block15: {
            MimeTypeFile mimeTypeFile;
            block14: {
                inputStream = null;
                try {
                    try {
                        inputStream = SecuritySupport.getInstance().getResourceAsStream(this.getClass(), string);
                        if (inputStream != null) {
                            MimeTypeFile mimeTypeFile2 = new MimeTypeFile(inputStream);
                            if (debug) {
                                MimetypesFileTypeMap.pr("MimetypesFileTypeMap: successfully loaded mime types file: " + string);
                            }
                            mimeTypeFile = mimeTypeFile2;
                            Object var5_7 = null;
                            break block14;
                        }
                        if (debug) {
                            MimetypesFileTypeMap.pr("MimetypesFileTypeMap: not loading mime types file: " + string);
                        }
                        break block15;
                    }
                    catch (IOException iOException) {
                        if (debug) {
                            MimetypesFileTypeMap.pr("MimetypesFileTypeMap: " + iOException);
                            iOException.printStackTrace();
                        }
                        break block15;
                    }
                    catch (SecurityException securityException) {
                        if (debug) {
                            MimetypesFileTypeMap.pr("MimetypesFileTypeMap: " + securityException);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (inputStream == null) return mimeTypeFile;
            inputStream.close();
            return mimeTypeFile;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream == null) return null;
        inputStream.close();
        return null;
    }

    private static final void pr(String string) {
        System.out.println(string);
    }
}

